/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationEnumeration;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.ba.ch.Subtypes;
import edu.umd.cs.findbugs.util.MapCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDatabase<AnnotationEnum extends AnnotationEnumeration<AnnotationEnum>> {
    static final boolean DEBUG = SystemProperties.getBoolean("annotations.debug");
    public static final String FIELD = "Field";
    public static final String METHOD = "Method";
    public static final String PARAMETER = "Parameter";
    public static final String ANY = "Any";
    private static final String DEFAULT_ANNOTATION_ANNOTATION_CLASS = "DefaultAnnotation";
    private Map<Object, AnnotationEnum> directAnnotations = new HashMap<Object, AnnotationEnum>();
    private Set<Object> syntheticElements = new HashSet<Object>();
    private final Map<String, Map<String, AnnotationEnum>> defaultAnnotation = new HashMap<String, Map<String, AnnotationEnum>>();
    private Subtypes subtypes;
    private final Set<AnnotationEnum> seen = new HashSet<AnnotationEnum>();
    Map<Object, AnnotationEnum> cachedMinimal = new MapCache<Object, AnnotationEnum>(20000);
    Map<Object, AnnotationEnum> cachedMaximal = new MapCache<Object, AnnotationEnum>(20000);
    boolean addClassOnly = false;

    public AnnotationDatabase() {
        this.defaultAnnotation.put(ANY, new HashMap());
        this.defaultAnnotation.put(PARAMETER, new HashMap());
        this.defaultAnnotation.put(METHOD, new HashMap());
        this.defaultAnnotation.put(FIELD, new HashMap());
        this.subtypes = AnalysisContext.currentAnalysisContext().getSubtypes();
    }

    public void loadAuxiliaryAnnotations() {
    }

    public void addSyntheticElement(Object o) {
        this.syntheticElements.add(o);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Synthetic element: ").append(o).toString());
        }
    }

    public void addDirectAnnotation(Object o, AnnotationEnum n) {
        this.directAnnotations.put(o, n);
        this.seen.add(n);
    }

    public void addDefaultAnnotation(String target, String c, AnnotationEnum n) {
        if (!this.defaultAnnotation.containsKey(target)) {
            return;
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Default annotation ").append(target).append(" ").append(c).append(" ").append(n).toString());
        }
        this.defaultAnnotation.get(target).put(c, n);
        this.seen.add(n);
    }

    public boolean anyAnnotations(AnnotationEnum n) {
        return this.seen.contains(n);
    }

    @CheckForNull
    public AnnotationEnum getResolvedAnnotation(Object o, boolean getMinimal) {
        Map<Object, AnnotationEnum> cache = getMinimal ? this.cachedMinimal : this.cachedMaximal;
        if (cache.containsKey(o)) {
            return (AnnotationEnum)((AnnotationEnumeration)cache.get(o));
        }
        AnnotationEnum n = this.getUncachedResolvedAnnotation(o, getMinimal);
        if (DEBUG) {
            System.out.println(new StringBuffer().append("TTT: ").append(o).append(" ").append(n).toString());
        }
        cache.put(o, n);
        return n;
    }

    public boolean annotationIsDirect(Object o) {
        return this.directAnnotations.containsKey(o);
    }

    @CheckForNull
    public AnnotationEnum getUncachedResolvedAnnotation(Object o, boolean getMinimal) {
        AnnotationEnumeration<Object> n = (AnnotationEnumeration)this.directAnnotations.get(o);
        if (n != null) {
            return (AnnotationEnum)n;
        }
        try {
            String className;
            String kind;
            boolean isParameterToInitMethodofAnonymousInnerClass = false;
            boolean isSyntheticMethod = false;
            if (o instanceof XMethod || o instanceof XMethodParameter) {
                XMethod m;
                if (o instanceof XMethod) {
                    m = (XMethod)o;
                    isSyntheticMethod = this.syntheticElements.contains(m);
                    kind = METHOD;
                    className = m.getClassName();
                } else if (o instanceof XMethodParameter) {
                    int i;
                    m = ((XMethodParameter)o).getMethod();
                    isSyntheticMethod = this.syntheticElements.contains(m);
                    className = m.getClassName();
                    kind = PARAMETER;
                    if (m.getName().equals("<init>") && (i = className.lastIndexOf("$")) + 1 < className.length() && Character.isDigit(className.charAt(i + 1))) {
                        isParameterToInitMethodofAnonymousInnerClass = true;
                    }
                } else {
                    throw new IllegalStateException("impossible");
                }
                if (!m.isStatic() && !m.getName().equals("<init>")) {
                    JavaClass c = Repository.lookupClass(className);
                    TreeSet<AnnotationEnumeration> inheritedAnnotations = new TreeSet<AnnotationEnumeration>();
                    if (c.getSuperclassNameIndex() > 0 && (n = this.lookInOverriddenMethod(o, c.getSuperclassName(), m, getMinimal)) != null) {
                        inheritedAnnotations.add(n);
                    }
                    for (String implementedInterface : c.getInterfaceNames()) {
                        n = this.lookInOverriddenMethod(o, implementedInterface, m, getMinimal);
                        if (n == null) continue;
                        inheritedAnnotations.add(n);
                    }
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("# of inherited annotations : ").append(inheritedAnnotations.size()).toString());
                    }
                    if (!inheritedAnnotations.isEmpty()) {
                        if (inheritedAnnotations.size() == 1) {
                            return (AnnotationEnum)((AnnotationEnumeration)inheritedAnnotations.first());
                        }
                        if (!getMinimal) {
                            return (AnnotationEnum)((AnnotationEnumeration)inheritedAnnotations.last());
                        }
                        AnnotationEnumeration min = (AnnotationEnumeration)inheritedAnnotations.first();
                        if (min.getIndex() == 0) {
                            inheritedAnnotations.remove(min);
                            min = (AnnotationEnumeration)inheritedAnnotations.first();
                        }
                        return (AnnotationEnum)min;
                    }
                    if (!this.classDefinesMethod(c, m)) {
                        return null;
                    }
                    if (DEBUG) {
                        System.out.println(new StringBuffer().append("looking for default annotations: ").append(c.getClassName()).append(" defines ").append(m).toString());
                    }
                }
            } else if (o instanceof XField) {
                className = ((XField)o).getClassName();
                kind = FIELD;
            } else if (o instanceof String) {
                className = (String)o;
                kind = "CLASS";
            } else {
                throw new IllegalArgumentException(new StringBuffer().append("Can't look up annotation for ").append(o.getClass().getName()).toString());
            }
            if (isParameterToInitMethodofAnonymousInnerClass) {
                return null;
            }
            if (isSyntheticMethod) {
                return null;
            }
            if (this.syntheticElements.contains(o)) {
                return null;
            }
            if (this.syntheticElements.contains(className)) {
                return null;
            }
            n = (AnnotationEnumeration)this.defaultAnnotation.get(kind).get(className);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Default annotation for ").append(kind).append(" is ").append(n).toString());
            }
            if (n != null) {
                return (AnnotationEnum)n;
            }
            n = (AnnotationEnumeration)this.defaultAnnotation.get(ANY).get(className);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Default annotation for any is ").append(n).toString());
            }
            if (n != null) {
                return (AnnotationEnum)n;
            }
            int p = className.lastIndexOf(46);
            className = new StringBuffer().append(className.substring(0, p + 1)).append("package-info").toString();
            n = (AnnotationEnumeration)this.defaultAnnotation.get(kind).get(className);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Default annotation for ").append(kind).append(" is ").append(n).toString());
            }
            if (n != null) {
                return (AnnotationEnum)n;
            }
            n = (AnnotationEnumeration)this.defaultAnnotation.get(ANY).get(className);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Default annotation for any is ").append(n).toString());
            }
            if (n != null) {
                return (AnnotationEnum)n;
            }
            return (AnnotationEnum)n;
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return null;
        }
    }

    private boolean classDefinesMethod(JavaClass c, XMethod m) {
        for (Method definedMethod : c.getMethods()) {
            if (!definedMethod.getName().equals(m.getName()) || !definedMethod.getSignature().equals(m.getSignature()) || definedMethod.isStatic() != m.isStatic()) continue;
            return true;
        }
        return false;
    }

    private AnnotationEnum lookInOverriddenMethod(Object originalQuery, String classToLookIn, XMethod originalMethod, boolean getMinimal) {
        try {
            Comparable<ClassMember> probe;
            XMethod superMethod = XFactory.createXMethod(classToLookIn, originalMethod.getName(), originalMethod.getSignature(), originalMethod.isStatic());
            if (!superMethod.isResolved()) {
                return null;
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Looking for overridden method ").append(superMethod).toString());
            }
            if (originalQuery instanceof XMethod) {
                probe = superMethod;
            } else if (originalQuery instanceof XMethodParameter) {
                probe = new XMethodParameter(superMethod, ((XMethodParameter)originalQuery).getParameterNumber());
            } else {
                throw new IllegalStateException("impossible");
            }
            AnnotationEnum n = this.getResolvedAnnotation(probe, getMinimal);
            return n;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public boolean setAddClassOnly(boolean newValue) {
        boolean oldValue = this.addClassOnly;
        this.addClassOnly = newValue;
        return oldValue;
    }

    protected void addDefaultMethodAnnotation(String cName, AnnotationEnum annotation) {
        this.subtypes.addNamedClass(cName);
        if (this.addClassOnly) {
            return;
        }
        this.addDefaultAnnotation(METHOD, cName, annotation);
    }

    protected void addFieldAnnotation(String cName, String mName, String mSig, boolean isStatic, AnnotationEnum annotation) {
        this.subtypes.addNamedClass(cName);
        if (this.addClassOnly) {
            return;
        }
        XField m = XFactory.createXField(cName, mName, mSig, isStatic);
        this.addDirectAnnotation(m, annotation);
    }

    protected void addMethodAnnotation(String cName, String mName, String mSig, boolean isStatic, AnnotationEnum annotation) {
        this.subtypes.addNamedClass(cName);
        if (this.addClassOnly) {
            return;
        }
        XMethod m = XFactory.createXMethod(cName, mName, mSig, isStatic);
        this.addDirectAnnotation(m, annotation);
    }

    protected void addMethodParameterAnnotation(String cName, String mName, String mSig, boolean isStatic, int param, AnnotationEnum annotation) {
        this.subtypes.addNamedClass(cName);
        if (this.addClassOnly) {
            return;
        }
        SignatureParser parser = new SignatureParser(mSig);
        if (param < 0 || param >= parser.getNumParameters()) {
            throw new IllegalArgumentException(new StringBuffer().append("can't annotation parameter #").append(param).append(" of ").append(cName).append(".").append(mName).append(mSig).toString());
        }
        XMethod m = XFactory.createXMethod(cName, mName, mSig, isStatic);
        this.addDirectAnnotation(new XMethodParameter(m, param), annotation);
    }
}

