/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;

public class MethodAnnotation
extends PackageMemberAnnotation {
    private static final long serialVersionUID = 1L;
    private static final boolean UGLY_METHODS;
    private static final String DEFAULT_ROLE = "METHOD_DEFAULT";
    private String methodName;
    private String methodSig;
    private String fullMethod;
    private boolean isStatic;
    String nameInClass = null;
    private static final String ELEMENT_NAME = "Method";
    static final /* synthetic */ boolean $assertionsDisabled;

    public MethodAnnotation(String className, String methodName, String methodSig, boolean isStatic) {
        super(className, DEFAULT_ROLE);
        this.methodName = methodName;
        if (methodSig.indexOf(".") >= 0) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("signatures should not be dotted: " + methodSig));
            }
            methodSig = methodSig.replace('.', '/');
        }
        this.methodSig = methodSig;
        this.isStatic = isStatic;
        this.fullMethod = null;
        this.sourceLines = null;
    }

    public static MethodAnnotation fromVisitedMethod(PreorderVisitor visitor) {
        String className = visitor.getDottedClassName();
        MethodAnnotation result = new MethodAnnotation(className, visitor.getMethodName(), visitor.getMethodSig(), visitor.getMethod().isStatic());
        SourceLineAnnotation srcLines = SourceLineAnnotation.fromVisitedMethod(visitor);
        result.setSourceLines(srcLines);
        return result;
    }

    public static MethodAnnotation fromCalledMethod(DismantleBytecode visitor) {
        String className = visitor.getDottedClassConstantOperand();
        String methodName = visitor.getNameConstantOperand();
        String methodSig = visitor.getSigConstantOperand();
        return MethodAnnotation.fromCalledMethod(className, methodName, methodSig, visitor.getOpcode() == 184);
    }

    public static MethodAnnotation fromForeignMethod(String className, String methodName, String methodSig, boolean isStatic) {
        SourceInfoMap.SourceLineRange range;
        className = ClassName.toDottedClassName(className);
        MethodAnnotation methodAnnotation = new MethodAnnotation(className, methodName, methodSig, isStatic);
        SourceLineAnnotation sourceLines = null;
        try {
            JavaClass targetClass = AnalysisContext.currentAnalysisContext().lookupClass(className);
            JavaClassAndMethod targetMethod = Hierarchy.findMethod(targetClass, methodName, methodSig);
            if (targetMethod != null) {
                sourceLines = SourceLineAnnotation.forEntireMethod(targetMethod.getJavaClass(), targetMethod.getMethod());
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (sourceLines == null && (range = AnalysisContext.currentAnalysisContext().getSourceInfoMap().getMethodLine(className, methodName, methodSig)) != null) {
            sourceLines = new SourceLineAnnotation(className, AnalysisContext.currentAnalysisContext().lookupSourceFile(className), range.getStart(), range.getEnd(), -1, -1);
        }
        if (sourceLines == null) {
            sourceLines = SourceLineAnnotation.createUnknown(className);
        }
        methodAnnotation.setSourceLines(sourceLines);
        return methodAnnotation;
    }

    public static MethodAnnotation fromCalledMethod(String className, String methodName, String methodSig, boolean isStatic) {
        MethodAnnotation methodAnnotation = MethodAnnotation.fromForeignMethod(className, methodName, methodSig, isStatic);
        methodAnnotation.setDescription("METHOD_CALLED");
        return methodAnnotation;
    }

    public static MethodAnnotation fromXMethod(XMethod xmethod) {
        return MethodAnnotation.fromForeignMethod(xmethod.getClassName(), xmethod.getName(), xmethod.getSignature(), xmethod.isStatic());
    }

    public static BugAnnotation fromMethodDescriptor(MethodDescriptor methodDescriptor) {
        return MethodAnnotation.fromForeignMethod(methodDescriptor.getClassName(), methodDescriptor.getName(), methodDescriptor.getSignature(), methodDescriptor.isStatic());
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getJavaSourceMethodName() {
        if (this.methodName.equals("<clinit>")) {
            return "<static initializer>";
        }
        if (this.methodName.equals("<init>")) {
            String result = this.getClassName();
            int pos = Math.max(result.lastIndexOf(36), result.lastIndexOf(46));
            return this.className.substring(pos + 1);
        }
        return this.methodName;
    }

    public String getMethodSignature() {
        return this.methodSig;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public XMethod toXMethod() {
        return XFactory.createXMethod(this.className, this.methodName, this.methodSig, this.isStatic);
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitMethodAnnotation(this);
    }

    protected String formatPackageMember(String key, ClassAnnotation primaryClass) {
        if (key.equals("")) {
            return UGLY_METHODS ? this.getUglyMethod() : this.getFullMethod(primaryClass);
        }
        if (key.equals("givenClass")) {
            return this.getNameInClass(primaryClass);
        }
        if (key.equals("shortMethod")) {
            return this.className + "." + this.methodName + "()";
        }
        if (key.equals("hash")) {
            String tmp = this.getNameInClass(true, primaryClass, true);
            return this.className + "." + tmp;
        }
        if (key.equals("returnType")) {
            int i = this.methodSig.indexOf(41);
            String returnType = this.methodSig.substring(i + 1);
            String pkgName = primaryClass == null ? "" : primaryClass.getPackageName();
            SignatureConverter converter = new SignatureConverter(returnType);
            return MethodAnnotation.shorten(pkgName, converter.parseNext());
        }
        throw new IllegalArgumentException("unknown key " + key);
    }

    public String getNameInClass(ClassAnnotation primaryClass) {
        if (this.nameInClass == null) {
            this.nameInClass = this.getNameInClass(true, primaryClass, false);
        }
        return this.nameInClass;
    }

    public String getNameInClass(boolean shortenPackages, ClassAnnotation primaryClass, boolean useJVMMethodName) {
        if (primaryClass == null) {
            shortenPackages = false;
        }
        StringBuffer result = new StringBuffer();
        if (useJVMMethodName) {
            result.append(this.getMethodName());
        } else {
            result.append(this.getJavaSourceMethodName());
        }
        result.append('(');
        SignatureConverter converter = new SignatureConverter(this.methodSig);
        if (converter.getFirst() != '(') {
            throw new IllegalStateException("bad method signature " + this.methodSig);
        }
        converter.skip();
        String pkgName = null;
        if (shortenPackages) {
            pkgName = primaryClass.getPackageName();
        }
        boolean needsComma = false;
        while (converter.getFirst() != ')') {
            if (needsComma) {
                result.append(',');
            }
            if (shortenPackages) {
                result.append(MethodAnnotation.shorten(pkgName, converter.parseNext()));
            } else {
                result.append(converter.parseNext());
            }
            needsComma = true;
        }
        converter.skip();
        result.append(')');
        return result.toString();
    }

    public String getFullMethod(ClassAnnotation primaryClass) {
        if (this.fullMethod == null) {
            this.fullMethod = this.className + "." + this.getNameInClass(primaryClass);
        }
        return this.fullMethod;
    }

    private String getUglyMethod() {
        return this.className + "." + this.methodName + " : " + this.methodSig.replace('/', '.');
    }

    public int hashCode() {
        return this.className.hashCode() + this.methodName.hashCode() + this.methodSig.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodAnnotation)) {
            return false;
        }
        MethodAnnotation other = (MethodAnnotation)o;
        return this.className.equals(other.className) && this.methodName.equals(other.methodName) && this.methodSig.equals(other.methodSig);
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof MethodAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        MethodAnnotation other = (MethodAnnotation)o;
        int cmp = this.className.compareTo(other.className);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.methodName.compareTo(other.methodName);
        if (cmp != 0) {
            return cmp;
        }
        return this.methodSig.compareTo(other.methodSig);
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages) throws IOException {
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("classname", this.getClassName()).addAttribute("name", this.getMethodName()).addAttribute("signature", this.getMethodSignature()).addAttribute("isStatic", String.valueOf(this.isStatic()));
        String role = this.getDescription();
        if (!role.equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        if (this.sourceLines == null && !addMessages) {
            xmlOutput.openCloseTag(ELEMENT_NAME, attributeList);
        } else {
            xmlOutput.openTag(ELEMENT_NAME, attributeList);
            if (this.sourceLines != null) {
                this.sourceLines.writeXML(xmlOutput);
            }
            if (addMessages) {
                xmlOutput.openTag("Message");
                xmlOutput.writeText(this.toString());
                xmlOutput.closeTag("Message");
            }
            xmlOutput.closeTag(ELEMENT_NAME);
        }
    }

    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((BugAnnotation)x0);
    }

    static {
        $assertionsDisabled = !MethodAnnotation.class.desiredAssertionStatus();
        UGLY_METHODS = SystemProperties.getBoolean("ma.ugly");
    }
}

