/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector2;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryChooser;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.ErrorCountingBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IClassScreener;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.NoOpFindBugsProgress;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TextUICommandLine;
import edu.umd.cs.findbugs.ba.AnalysisCacheToAnalysisContextAdapter;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IClassFactory;
import edu.umd.cs.findbugs.classfile.IClassObserver;
import edu.umd.cs.findbugs.classfile.IClassPath;
import edu.umd.cs.findbugs.classfile.IClassPathBuilder;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.engine.asm.EngineRegistrar;
import edu.umd.cs.findbugs.classfile.impl.ClassFactory;
import edu.umd.cs.findbugs.config.AnalysisFeatureSetting;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.plan.AnalysisPass;
import edu.umd.cs.findbugs.plan.ExecutionPlan;
import edu.umd.cs.findbugs.plan.OrderingConstraintException;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.ClassFormatException;

public class FindBugs2
implements IFindBugsEngine {
    private static final boolean VERBOSE = SystemProperties.getBoolean("findbugs.verbose");
    private static final boolean DEBUG = VERBOSE || SystemProperties.getBoolean("findbugs.debug");
    private List<IClassObserver> classObserverList = new LinkedList<IClassObserver>();
    private ErrorCountingBugReporter bugReporter;
    private Project project;
    private IClassFactory classFactory;
    private IClassPath classPath;
    private IAnalysisCache analysisCache;
    private List<ClassDescriptor> appClassList;
    private Set<ClassDescriptor> referencedClassSet;
    private DetectorFactoryCollection detectorFactoryCollection;
    private ExecutionPlan executionPlan;
    private UserPreferences userPreferences;
    private String currentClassName;
    private String releaseName;
    private String sourceInfoFileName;
    private AnalysisFeatureSetting[] analysisFeatureSettingList = FindBugs.DEFAULT_EFFORT;
    private boolean relaxedReportingMode;
    private String trainingInputDir;
    private String trainingOutputDir;
    private FindBugsProgress progress = new NoOpFindBugsProgress();
    private IClassScreener classScreener = new IClassScreener(){

        public boolean matches(String fileName) {
            return true;
        }
    };
    private boolean scanNestedArchives = false;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$classfile$analysis$ClassInfo;

    public void setDetectorFactoryCollection(DetectorFactoryCollection detectorFactoryCollection) {
        this.detectorFactoryCollection = detectorFactoryCollection;
    }

    public void execute() throws IOException, InterruptedException {
        this.classFactory = ClassFactory.instance();
        this.createClassPath();
        this.createAnalysisCache();
        this.progress.reportNumberOfArchives(this.project.getFileCount());
        try {
            this.buildClassPath();
            this.buildReferencedClassSet();
            this.createAnalysisContext();
            FindBugs.configureBugCollection(this);
            FindBugsAnalysisFeatures.setRelaxedMode(this.relaxedReportingMode);
            FindBugs.configureTrainingDatabases(this);
            this.configureAnalysisFeatures();
            this.createExecutionPlan();
            this.analyzeApplication();
        }
        catch (CheckedAnalysisException e) {
            IOException ioe = new IOException("IOException while scanning codebases");
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            this.classPath.close();
        }
    }

    public BugReporter getBugReporter() {
        return this.bugReporter;
    }

    public Project getProject() {
        return this.project;
    }

    public void addClassObserver(IClassObserver classObserver) {
        this.classObserverList.add(classObserver);
    }

    public void addFilter(String filterFileName, boolean include) throws IOException, FilterException {
        FindBugs.configureFilter(this.bugReporter, filterFileName, include);
    }

    public void enableTrainingInput(String trainingInputDir) {
        this.trainingInputDir = trainingInputDir;
    }

    public void enableTrainingOutput(String trainingOutputDir) {
        this.trainingOutputDir = trainingOutputDir;
    }

    public int getBugCount() {
        return this.bugReporter.getBugCount();
    }

    public String getCurrentClass() {
        return this.currentClassName;
    }

    public int getErrorCount() {
        return this.bugReporter.getErrorCount();
    }

    public int getMissingClassCount() {
        return this.bugReporter.getMissingClassCount();
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setAnalysisFeatureSettings(AnalysisFeatureSetting[] settingList) {
        this.analysisFeatureSettingList = settingList;
    }

    public void setBugReporter(BugReporter bugReporter) {
        this.bugReporter = new ErrorCountingBugReporter(bugReporter);
        this.addClassObserver(bugReporter);
    }

    public void setClassScreener(IClassScreener classScreener) {
        this.classScreener = classScreener;
    }

    public void setProgressCallback(FindBugsProgress progressCallback) {
        this.progress = progressCallback;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setRelaxedReportingMode(boolean relaxedReportingMode) {
        this.relaxedReportingMode = relaxedReportingMode;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public void setSourceInfoFile(String sourceInfoFile) {
        this.sourceInfoFileName = sourceInfoFile;
    }

    public void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    public boolean emitTrainingOutput() {
        return this.trainingOutputDir != null;
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    private void createClassPath() {
        this.classPath = this.classFactory.createClassPath();
    }

    public String getTrainingInputDir() {
        return this.trainingInputDir;
    }

    public String getTrainingOutputDir() {
        return this.trainingOutputDir;
    }

    public boolean useTrainingInput() {
        return this.trainingInputDir != null;
    }

    public void setScanNestedArchives(boolean scanNestedArchives) {
        this.scanNestedArchives = scanNestedArchives;
    }

    private void createAnalysisCache() {
        this.analysisCache = ClassFactory.instance().createAnalysisCache(this.classPath, this.bugReporter);
        new edu.umd.cs.findbugs.classfile.engine.EngineRegistrar().registerAnalysisEngines(this.analysisCache);
        new EngineRegistrar().registerAnalysisEngines(this.analysisCache);
        new edu.umd.cs.findbugs.classfile.engine.bcel.EngineRegistrar().registerAnalysisEngines(this.analysisCache);
        Global.setAnalysisCacheForCurrentThread(this.analysisCache);
    }

    private void buildClassPath() throws InterruptedException, IOException, CheckedAnalysisException {
        IClassPathBuilder builder = this.classFactory.createClassPathBuilder(this.bugReporter);
        String[] arr$ = this.project.getFileArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String path = arr$[i$];
            builder.addCodeBase(this.classFactory.createFilesystemCodeBaseLocator(path), true);
        }
        Iterator<String> i$ = this.project.getAuxClasspathEntryList().iterator();
        while (i$.hasNext()) {
            String path = i$.next();
            builder.addCodeBase(this.classFactory.createFilesystemCodeBaseLocator(path), false);
        }
        builder.scanNestedArchives(this.scanNestedArchives);
        builder.build(this.classPath, this.progress);
        this.appClassList = builder.getAppClassList();
        Iterator<? extends ICodeBase> i = this.classPath.appCodeBaseIterator();
        while (i.hasNext()) {
            String pathName;
            ICodeBase appCodeBase = i.next();
            if (appCodeBase.containsSourceFiles() && (pathName = appCodeBase.getPathName()) != null) {
                this.project.addSourceDir(pathName);
            }
            this.project.addTimestamp(appCodeBase.getLastModifiedTime());
        }
    }

    private void buildReferencedClassSet() throws CheckedAnalysisException, InterruptedException {
        this.referencedClassSet = new TreeSet<ClassDescriptor>();
        LinkedList<ClassDescriptor> workList = new LinkedList<ClassDescriptor>();
        workList.addAll(this.appClassList);
        HashSet<ClassDescriptor> seen = new HashSet<ClassDescriptor>();
        HashSet<ClassDescriptor> appClassSet = new HashSet<ClassDescriptor>(this.appClassList);
        HashSet<ClassDescriptor> badAppClassSet = new HashSet<ClassDescriptor>();
        while (!workList.isEmpty()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            ClassDescriptor classDesc = (ClassDescriptor)workList.removeFirst();
            if (seen.contains(classDesc)) continue;
            seen.add(classDesc);
            this.referencedClassSet.add(classDesc);
            try {
                ClassInfo classInfo = (ClassInfo)Global.getAnalysisCache().getClassAnalysis(class$edu$umd$cs$findbugs$classfile$analysis$ClassInfo == null ? FindBugs2.class$("edu.umd.cs.findbugs.classfile.analysis.ClassInfo") : class$edu$umd$cs$findbugs$classfile$analysis$ClassInfo, classDesc);
                this.referencedClassSet.addAll(Arrays.asList(classInfo.getReferencedClassDescriptorList()));
                if (classInfo.getSuperclassDescriptor() != null) {
                    workList.addLast(classInfo.getSuperclassDescriptor());
                }
                ClassDescriptor[] arr$ = classInfo.getInterfaceDescriptorList();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ClassDescriptor ifaceDesc = arr$[i$];
                    workList.addLast(ifaceDesc);
                }
            }
            catch (MissingClassException e) {
                this.bugReporter.reportMissingClass(e.getClassDescriptor());
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
            catch (CheckedAnalysisException e) {
                this.bugReporter.logError("Error scanning " + classDesc + " for referenced classes", e);
                if (!appClassSet.contains(classDesc)) continue;
                badAppClassSet.add(classDesc);
            }
        }
        this.appClassList.removeAll(badAppClassSet);
    }

    private void createAnalysisContext() throws CheckedAnalysisException, IOException {
        AnalysisCacheToAnalysisContextAdapter analysisContext = new AnalysisCacheToAnalysisContextAdapter();
        analysisContext.clearRepository();
        analysisContext.setAppClassList(this.appClassList);
        if (this.sourceInfoFileName != null) {
            SourceInfoMap sourceInfoMap = analysisContext.getSourceInfoMap();
            sourceInfoMap.read(new FileInputStream(this.sourceInfoFileName));
        }
        AnalysisContext.setCurrentAnalysisContext(analysisContext);
    }

    private void configureAnalysisFeatures() {
        AnalysisFeatureSetting[] arr$ = this.analysisFeatureSettingList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            AnalysisFeatureSetting setting = arr$[i$];
            setting.configure(AnalysisContext.currentAnalysisContext());
        }
    }

    private void createExecutionPlan() throws OrderingConstraintException {
        this.executionPlan = new ExecutionPlan();
        DetectorFactoryChooser detectorFactoryChooser = new DetectorFactoryChooser(){

            public boolean choose(DetectorFactory factory) {
                return FindBugs.isDetectorEnabled(FindBugs2.this, factory);
            }
        };
        this.executionPlan.setDetectorFactoryChooser(detectorFactoryChooser);
        Iterator<Plugin> i = this.detectorFactoryCollection.pluginIterator();
        while (i.hasNext()) {
            Plugin plugin = i.next();
            if (DEBUG) {
                System.out.println("Adding plugin " + plugin.getPluginId() + " to execution plan");
            }
            this.executionPlan.addPlugin(plugin);
        }
        this.executionPlan.build();
        if (DEBUG) {
            System.out.println(this.executionPlan.getNumPasses() + " passes in execution plan");
        }
    }

    private void analyzeApplication() throws InterruptedException {
        int passCount = 0;
        boolean multiplePasses = this.executionPlan.getNumPasses() > 1;
        int[] classesPerPass = new int[this.executionPlan.getNumPasses()];
        classesPerPass[0] = this.referencedClassSet.size();
        for (int i = 0; i < classesPerPass.length; ++i) {
            classesPerPass[i] = i == 0 ? this.referencedClassSet.size() : this.appClassList.size();
        }
        this.progress.predictPassCount(classesPerPass);
        Iterator<AnalysisPass> i = this.executionPlan.passIterator();
        while (i.hasNext()) {
            List<ClassDescriptor> classCollection;
            AnalysisPass pass = i.next();
            Detector2[] detectorList = pass.instantiateDetector2sInPass(this.bugReporter);
            Collection<ClassDescriptor> collection = classCollection = multiplePasses && passCount == 0 ? this.referencedClassSet : this.appClassList;
            if (DEBUG) {
                System.out.println("Pass " + passCount + ": " + classCollection.size() + " classes");
            }
            this.progress.startAnalysis(classCollection.size());
            Iterator i$ = classCollection.iterator();
            while (i$.hasNext()) {
                ClassDescriptor classDescriptor = (ClassDescriptor)i$.next();
                if (DEBUG) {
                    System.out.println("Class " + classDescriptor);
                }
                if (!this.classScreener.matches(classDescriptor.toResourceName())) {
                    if (!DEBUG) continue;
                    System.out.println("*** Excluded by class screener");
                    continue;
                }
                this.currentClassName = ClassName.toDottedClassName(classDescriptor.getClassName());
                this.notifyClassObservers(classDescriptor);
                Detector2[] arr$ = detectorList;
                int len$ = arr$.length;
                for (int i$2 = 0; i$2 < len$; ++i$2) {
                    Detector2 detector = arr$[i$2];
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (DEBUG) {
                        System.out.println("Applying " + detector.getDetectorClassName() + " to " + classDescriptor);
                    }
                    try {
                        detector.visitClass(classDescriptor);
                        continue;
                    }
                    catch (ClassFormatException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                        continue;
                    }
                    catch (MissingClassException e) {
                        Global.getAnalysisCache().getErrorLogger().reportMissingClass(e.getClassDescriptor());
                        continue;
                    }
                    catch (CheckedAnalysisException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                        continue;
                    }
                    catch (AnalysisException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                        continue;
                    }
                    catch (ClassCastException e) {
                        this.logRecoverableException(classDescriptor, detector, e);
                    }
                }
                this.progress.finishClass();
            }
            Detector2[] arr$ = detectorList;
            int len$ = arr$.length;
            for (int i$3 = 0; i$3 < len$; ++i$3) {
                Detector2 detector = arr$[i$3];
                detector.finishPass();
            }
            AnalysisContext.currentAnalysisContext().updateDatabases(passCount);
            this.progress.finishPerClassAnalysis();
            ++passCount;
        }
        this.bugReporter.finish();
        this.bugReporter.reportQueuedErrors();
    }

    private void notifyClassObservers(ClassDescriptor classDescriptor) {
        Iterator<IClassObserver> i$ = this.classObserverList.iterator();
        while (i$.hasNext()) {
            IClassObserver observer = i$.next();
            observer.observeClass(classDescriptor);
        }
    }

    private void logRecoverableException(ClassDescriptor classDescriptor, Detector2 detector, Throwable e) {
        this.bugReporter.logError("Exception analyzing " + classDescriptor.toDottedClassName() + " using detector " + detector.getDetectorClassName(), e);
    }

    public static void main(String[] args) throws Exception {
        FindBugs2 findBugs = new FindBugs2();
        TextUICommandLine commandLine = new TextUICommandLine();
        FindBugs.processCommandLine(commandLine, args, findBugs);
        FindBugs.runMain(findBugs, commandLine);
    }
}

