/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Visitor;

public abstract class Annotations
extends Attribute {
    private int annotation_table_length;
    private AnnotationEntry[] annotation_table;

    Annotations(byte annotation_type, int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(annotation_type, name_index, length, (AnnotationEntry[])null, constant_pool);
        this.annotation_table_length = file.readUnsignedShort();
        this.annotation_table = new AnnotationEntry[this.annotation_table_length];
        int i = 0;
        while (i < this.annotation_table_length) {
            this.annotation_table[i] = new AnnotationEntry(file, constant_pool);
            ++i;
        }
    }

    public Annotations(byte annotation_type, int name_index, int length, AnnotationEntry[] annotation_table, ConstantPool constant_pool) {
        super(annotation_type, name_index, length, constant_pool);
        this.setAnnotationTable(annotation_table);
    }

    public void accept(Visitor v) {
    }

    public final void setAnnotationTable(AnnotationEntry[] annotation_table) {
        this.annotation_table = annotation_table;
        this.annotation_table_length = annotation_table == null ? 0 : annotation_table.length;
    }

    public final AnnotationEntry[] getAnnotationTable() {
        return this.annotation_table;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        return this.annotation_table;
    }

    public final int getNumAnnotations() {
        return this.annotation_table_length;
    }
}

