/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public class AnnotationEntry
implements Node,
Constants {
    private int type_index;
    private int num_element_value_pairs;
    private ElementValuePair[] element_value_pairs;
    private ConstantPool constant_pool;

    AnnotationEntry(DataInputStream file, ConstantPool constant_pool) throws IOException {
        this.type_index = file.readUnsignedShort();
        this.num_element_value_pairs = file.readUnsignedShort();
        this.element_value_pairs = new ElementValuePair[this.num_element_value_pairs];
        int i = 0;
        while (i < this.num_element_value_pairs) {
            this.element_value_pairs[i] = new ElementValuePair(file, constant_pool);
            ++i;
        }
        this.constant_pool = constant_pool;
    }

    public void accept(Visitor v) {
    }

    public String getAnnotationType() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return c.getBytes();
    }

    public final int getNumElementValuePairs() {
        return this.num_element_value_pairs;
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.element_value_pairs;
    }
}

