/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class listclass {
    boolean code;
    boolean constants;
    boolean verbose;
    boolean classdep;
    boolean nocontents;
    boolean recurse;
    Hashtable listedClasses;
    Vector exclude_name;

    public static void main(String[] argv) {
        Vector<String> file_name = new Vector<String>();
        Vector<String> exclude_name = new Vector<String>();
        boolean code = false;
        boolean constants = false;
        boolean verbose = true;
        boolean classdep = false;
        boolean nocontents = false;
        boolean recurse = false;
        boolean exclude = false;
        String name = null;
        int i = 0;
        while (i < argv.length) {
            if (argv[i].charAt(0) == '-') {
                if (argv[i].equals("-constants")) {
                    constants = true;
                } else if (argv[i].equals("-code")) {
                    code = true;
                } else if (argv[i].equals("-brief")) {
                    verbose = false;
                } else if (argv[i].equals("-dependencies")) {
                    classdep = true;
                } else if (argv[i].equals("-nocontents")) {
                    nocontents = true;
                } else if (argv[i].equals("-recurse")) {
                    recurse = true;
                } else if (argv[i].equals("-exclude")) {
                    exclude = true;
                } else if (argv[i].equals("-help")) {
                    System.out.println("Usage: java listclass [-constants] [-code] [-brief] [-dependencies] [-nocontents] [-recurse] class... [-exclude <list>]\n-constants       Print constants table (constant pool)\n-code            Dump byte code of methods\n-brief           Brief listing\n-dependencies    Show class dependencies\n-nocontents      Do not print field/method information\n-recurse         Recurse into dependent classes\n-exclude <list>  Do not list classes beginning with strings in <list>");
                    System.exit(0);
                } else {
                    System.err.println("Unknown switch " + argv[i] + " ignored.");
                }
            } else if (exclude) {
                exclude_name.addElement(argv[i]);
            } else {
                file_name.addElement(argv[i]);
            }
            ++i;
        }
        if (file_name.size() == 0) {
            System.err.println("list: No input files specified");
        } else {
            listclass listClass = new listclass(code, constants, verbose, classdep, nocontents, recurse, exclude_name);
            int i2 = 0;
            while (i2 < file_name.size()) {
                name = (String)file_name.elementAt(i2);
                listClass.list(name);
                ++i2;
            }
        }
    }

    public listclass(boolean code, boolean constants, boolean verbose, boolean classdep, boolean nocontents, boolean recurse, Vector exclude_name) {
        this.code = code;
        this.constants = constants;
        this.verbose = verbose;
        this.classdep = classdep;
        this.nocontents = nocontents;
        this.recurse = recurse;
        this.listedClasses = new Hashtable();
        this.exclude_name = exclude_name;
    }

    public void list(String name) {
        try {
            if (this.listedClasses.get(name) != null || name.startsWith("[")) {
                return;
            }
            int idx = 0;
            while (idx < this.exclude_name.size()) {
                if (name.startsWith((String)this.exclude_name.elementAt(idx))) {
                    return;
                }
                ++idx;
            }
            JavaClass java_class = name.endsWith(".class") ? new ClassParser(name).parse() : Repository.lookupClass(name);
            if (this.nocontents) {
                System.out.println(java_class.getClassName());
            } else {
                System.out.println(java_class);
            }
            if (this.constants) {
                System.out.println(java_class.getConstantPool());
            }
            if (this.code) {
                listclass.printCode(java_class.getMethods(), this.verbose);
            }
            if (this.classdep) {
                listclass.printClassDependencies(java_class.getConstantPool());
            }
            this.listedClasses.put(name, name);
            if (this.recurse) {
                String[] dependencies = listclass.getClassDependencies(java_class.getConstantPool());
                int idx2 = 0;
                while (idx2 < dependencies.length) {
                    this.list(dependencies[idx2]);
                    ++idx2;
                }
            }
        }
        catch (IOException e) {
            System.out.println("Error loading class " + name + " (" + e.getMessage() + ")");
        }
        catch (Exception e) {
            System.out.println("Error processing class " + name + " (" + e.getMessage() + ")");
        }
    }

    public static void printClassDependencies(ConstantPool pool) {
        String[] names = listclass.getClassDependencies(pool);
        System.out.println("Dependencies:");
        int idx = 0;
        while (idx < names.length) {
            System.out.println("\t" + names[idx]);
            ++idx;
        }
    }

    public static String[] getClassDependencies(ConstantPool pool) {
        String[] tempArray = new String[pool.getLength()];
        int size = 0;
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        while (idx < pool.getLength()) {
            Constant c = pool.getConstant(idx);
            if (c != null && c.getTag() == 7) {
                ConstantUtf8 c1 = (ConstantUtf8)pool.getConstant(((ConstantClass)c).getNameIndex());
                buf.setLength(0);
                buf.append(c1.getBytes());
                int n = 0;
                while (n < buf.length()) {
                    if (buf.charAt(n) == '/') {
                        buf.setCharAt(n, '.');
                    }
                    ++n;
                }
                tempArray[size++] = buf.toString();
            }
            ++idx;
        }
        String[] dependencies = new String[size];
        System.arraycopy(tempArray, 0, dependencies, 0, size);
        return dependencies;
    }

    public static void printCode(Method[] methods, boolean verbose) {
        int i = 0;
        while (i < methods.length) {
            System.out.println(methods[i]);
            Code code = methods[i].getCode();
            if (code != null) {
                System.out.println(code.toString(verbose));
            }
            ++i;
        }
    }
}

