/*
 * Decompiled with CFR 0.152.
 */
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUSH;

public final class helloify
implements Constants {
    private static String class_name;
    private static ConstantPoolGen cp;
    private static int out;
    private static int println;

    public static void main(String[] argv) {
        try {
            int i = 0;
            while (i < argv.length) {
                if (argv[i].endsWith(".class")) {
                    JavaClass java_class = new ClassParser(argv[i]).parse();
                    ConstantPool constants = java_class.getConstantPool();
                    String file_name = String.valueOf(argv[i].substring(0, argv[i].length() - 6)) + "_hello.class";
                    cp = new ConstantPoolGen(constants);
                    helloify.helloifyClassName(java_class);
                    out = cp.addFieldref("java.lang.System", "out", "Ljava/io/PrintStream;");
                    println = cp.addMethodref("java.io.PrintStream", "println", "(Ljava/lang/String;)V");
                    Method[] methods = java_class.getMethods();
                    int j = 0;
                    while (j < methods.length) {
                        methods[j] = helloify.helloifyMethod(methods[j]);
                        ++j;
                    }
                    java_class.setConstantPool(cp.getFinalConstantPool());
                    java_class.dump(file_name);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void helloifyClassName(JavaClass java_class) {
        class_name = String.valueOf(java_class.getClassName()) + "_hello";
        int index = java_class.getClassNameIndex();
        index = ((ConstantClass)cp.getConstant(index)).getNameIndex();
        cp.setConstant(index, new ConstantUtf8(class_name.replace('.', '/')));
    }

    private static Method helloifyMethod(Method m) {
        Code code = m.getCode();
        int flags = m.getAccessFlags();
        String name = m.getName();
        if (m.isNative() || m.isAbstract() || code == null) {
            return m;
        }
        String mesg = "Hello from " + Utility.methodSignatureToString(m.getSignature(), name, Utility.accessToString(flags));
        InstructionList patch = new InstructionList();
        patch.append(new GETSTATIC(out));
        patch.append(new PUSH(cp, mesg));
        patch.append(new INVOKEVIRTUAL(println));
        MethodGen mg = new MethodGen(m, class_name, cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        if (name.equals("<init>")) {
            int j = 1;
            while (j < ihs.length) {
                if (ihs[j].getInstruction() instanceof INVOKESPECIAL) {
                    il.append(ihs[j], patch);
                    break;
                }
                ++j;
            }
        } else {
            il.insert(ihs[0], patch);
        }
        if (code.getMaxStack() < 2) {
            mg.setMaxStack(2);
        }
        m = mg.getMethod();
        il.dispose();
        return m;
    }
}

