/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;

public class Package {
    static String defaultJar = "Client.jar";
    ClassPath classPath = ClassPath.SYSTEM_CLASS_PATH;
    TreeMap allClasses = new TreeMap();
    TreeMap dependents = new TreeMap();
    TreeMap notFound = new TreeMap();
    boolean showNotFound = false;
    boolean printClasses = false;
    boolean log = false;

    static void main(String[] args) {
        Package instance = new Package();
        try {
            instance.go(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            instance.usage();
        }
    }

    public void usage() {
        System.out.println(" This program packages classes and all their dependents");
        System.out.println(" into one jar. Give all starting classes (your main)");
        System.out.println(" on the command line. Use / as separator, the .class is");
        System.out.println(" optional. We use the environments CLASSPATH to resolve");
        System.out.println(" classes. Anything but java.* packages are packaged.");
        System.out.println(" If you use Class.forName (or similar), be sure to");
        System.out.println(" include the classes that you load dynamically on the");
        System.out.println(" command line.\n");
        System.out.println(" These options are recognized:");
        System.out.println(" -e -error  Show errors, meaning classes that could not ");
        System.out.println("   resolved + the classes that referenced them.");
        System.out.println(" -l -log  Show classes as they are processed. This will");
        System.out.println("   include doubles, java classes and is difficult to");
        System.out.println("   read. I use it as a sort of progress monitor");
        System.out.println(" -s -show  Prints all the classes that were packaged");
        System.out.println("   in alphabetical order, which is ordered by package");
        System.out.println("   for the most part.");
    }

    void go(String[] args) throws IOException {
        String name;
        JavaClass clazz;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-e")) {
                this.showNotFound = true;
            } else if (args[i].startsWith("-s")) {
                this.printClasses = true;
            } else if (args[i].startsWith("-l")) {
                this.log = true;
            } else {
                String clName = args[i];
                if (clName.endsWith(".class")) {
                    clName = clName.substring(0, clName.length() - 6);
                }
                clName = clName.replace('.', '/');
                clazz = new ClassParser(this.classPath.getInputStream(clName), clName).parse();
                this.addDependents(clazz);
                System.out.println("Packaging for class: " + clName);
            }
            ++i;
        }
        if (this.dependents.isEmpty()) {
            this.usage();
            return;
        }
        System.out.println("Creating jar file: " + defaultJar);
        while (!this.dependents.isEmpty()) {
            String name2 = (String)this.dependents.firstKey();
            String from = (String)this.dependents.remove(name2);
            if (this.allClasses.get(name2) != null) continue;
            try {
                InputStream is = this.classPath.getInputStream(name2);
                clazz = new ClassParser(is, name2).parse();
                this.addDependents(clazz);
            }
            catch (IOException e) {
                this.notFound.put(name2, from);
            }
        }
        if (this.printClasses) {
            this.printAllClasses();
        }
        JarOutputStream jarFile = new JarOutputStream(new FileOutputStream(defaultJar));
        jarFile.setLevel(5);
        Iterator keys = this.allClasses.keySet().iterator();
        int written = 0;
        while (keys.hasNext()) {
            name = (String)keys.next();
            JavaClass claz = (JavaClass)this.allClasses.get(name);
            ZipEntry zipEntry = new ZipEntry(String.valueOf(name) + ".class");
            byte[] bytes = claz.getBytes();
            int length = bytes.length;
            jarFile.putNextEntry(zipEntry);
            jarFile.write(bytes, 0, length);
            written += length;
        }
        jarFile.close();
        System.err.println("The jar file contains " + this.allClasses.size() + " classes and contains " + written + " bytes");
        if (!this.notFound.isEmpty()) {
            System.err.println(String.valueOf(this.notFound.size()) + " classes could not be found");
            if (this.showNotFound) {
                while (!this.notFound.isEmpty()) {
                    name = (String)this.notFound.firstKey();
                    System.err.println(String.valueOf(name) + " (" + this.notFound.remove(name) + ")");
                }
            } else {
                System.err.println("Use '-e' option to view classes that were not found");
            }
        }
    }

    void printAllClasses() {
        ArrayList names = new ArrayList(this.allClasses.keySet());
        Collections.sort(names);
        int i = 0;
        while (i < names.size()) {
            String cl = (String)names.get(i);
            System.err.println(cl);
            ++i;
        }
    }

    void addDependents(JavaClass clazz) throws IOException {
        String name = clazz.getClassName().replace('.', '/');
        this.allClasses.put(name, clazz);
        ConstantPool pool = clazz.getConstantPool();
        int i = 1;
        while (i < pool.getLength()) {
            Constant cons = pool.getConstant(i);
            if (cons != null && cons.getTag() == 7) {
                int idx = ((ConstantClass)pool.getConstant(i)).getNameIndex();
                String clas = ((ConstantUtf8)pool.getConstant(idx)).getBytes();
                this.addClassString(clas, name);
            }
            ++i;
        }
    }

    void addClassString(String clas, String from) throws IOException {
        if (this.log) {
            System.out.println("processing: " + clas + " referenced by " + from);
        }
        if (clas.startsWith("[")) {
            if (clas.length() == 2) {
                return;
            }
            if ('L' == clas.charAt(1)) {
                this.addClassString(clas.substring(2, clas.length() - 1), from);
                return;
            }
            if ('[' == clas.charAt(1)) {
                this.addClassString(clas.substring(1), from);
                return;
            }
            throw new IOException("Can't recognize class name =" + clas);
        }
        if (!clas.startsWith("java/") && this.allClasses.get(clas) == null) {
            this.dependents.put(clas, from);
        }
    }
}

