/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.ASTExpr;
import Mini.ASTFunDecl;
import Mini.ASTIdent;
import Mini.EnvEntry;
import Mini.Environment;
import Mini.MiniC;
import Mini.MiniParser;
import Mini.Node;
import Mini.Variable;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;

public class ASTLetExpr
extends ASTExpr
implements Constants {
    private ASTIdent[] idents;
    private ASTExpr[] exprs;
    private ASTExpr body;

    ASTLetExpr(int id2) {
        super(id2);
    }

    ASTLetExpr(MiniParser p, int id2) {
        super(p, id2);
    }

    public static Node jjtCreate(MiniParser p, int id2) {
        return new ASTLetExpr(p, id2);
    }

    public void closeNode() {
        int len_2 = this.children.length / 2;
        this.idents = new ASTIdent[len_2];
        this.exprs = new ASTExpr[len_2];
        int i = 0;
        while (i < len_2) {
            this.idents[i] = (ASTIdent)this.children[i * 2];
            this.exprs[i] = (ASTExpr)this.children[i * 2 + 1];
            ++i;
        }
        this.body = (ASTExpr)this.children[this.children.length - 1];
        this.children = null;
    }

    public ASTExpr traverse(Environment env) {
        this.env = env;
        int i = 0;
        while (i < this.exprs.length) {
            this.exprs[i] = this.exprs[i].traverse((Environment)env.clone());
            ++i;
        }
        i = 0;
        while (i < this.idents.length) {
            ASTIdent id2 = this.idents[i];
            String name = id2.getName();
            EnvEntry entry = env.get(name);
            if (entry != null) {
                MiniC.addError(id2.getLine(), id2.getColumn(), "Redeclaration of " + entry + ".");
            } else {
                env.put(new Variable(id2));
            }
            ++i;
        }
        this.body = this.body.traverse(env);
        return this;
    }

    public int eval(int expected) {
        int i = 0;
        while (i < this.idents.length) {
            int t = this.exprs[i].eval(15);
            this.idents[i].setType(t);
            ++i;
        }
        this.type = this.body.eval(expected);
        return this.type;
    }

    public void code(StringBuffer buf) {
        int i = 0;
        while (i < this.idents.length) {
            String ident = this.idents[i].getName();
            int t = this.idents[i].getType();
            this.exprs[i].code(buf);
            buf.append("    " + TYPE_NAMES[t] + " " + ident + " = " + ASTFunDecl.pop() + ";\n");
            ++i;
        }
        this.body.code(buf);
    }

    public void byte_code(InstructionList il, MethodGen method, ConstantPoolGen cp) {
        int size = this.idents.length;
        LocalVariableGen[] l = new LocalVariableGen[size];
        int i = 0;
        while (i < size) {
            String ident = this.idents[i].getName();
            Variable entry = (Variable)this.env.get(ident);
            BasicType t = BasicType.getType((byte)this.idents[i].getType());
            LocalVariableGen lg = method.addLocalVariable(ident, t, null, null);
            int slot = lg.getIndex();
            entry.setLocalVariable(lg);
            InstructionHandle start = il.getEnd();
            this.exprs[i].byte_code(il, method, cp);
            start = start == null ? il.getStart() : start.getNext();
            lg.setStart(start);
            il.append(new ISTORE(slot));
            ASTFunDecl.pop();
            l[i] = lg;
            ++i;
        }
        this.body.byte_code(il, method, cp);
        InstructionHandle end = il.getEnd();
        int i2 = 0;
        while (i2 < size) {
            l[i2].setEnd(end);
            ++i2;
        }
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        int i = 0;
        while (i < this.idents.length) {
            this.idents[i].dump(String.valueOf(prefix) + " ");
            this.exprs[i].dump(String.valueOf(prefix) + " ");
            ++i;
        }
        this.body.dump(String.valueOf(prefix) + " ");
    }
}

