/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenOperation;
import org.eclipse.emf.codegen.ecore.genmodel.GenParameter;
import org.eclipse.emf.codegen.ecore.genmodel.GenProviderKind;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenBaseImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenClassifierImpl;
import org.eclipse.emf.codegen.ecore.genmodel.impl.GenModelImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class GenClassImpl
extends GenClassifierImpl
implements GenClass {
    protected static final GenProviderKind PROVIDER_EDEFAULT = GenProviderKind.SINGLETON_LITERAL;
    protected GenProviderKind provider = PROVIDER_EDEFAULT;
    protected static final boolean IMAGE_EDEFAULT = true;
    protected boolean image = true;
    protected static final boolean DYNAMIC_EDEFAULT = false;
    protected boolean dynamic = false;
    protected EClass ecoreClass = null;
    protected EList genFeatures = null;
    protected EList genOperations = null;
    protected GenFeature labelFeature = null;
    public static final List INTRINSIC_CONSTRAINTS = Arrays.asList("EveryMultiplicityConforms", "EveryDataValueConforms", "EveryReferenceIsContained", "EveryProxyResolves");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected GenClassImpl() {
    }

    protected EClass eStaticClass() {
        return GenModelPackage.Literals.GEN_CLASS;
    }

    public GenProviderKind getProvider() {
        return this.provider;
    }

    public boolean isProviderSingleton() {
        return this.provider == GenProviderKind.SINGLETON_LITERAL;
    }

    public void setProvider(GenProviderKind newProvider) {
        GenProviderKind oldProvider = this.provider;
        GenProviderKind genProviderKind = this.provider = newProvider == null ? PROVIDER_EDEFAULT : newProvider;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldProvider, (Object)this.provider));
        }
    }

    public boolean isImage() {
        return this.image;
    }

    public void setImage(boolean newImage) {
        boolean oldImage = this.image;
        this.image = newImage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldImage, this.image));
        }
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean newDynamic) {
        boolean oldDynamic = this.dynamic;
        this.dynamic = newDynamic;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldDynamic, this.dynamic));
        }
    }

    public EClass getEcoreClass() {
        if (this.ecoreClass != null && this.ecoreClass.eIsProxy()) {
            InternalEObject oldEcoreClass = (InternalEObject)this.ecoreClass;
            this.ecoreClass = (EClass)this.eResolveProxy(oldEcoreClass);
            if (this.ecoreClass != oldEcoreClass && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldEcoreClass, (Object)this.ecoreClass));
            }
        }
        return this.ecoreClass;
    }

    public EClass basicGetEcoreClass() {
        return this.ecoreClass;
    }

    public void setEcoreClass(EClass newEcoreClass) {
        EClass oldEcoreClass = this.ecoreClass;
        this.ecoreClass = newEcoreClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldEcoreClass, (Object)this.ecoreClass));
        }
    }

    public EList getGenFeatures() {
        if (this.genFeatures == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.codegen.ecore.genmodel.GenFeature");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.genFeatures = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 6, 10);
        }
        return this.genFeatures;
    }

    public EList getGenOperations() {
        if (this.genOperations == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.emf.codegen.ecore.genmodel.GenOperation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.genOperations = new EObjectContainmentWithInverseEList((Class)clazz, (InternalEObject)this, 7, 1);
        }
        return this.genOperations;
    }

    public EClassifier getEcoreClassifier() {
        return this.getEcoreClass();
    }

    public String getImportedMetaType() {
        return this.getGenModel().getImportedName("org.eclipse.emf.ecore.EClass");
    }

    public String getInterfaceName() {
        return this.getName();
    }

    public String getQualifiedInterfaceName() {
        return this.getInternalQualifiedInterfaceName().replace('$', '.');
    }

    protected String getInternalQualifiedInterfaceName() {
        if (this.isDynamic()) {
            GenClass genClass = this.getBaseGenClass();
            return genClass == null ? "org.eclipse.emf.ecore.EObject" : ((GenClassImpl)genClass).getInternalQualifiedInterfaceName();
        }
        return this.getEcoreClass().getInstanceClassName() != null ? this.getEcoreClass().getInstanceClassName() : String.valueOf(this.getGenPackage().getInterfacePackageName()) + "." + this.getInterfaceName();
    }

    public String getImportedInstanceClassName() {
        return this.getImportedInterfaceName();
    }

    public String getImportedInterfaceName() {
        return this.getGenModel().getImportedName(this.getInternalQualifiedInterfaceName());
    }

    public String getClassName() {
        String result = this.getInterfaceName();
        if (!this.getGenModel().isSuppressInterfaces()) {
            result = this.getImplClassName(result);
        }
        return result;
    }

    public String getQualifiedClassName() {
        return String.valueOf(this.getGenPackage().getClassPackageName()) + "." + this.getClassName();
    }

    public String getImportedClassName() {
        return this.getGenModel().getImportedName(this.getQualifiedClassName());
    }

    public List getBaseGenClasses() {
        return this.collectGenClasses((List)this.getEcoreClass().getESuperTypes(), null);
    }

    public List getAllBaseGenClasses() {
        return this.collectGenClasses((List)this.getEcoreClass().getEAllSuperTypes(), null);
    }

    public List getSwitchGenClasses() {
        List result = this.collectGenClasses((List)this.getEcoreClass().getESuperTypes(), new GenBaseImpl.GenClassFilter(){

            public boolean accept(GenClass genClass) {
                return !genClass.isEObject();
            }
        });
        HashSet<GenClass> resultSet = new HashSet<GenClass>(result);
        int i = 0;
        while (i < result.size()) {
            GenClass base = (GenClass)result.get(i);
            Iterator iter = base.getBaseGenClasses().iterator();
            while (iter.hasNext()) {
                GenClass baseOfBase = (GenClass)iter.next();
                if (baseOfBase.isEObject() || !resultSet.add(baseOfBase)) continue;
                result.add(baseOfBase);
            }
            ++i;
        }
        return result;
    }

    public GenClass getBaseGenClass() {
        EList s = this.getEcoreClass().getESuperTypes();
        return s.isEmpty() ? null : this.findGenClass((EClass)s.iterator().next());
    }

    public GenClass getClassExtendsGenClass() {
        GenClass base = this.getBaseGenClass();
        while (base != this) {
            if (base == null || !base.isInterface()) {
                return base;
            }
            base = base.getBaseGenClass();
        }
        throw new RuntimeException("inheritance loop at " + this.getName());
    }

    public String getClassExtends() {
        String rootExtendsClass;
        GenClass extendsClass = this.getClassExtendsGenClass();
        if (extendsClass != null) {
            return " extends " + extendsClass.getImportedClassName();
        }
        if (!this.isEObject() && !GenClassImpl.isBlank(rootExtendsClass = this.getGenModel().getRootExtendsClass())) {
            return " extends " + this.getGenModel().getImportedName(rootExtendsClass);
        }
        return "";
    }

    public boolean needsRootImplementsInterfaceOperations() {
        GenClass extendsClass;
        String rootImplementsInterface;
        return !this.isMapEntry() && !GenClassImpl.isBlank(rootImplementsInterface = this.getGenModel().getRootImplementsInterface()) && (extendsClass = this.getClassExtendsGenClass()) != null && !rootImplementsInterface.equals(extendsClass.getGenModel().getRootImplementsInterface());
    }

    protected List getClassImplementsList() {
        UniqueEList result = new UniqueEList();
        if (this.isMapEntry()) {
            result.add(this.getGenModel().getImportedName("org.eclipse.emf.common.util.BasicEMap$Entry"));
        } else {
            GenClass extendsClass;
            String rootImplementsInterface;
            if (this.isExternalInterface() || !this.getGenModel().isSuppressInterfaces()) {
                result.add(this.getImportedInterfaceName());
            }
            if (!GenClassImpl.isBlank(rootImplementsInterface = this.getGenModel().getRootImplementsInterface()) && (extendsClass = this.getClassExtendsGenClass()) != null && !rootImplementsInterface.equals(extendsClass.getGenModel().getRootImplementsInterface())) {
                result.add(this.getGenModel().getImportedName(rootImplementsInterface));
            }
        }
        if (this.getGenModel().isSuppressInterfaces()) {
            List interfaceExtends = this.getInterfaceExtendsList();
            GenClassImpl classExtendsClass = (GenClassImpl)this.getClassExtendsGenClass();
            if (classExtendsClass != null) {
                interfaceExtends.removeAll(classExtendsClass.getClassImplementsList());
            }
            result.addAll(interfaceExtends);
        }
        return result;
    }

    public String getClassImplements() {
        List classImplements = this.getClassImplementsList();
        if (classImplements.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer(" implements ");
        Iterator iter = classImplements.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public boolean needsRootExtendsInterfaceExtendsTag() {
        String rootExtendsInterface = this.getGenModel().getRootExtendsInterface();
        if (rootExtendsInterface == null) {
            rootExtendsInterface = "";
        }
        if (GenClassImpl.isBlank(rootExtendsInterface) || this.getBaseGenClasses().isEmpty() && this.getGenPackage().isEcorePackage()) {
            return false;
        }
        Iterator iter = this.getAllBaseGenClasses().iterator();
        while (iter.hasNext()) {
            GenClass genClass = (GenClass)iter.next();
            if (genClass.getEcoreClass().getInstanceClassName() != null || !rootExtendsInterface.equals(genClass.getGenModel().getRootExtendsInterface())) continue;
            return false;
        }
        return !rootExtendsInterface.equals("org.eclipse.emf.ecore.EObject");
    }

    public List getInterfaceExtendsList() {
        GenClass genClass;
        UniqueEList result = new UniqueEList();
        String rootExtendsInterface = this.getGenModel().getRootExtendsInterface();
        if (rootExtendsInterface == null) {
            rootExtendsInterface = "";
        }
        if (this.getBaseGenClasses().isEmpty()) {
            if (!this.getGenPackage().isEcorePackage() && !GenClassImpl.isBlank(rootExtendsInterface)) {
                result.add(this.getGenModel().getImportedName(rootExtendsInterface));
            }
            return result;
        }
        boolean needsRootExtendsInterface = true;
        Iterator iter = this.getAllBaseGenClasses().iterator();
        while (iter.hasNext()) {
            genClass = (GenClass)iter.next();
            if (genClass.getEcoreClass().getInstanceClassName() != null || !rootExtendsInterface.equals(genClass.getGenModel().getRootExtendsInterface())) continue;
            needsRootExtendsInterface = false;
            break;
        }
        if (needsRootExtendsInterface && !GenClassImpl.isBlank(rootExtendsInterface)) {
            result.add(this.getGenModel().getImportedName(rootExtendsInterface));
        }
        iter = this.getBaseGenClasses().iterator();
        while (iter.hasNext()) {
            genClass = (GenClass)iter.next();
            if (!genClass.isExternalInterface() && !genClass.isInterface() && genClass.getGenModel().isSuppressInterfaces()) continue;
            result.add(genClass.getImportedInterfaceName());
        }
        return result;
    }

    public String getInterfaceExtends() {
        List interfaceExtends = this.getInterfaceExtendsList();
        if (interfaceExtends.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer(" extends ");
        Iterator iter = interfaceExtends.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public List getAllGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), null);
    }

    public List getInheritedGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), null, null);
    }

    public List getAllGenOperations() {
        return this.collectGenOperations(this.getAllBaseGenClasses(), (List)this.getGenOperations(), null);
    }

    public String getFeatureID(GenFeature genFeature) {
        return String.valueOf(this.getClassifierID()) + "__" + this.format(genFeature.getName(), '_', null, false, false).toUpperCase();
    }

    public String getQualifiedFeatureID(GenFeature genFeature) {
        return String.valueOf(this.getGenPackage().getImportedPackageInterfaceName()) + "." + this.getFeatureID(genFeature);
    }

    public String getOperationID(GenOperation genOperation) {
        return String.valueOf(this.getClassifierID()) + "__" + this.format(genOperation.getName(), '_', null, false, false).toUpperCase();
    }

    public String getFeatureValue(GenFeature genFeature) {
        List allFeatures = this.getAllGenFeatures();
        int i = allFeatures.indexOf(genFeature);
        GenClass base = this.getBaseGenClass();
        if (base == null) {
            return Integer.toString(i);
        }
        int baseCount = base.getFeatureCount();
        if (i < baseCount) {
            return this.getGenPackage() == base.getGenPackage() ? base.getFeatureID(genFeature) : base.getQualifiedFeatureID(genFeature);
        }
        String baseCountID = this.getGenPackage() == base.getGenPackage() ? base.getFeatureCountID() : base.getQualifiedFeatureCountID();
        return String.valueOf(baseCountID) + " + " + Integer.toString(i - baseCount);
    }

    public String getLocalFeatureIndex(GenFeature genFeature) {
        return Integer.toString(this.getEcoreClass().getEStructuralFeatures().indexOf((Object)genFeature.getEcoreFeature()));
    }

    public String getFlagsField(GenFeature genFeature) {
        String flagsField;
        if (this.isFlag(genFeature) && !GenClassImpl.isBlank(flagsField = this.getImplementingGenModel(genFeature).getBooleanFlagsField())) {
            int flagIndex = this.getFlagIndex(genFeature);
            if (flagIndex / 32 > 0) {
                flagsField = String.valueOf(flagsField) + String.valueOf(flagIndex / 32);
            }
            return flagsField;
        }
        return null;
    }

    public int getFlagIndex(GenFeature genFeature) {
        if (this.isFlag(genFeature)) {
            int reservedBooleanFlags = this.getImplementingGenModel(genFeature).getBooleanFlagsReservedBits();
            int index = reservedBooleanFlags > 0 ? reservedBooleanFlags - 1 : -1;
            Iterator otherGenFeatures = this.getAllGenFeatures().iterator();
            while (otherGenFeatures.hasNext()) {
                GenFeature otherGenFeature = (GenFeature)otherGenFeatures.next();
                if (this.isFlag(otherGenFeature)) {
                    ++index;
                    if (otherGenFeature.getEcoreFeature() == genFeature.getEcoreFeature()) {
                        return index;
                    }
                }
                if (!this.isESetFlag(otherGenFeature)) continue;
                ++index;
            }
        }
        return -1;
    }

    public String getESetFlagsField(GenFeature genFeature) {
        String isSetFlagsField;
        if (this.isESetFlag(genFeature) && !GenClassImpl.isBlank(isSetFlagsField = this.getImplementingGenModel(genFeature).getBooleanFlagsField())) {
            int isSetFlagIndex = this.getESetFlagIndex(genFeature);
            if (isSetFlagIndex / 32 > 0) {
                isSetFlagsField = String.valueOf(isSetFlagsField) + String.valueOf(isSetFlagIndex / 32);
            }
            return isSetFlagsField;
        }
        return null;
    }

    public int getESetFlagIndex(GenFeature genFeature) {
        if (this.isESetFlag(genFeature)) {
            int reservedBooleanFlags = this.getImplementingGenModel(genFeature).getBooleanFlagsReservedBits();
            int index = reservedBooleanFlags > 0 ? reservedBooleanFlags - 1 : -1;
            Iterator otherGenFeatures = this.getAllGenFeatures().iterator();
            while (otherGenFeatures.hasNext()) {
                GenFeature otherGenFeature = (GenFeature)otherGenFeatures.next();
                if (this.isFlag(otherGenFeature)) {
                    ++index;
                }
                if (!this.isESetFlag(otherGenFeature)) continue;
                ++index;
                if (otherGenFeature.getEcoreFeature() != genFeature.getEcoreFeature()) continue;
                return index;
            }
        }
        return -1;
    }

    public String getFeatureCountID() {
        return String.valueOf(this.getClassifierID()) + "_FEATURE_COUNT";
    }

    public String getQualifiedFeatureCountID() {
        return String.valueOf(this.getGenPackage().getImportedPackageInterfaceName()) + "." + this.getFeatureCountID();
    }

    public String getFeatureCountValue() {
        GenClass base = this.getBaseGenClass();
        if (base == null) {
            return Integer.toString(this.getFeatureCount());
        }
        String baseCountID = this.getGenPackage() == base.getGenPackage() ? base.getFeatureCountID() : base.getQualifiedFeatureCountID();
        return String.valueOf(baseCountID) + " + " + Integer.toString(this.getFeatureCount() - base.getFeatureCount());
    }

    public int getFeatureCount() {
        return this.getAllGenFeatures().size();
    }

    public boolean isEObject() {
        return this.getName().equals("EObject") && this.getGenPackage().isEcorePackage();
    }

    public boolean isEObjectExtension() {
        if (this.isMapEntry()) {
            return false;
        }
        if (this.isExternalInterface()) {
            return false;
        }
        Iterator iter = this.getAllBaseGenClasses().iterator();
        while (iter.hasNext()) {
            GenClass genClass = (GenClass)iter.next();
            if (!genClass.isEObjectExtension()) continue;
            return true;
        }
        return this.getGenPackage().isEcorePackage() || !this.isExternalInterface() && "org.eclipse.emf.ecore.EObject".equals(this.getGenModel().getRootExtendsInterface());
    }

    public String getCastFromEObject() {
        String qualifiedInterfaceName = this.getQualifiedInterfaceName();
        return !"org.eclipse.emf.ecore.EObject".equals(qualifiedInterfaceName) ? "(" + this.getGenModel().getImportedName(qualifiedInterfaceName) + ")" : "";
    }

    public boolean isAbstract() {
        return this.getEcoreClass().isAbstract() || this.getEcoreClass().isInterface();
    }

    public String getAbstractFlag() {
        String result = !this.isAbstract() ? "!" : "";
        return String.valueOf(result) + "IS_ABSTRACT";
    }

    public boolean isInterface() {
        return this.getEcoreClass().isInterface();
    }

    public String getInterfaceFlag() {
        String result = !this.getEcoreClass().isInterface() ? "!" : "";
        return String.valueOf(result) + "IS_INTERFACE";
    }

    public String getGeneratedInstanceClassFlag() {
        String result = this.isExternalInterface() || this.isDynamic() ? "!" : "";
        return String.valueOf(result) + "IS_GENERATED_INSTANCE_CLASS";
    }

    public boolean isExternalInterface() {
        return this.getEcoreClass().eIsSet((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME);
    }

    public boolean isMapEntry() {
        return GenClassImpl.isJavaUtilMapEntry(this.getEcoreClass().getInstanceClassName()) && this.getEcoreClass().getEStructuralFeature("key") != null && this.getEcoreClass().getEStructuralFeature("value") != null;
    }

    public GenFeature getMapEntryKeyFeature() {
        return this.findGenFeature(this.getEcoreClass().getEStructuralFeature("key"));
    }

    public GenFeature getMapEntryValueFeature() {
        return this.findGenFeature(this.getEcoreClass().getEStructuralFeature("value"));
    }

    public List getImplementedGenClasses() {
        List allBases = this.getAllBaseGenClasses();
        GenClass extendedBase = this.getClassExtendsGenClass();
        int i = extendedBase == null ? 0 : allBases.indexOf(extendedBase) + 1;
        ArrayList<GenClassImpl> result = new ArrayList<GenClassImpl>(allBases.subList(i, allBases.size()));
        result.add(this);
        return result;
    }

    public List getImplementedGenFeatures() {
        return this.collectGenFeatures(this.getImplementedGenClasses(), null, null);
    }

    public GenModel getImplementingGenModel(GenFeature genFeature) {
        if (this.getImplementedGenFeatures().contains(genFeature)) {
            return this.getGenModel();
        }
        GenClass classExtendsGenClass = this.getClassExtendsGenClass();
        return classExtendsGenClass == null ? genFeature.getGenModel() : classExtendsGenClass.getImplementingGenModel(genFeature);
    }

    public List getImplementedGenOperations() {
        GenClass rootImplementsInterface;
        UniqueEList implementedGenClasses = new UniqueEList((Collection)this.getImplementedGenClasses());
        ECollections.reverse((EList)implementedGenClasses);
        if (this.needsRootImplementsInterfaceOperations() && (rootImplementsInterface = this.getGenModel().getRootImplementsInterfaceGenClass()) != null) {
            UniqueEList allBaseClasses = new UniqueEList((Collection)rootImplementsInterface.getAllBaseGenClasses());
            Iterator i = allBaseClasses.iterator();
            while (i.hasNext()) {
                GenClass genClass = (GenClass)i.next();
                if (!genClass.isEObject()) continue;
                i.remove();
            }
            allBaseClasses.add(rootImplementsInterface);
            implementedGenClasses.addAll((Collection)allBaseClasses);
        }
        return this.collectGenOperations((List)implementedGenClasses, null, new CollidingGenOperationFilter());
    }

    public List getExtendedGenClasses() {
        List allBases = this.getAllBaseGenClasses();
        GenClass extendedBase = this.getClassExtendsGenClass();
        int i = extendedBase == null ? 0 : allBases.indexOf(extendedBase) + 1;
        return new ArrayList(allBases.subList(0, i));
    }

    public List getExtendedGenFeatures() {
        return this.collectGenFeatures(this.getExtendedGenClasses(), null, null);
    }

    public List getExtendedGenOperations() {
        return this.collectGenOperations(this.getExtendedGenClasses(), null, new CollidingGenOperationFilter());
    }

    public List getDeclaredGenFeatures() {
        return this.getGenFeatures();
    }

    public List getDeclaredGenOperations() {
        return this.getGenOperations();
    }

    public List getFlagGenFeatures() {
        return this.collectGenFeatures(null, this.getImplementedGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return GenClassImpl.this.isFlag(genFeature);
            }
        });
    }

    public List getFlagGenFeatures(final String staticDefaultValue) {
        return this.collectGenFeatures(null, this.getFlagGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return staticDefaultValue.equalsIgnoreCase(genFeature.getStaticDefaultValue());
            }
        });
    }

    public List getESetGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isChangeable();
            }
        });
    }

    public List getEInverseAddGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isBidirectional() && !genFeature.isVolatile();
            }
        });
    }

    public List getEInverseRemoveGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isEffectiveContains() || genFeature.isBidirectional() && !genFeature.getReverse().isVolatile() || genFeature.isFeatureMapType();
            }
        });
    }

    public List getEBasicRemoveFromContainerGenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isContainer();
            }
        });
    }

    public List getToStringGenFeatures() {
        return this.collectGenFeatures(this.getImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isField() && !genFeature.isReferenceType();
            }
        });
    }

    public List getMixinGenClasses() {
        EList superTypes = this.getEcoreClass().getESuperTypes();
        if (superTypes.isEmpty() || superTypes.size() == 1 && !((EClass)superTypes.get(0)).isInterface()) {
            return Collections.EMPTY_LIST;
        }
        List allBases = this.getAllBaseGenClasses();
        ArrayList result = new ArrayList(allBases.size());
        GenClass baseGenClass = this.getBaseGenClass();
        if (baseGenClass.isInterface()) {
            result.addAll(baseGenClass.getMixinGenClasses());
        }
        int i = allBases.indexOf(baseGenClass) + 1;
        result.addAll(allBases.subList(i, allBases.size()));
        return result;
    }

    public List getMixinGenFeatures() {
        return this.collectGenFeatures(this.getMixinGenClasses(), null, null);
    }

    public List getMixinGenOperations() {
        return this.collectGenOperations(this.getMixinGenClasses(), null, new CollidingGenOperationFilter());
    }

    public void initialize(EClass eClass) {
        if (eClass != this.getEcoreClass()) {
            this.setEcoreClass(eClass);
            if (this.getLabelFeatureGen() != null && this.getLabelFeatureGen().eIsProxy()) {
                this.setLabelFeature(null);
            }
            this.setImage(!eClass.isAbstract());
        }
        int localFeatureIndex = 0;
        Iterator iter = eClass.getEStructuralFeatures().iterator();
        block0: while (iter.hasNext()) {
            GenFeature genFeature;
            GenFeature genFeature2;
            Iterator j;
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iter.next();
            if (eStructuralFeature instanceof EAttribute) {
                EAttribute attribute = (EAttribute)eStructuralFeature;
                j = this.getGenFeatures().iterator();
                while (j.hasNext()) {
                    genFeature2 = (GenFeature)j.next();
                    if (genFeature2.getEcoreFeature() != attribute) continue;
                    genFeature2.initialize((EStructuralFeature)attribute);
                    this.getGenFeatures().move(localFeatureIndex++, (Object)genFeature2);
                    continue block0;
                }
                genFeature = this.getGenModel().createGenFeature();
                this.getGenFeatures().add(localFeatureIndex++, (Object)genFeature);
                genFeature.initialize((EStructuralFeature)attribute);
                continue;
            }
            EReference reference = (EReference)eStructuralFeature;
            j = this.getGenFeatures().iterator();
            while (j.hasNext()) {
                genFeature2 = (GenFeature)j.next();
                if (genFeature2.getEcoreFeature() != reference) continue;
                genFeature2.initialize((EStructuralFeature)reference);
                this.getGenFeatures().move(localFeatureIndex++, (Object)genFeature2);
                continue block0;
            }
            genFeature = this.getGenModel().createGenFeature();
            this.getGenFeatures().add(localFeatureIndex++, (Object)genFeature);
            genFeature.initialize((EStructuralFeature)reference);
        }
        iter = eClass.getEOperations().iterator();
        block3: while (iter.hasNext()) {
            EOperation operation = (EOperation)iter.next();
            Iterator j = this.getGenOperations().iterator();
            while (j.hasNext()) {
                GenOperation genOperation = (GenOperation)j.next();
                if (genOperation.getEcoreOperation() != operation) continue;
                genOperation.initialize(operation);
                continue block3;
            }
            GenOperation genOperation = this.getGenModel().createGenOperation();
            this.getGenOperations().add((Object)genOperation);
            genOperation.initialize(operation);
        }
    }

    protected boolean hasModelContribution() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate(Monitor progressMonitor) {
        block8: {
            block7: {
                try {
                    int fileCount;
                    if (!this.canGenerate()) {
                        Object var3_2 = null;
                        break block7;
                    }
                    int n = fileCount = this.isInterface() ? 1 : 2;
                    if (this.isExternalInterface()) {
                        --fileCount;
                    }
                    progressMonitor.beginTask("", fileCount);
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{this.getFormattedName()}));
                    if (!(this.isExternalInterface() || this.getGenModel().isSuppressInterfaces() && !this.isInterface())) {
                        progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaInterface_message", new Object[]{String.valueOf(this.getGenPackage().getInterfacePackageName()) + "." + this.getInterfaceName()}));
                        this.generate(this.createMonitor(progressMonitor, 1), Generator.EMF_MODEL_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getGenModel().getModelDirectory(), this.getGenPackage().getInterfacePackageName(), this.getInterfaceName(), this.getGenModel().getClassEmitter(), new Object[]{new Object[]{this, Boolean.TRUE, Boolean.FALSE}});
                    }
                    if (!this.isInterface()) {
                        progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{this.getQualifiedClassName()}));
                        this.generate(this.createMonitor(progressMonitor, 1), Generator.EMF_MODEL_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getGenModel().getModelDirectory(), this.getGenPackage().getClassPackageName(), this.getClassName(), this.getGenModel().getClassEmitter(), new Object[]{new Object[]{this, this.getGenModel().isSuppressInterfaces() ? Boolean.TRUE : Boolean.FALSE, Boolean.TRUE}});
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    progressMonitor.done();
                    throw throwable;
                }
            }
            progressMonitor.done();
            return;
        }
        Object var3_4 = null;
        progressMonitor.done();
    }

    public String getModelInfo() {
        StringBuffer result = new StringBuffer();
        if (this.isMapEntry()) {
            StringBuffer names = new StringBuffer();
            StringBuffer body = new StringBuffer();
            Iterator i = this.getGenFeatures().iterator();
            while (i.hasNext()) {
                GenFeature genFeature = (GenFeature)i.next();
                this.appendLineBreak(body);
                body.append(genFeature.getQualifiedModelInfo());
                body.append(' ');
                names.append(genFeature.getEcoreFeature().getName());
                names.append(' ');
            }
            String features = names.toString().trim();
            if (!features.equals("key value")) {
                this.appendLineBreak(result);
                this.appendModelSetting(result, "features", features);
            }
            result.append(body);
        } else if (this.isExternalInterface()) {
            this.appendModelSetting(result, "instanceClass", this.getEcoreClass().getInstanceClassName());
        } else {
            if (this.getGenModel().isSuppressInterfaces()) {
                this.appendModelSetting(result, "kind", "class");
            }
            if (this.isInterface()) {
                this.appendModelSetting(result, "interface", "true");
            }
            if (this.isAbstract()) {
                this.appendModelSetting(result, "abstract", "true");
            }
            StringBuffer suppressedNames = new StringBuffer();
            StringBuffer suppressedInfo = new StringBuffer();
            Iterator iter = this.getGenFeatures().iterator();
            while (iter.hasNext()) {
                GenFeature genFeature = (GenFeature)iter.next();
                if (!genFeature.isSuppressedGetVisibility()) continue;
                suppressedNames.append(genFeature.getName());
                suppressedNames.append(' ');
                this.appendLineBreak(suppressedInfo);
                suppressedInfo.append(genFeature.getQualifiedModelInfo());
                suppressedInfo.append(' ');
            }
            if (suppressedNames.length() > 0) {
                this.appendLineBreak(result);
                this.appendModelSetting(result, "features", suppressedNames.toString().trim());
                result.append(suppressedInfo);
            }
        }
        this.appendAnnotationInfo(result, (EModelElement)this.getEcoreClass());
        return result.toString().trim();
    }

    public String getProviderClassName() {
        return String.valueOf(this.getName()) + "ItemProvider";
    }

    public String getQualifiedProviderClassName() {
        return String.valueOf(this.getGenPackage().getProviderPackageName()) + "." + this.getProviderClassName();
    }

    public String getImportedProviderClassName() {
        return this.getGenModel().getImportedName(this.getQualifiedProviderClassName());
    }

    public String getItemIconFileName() {
        return String.valueOf(this.getGenModel().getEditIconsDirectory()) + "/full/obj16/" + this.getName() + ".gif";
    }

    public String getCreateChildIconFileName(GenFeature feature, GenClass childClass) {
        GenClass parentClass = feature.getGenClass();
        return String.valueOf(this.getGenModel().getEditIconsDirectory()) + "/full/ctool16/" + "Create" + parentClass.getName() + "_" + feature.getName() + "_" + childClass.getName() + ".gif";
    }

    protected GenClass getProviderExtendsGenClass() {
        GenClass baseClass = this.getClassExtendsGenClass();
        while (!(baseClass == null || baseClass.getProvider() != GenProviderKind.NONE_LITERAL && baseClass.getGenModel().hasEditSupport())) {
            baseClass = baseClass.getClassExtendsGenClass();
        }
        return baseClass;
    }

    public String getProviderBaseClassName() {
        GenClass baseClass = this.getProviderExtendsGenClass();
        return baseClass != null ? baseClass.getImportedProviderClassName() : null;
    }

    public List getProviderImplementedGenClasses() {
        List allBases = this.getAllBaseGenClasses();
        GenClass extendedBase = this.getProviderExtendsGenClass();
        int i = extendedBase == null ? 0 : allBases.indexOf(extendedBase) + 1;
        ArrayList<GenClassImpl> result = new ArrayList<GenClassImpl>(allBases.subList(i, allBases.size()));
        result.add(this);
        return result;
    }

    protected List getProviderImplementedGenFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, null);
    }

    public List getLabelFeatureCandidates() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !genFeature.isReferenceType() && !genFeature.isListType() && !genFeature.isMapType() && !genFeature.isSuppressedGetVisibility();
            }
        });
    }

    public List getPropertyFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isProperty();
            }
        });
    }

    public List getNotifyFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isNotify();
            }
        });
    }

    public List getLabelNotifyFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isNotify() && !genFeature.isChildren();
            }
        });
    }

    public List getContentNotifyFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isNotify() && genFeature.isChildren() && genFeature != GenClassImpl.this.getLabelFeature();
            }
        });
    }

    public List getLabelAndContentNotifyFeatures() {
        GenFeature feature = this.getLabelFeature();
        return feature != null && feature.isNotify() && feature.isChildren() ? Collections.singletonList(feature) : Collections.EMPTY_LIST;
    }

    public List getChildrenFeatures() {
        return this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isChildren();
            }
        });
    }

    public List getAllChildrenFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isChildren();
            }
        });
    }

    public List getCreateChildFeatures() {
        ArrayList<GenFeature> result = new ArrayList<GenFeature>();
        final GenFeature mixed = this.getMixedGenFeature();
        if (mixed != null && mixed.isCreateChild()) {
            result.add(mixed);
        }
        result.addAll(this.collectGenFeatures(this.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isCreateChild() && genFeature != mixed;
            }
        }));
        return result;
    }

    public List getAllCreateChildFeatures() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isCreateChild();
            }
        });
    }

    public List getAllCreateChildFeaturesIncludingDelegation() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                while (genFeature != null) {
                    if (genFeature.isCreateChild()) {
                        return true;
                    }
                    genFeature = genFeature.getDelegateFeature();
                }
                return false;
            }
        });
    }

    public List getCrossPackageCreateChildFeatures() {
        GenClass base = this.getProviderExtendsGenClass();
        if (base == null || base.getGenPackage() == this.getGenPackage() || this.getGenModel().getAllGenPackagesWithClassifiers().contains(base.getGenPackage())) {
            return Collections.EMPTY_LIST;
        }
        return this.collectGenFeatures(base.getProviderImplementedGenClasses(), null, new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return genFeature.isCreateChild() && genFeature.isReferenceType();
            }
        });
    }

    public List getSharedClassCreateChildFeatures() {
        List childrenFeatures = this.getAllCreateChildFeatures();
        LinkedHashMap<GenClass, ArrayList<GenFeature>> classToFeatureMap = new LinkedHashMap<GenClass, ArrayList<GenFeature>>();
        List packages = this.getGenModel().getAllGenAndUsedGenPackagesWithClassifiers();
        Iterator iter = childrenFeatures.iterator();
        while (iter.hasNext()) {
            GenFeature f = (GenFeature)iter.next();
            List<GenFeature> fl = f.isFeatureMapType() ? f.getDelegatedFeatures() : Collections.singletonList(f);
            Iterator<GenFeature> fIter = fl.iterator();
            while (fIter.hasNext()) {
                GenFeature genFeature = fIter.next();
                List genClasses = this.getTypeGenClasses(genFeature.getEcoreFeature().getEType(), null, packages, -1);
                Iterator cIter = genClasses.iterator();
                while (cIter.hasNext()) {
                    GenClass genClass = (GenClass)cIter.next();
                    ArrayList<GenFeature> genFeatures = (ArrayList<GenFeature>)classToFeatureMap.get(genClass);
                    if (genFeatures == null) {
                        genFeatures = new ArrayList<GenFeature>(5);
                        classToFeatureMap.put(genClass, genFeatures);
                    }
                    genFeatures.add(genFeature);
                }
            }
        }
        UniqueEList result = new UniqueEList(childrenFeatures.size());
        Iterator iter2 = classToFeatureMap.values().iterator();
        while (iter2.hasNext()) {
            List genFeatures = (List)iter2.next();
            if (genFeatures.size() <= 1) continue;
            result.addAll(genFeatures);
        }
        return result;
    }

    public boolean hasFeatureMapCreateChildFeatures() {
        Iterator iter = this.getAllCreateChildFeatures().iterator();
        while (iter.hasNext()) {
            GenFeature genFeature = (GenFeature)iter.next();
            if (!genFeature.isFeatureMapType()) continue;
            return true;
        }
        return false;
    }

    public List getChildrenClasses(GenFeature genFeature) {
        return this.getTypeGenClasses(genFeature.getEcoreFeature().getEType(), this.getGenPackage(), this.getGenModel().getAllGenAndUsedGenPackagesWithClassifiers(), -1);
    }

    public List getCrossPackageChildrenClasses(GenFeature genFeature) {
        return this.getTypeGenClasses(genFeature.getEcoreFeature().getEType(), this.getGenPackage(), this.getGenModel().getAllGenPackagesWithClassifiers(), -1);
    }

    public GenFeature getLabelFeatureGen() {
        if (this.labelFeature != null && this.labelFeature.eIsProxy()) {
            InternalEObject oldLabelFeature = (InternalEObject)this.labelFeature;
            this.labelFeature = (GenFeature)this.eResolveProxy(oldLabelFeature);
            if (this.labelFeature != oldLabelFeature && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 8, (Object)oldLabelFeature, (Object)this.labelFeature));
            }
        }
        return this.labelFeature;
    }

    public GenFeature getLabelFeature() {
        GenFeature labelFeature = this.getLabelFeatureGen();
        if (labelFeature != null) {
            return labelFeature;
        }
        Iterator iter = this.getLabelFeatureCandidates().iterator();
        while (iter.hasNext()) {
            String featureName;
            GenFeature feature = (GenFeature)iter.next();
            if (feature.isListType() || (featureName = feature.getName()) == null) continue;
            if (featureName.equalsIgnoreCase("name")) {
                labelFeature = feature;
                continue;
            }
            if (featureName.equalsIgnoreCase("id")) {
                if (labelFeature != null && labelFeature.getName().toLowerCase().endsWith("name")) continue;
                labelFeature = feature;
                continue;
            }
            if (featureName.toLowerCase().endsWith("name")) {
                if (labelFeature != null && (labelFeature.getName().toLowerCase().endsWith("name") || labelFeature.getName().equalsIgnoreCase("id"))) continue;
                labelFeature = feature;
                continue;
            }
            if (featureName.toLowerCase().indexOf("name") != -1) {
                if (labelFeature != null && (labelFeature.getName().toLowerCase().indexOf("name") != -1 || labelFeature.getName().equalsIgnoreCase("id"))) continue;
                labelFeature = feature;
                continue;
            }
            if (labelFeature != null) continue;
            labelFeature = feature;
        }
        return labelFeature;
    }

    public GenFeature basicGetLabelFeature() {
        return this.labelFeature;
    }

    public void setLabelFeature(GenFeature newLabelFeature) {
        GenFeature oldLabelFeature = this.labelFeature;
        this.labelFeature = newLabelFeature;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldLabelFeature, (Object)this.labelFeature));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getGenFeatures()).basicAdd((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getGenOperations()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getGenFeatures()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getGenOperations()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getProvider();
            }
            case 3: {
                return this.isImage() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.isDynamic() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                if (resolve) {
                    return this.getEcoreClass();
                }
                return this.basicGetEcoreClass();
            }
            case 6: {
                return this.getGenFeatures();
            }
            case 7: {
                return this.getGenOperations();
            }
            case 8: {
                if (resolve) {
                    return this.getLabelFeature();
                }
                return this.basicGetLabelFeature();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setProvider((GenProviderKind)((Object)newValue));
                return;
            }
            case 3: {
                this.setImage((Boolean)newValue);
                return;
            }
            case 4: {
                this.setDynamic((Boolean)newValue);
                return;
            }
            case 5: {
                this.setEcoreClass((EClass)newValue);
                return;
            }
            case 6: {
                this.getGenFeatures().clear();
                this.getGenFeatures().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getGenOperations().clear();
                this.getGenOperations().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.setLabelFeature((GenFeature)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setProvider(PROVIDER_EDEFAULT);
                return;
            }
            case 3: {
                this.setImage(true);
                return;
            }
            case 4: {
                this.setDynamic(false);
                return;
            }
            case 5: {
                this.setEcoreClass(null);
                return;
            }
            case 6: {
                this.getGenFeatures().clear();
                return;
            }
            case 7: {
                this.getGenOperations().clear();
                return;
            }
            case 8: {
                this.setLabelFeature(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.provider != PROVIDER_EDEFAULT;
            }
            case 3: {
                return !this.image;
            }
            case 4: {
                return this.dynamic;
            }
            case 5: {
                return this.ecoreClass != null;
            }
            case 6: {
                return this.genFeatures != null && !this.genFeatures.isEmpty();
            }
            case 7: {
                return this.genOperations != null && !this.genOperations.isEmpty();
            }
            case 8: {
                return this.labelFeature != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (provider: ");
        result.append((Object)this.provider);
        result.append(", image: ");
        result.append(this.image);
        result.append(", dynamic: ");
        result.append(this.dynamic);
        result.append(')');
        return result.toString();
    }

    public String getItemProviderAdapterFactoryClassName() {
        return this.getGenPackage().getItemProviderAdapterFactoryClassName();
    }

    public String getTestCaseClassName() {
        return String.valueOf(this.getName()) + "Test";
    }

    public String getQualifiedTestCaseClassName() {
        return String.valueOf(this.getGenPackage().getTestsPackageName()) + "." + this.getTestCaseClassName();
    }

    public String getImportedTestCaseClassName() {
        return this.getGenModel().getImportedName(this.getQualifiedTestCaseClassName());
    }

    public boolean canGenerate() {
        return super.canGenerate() && !this.isDynamic();
    }

    public boolean canGenerateEdit() {
        return super.canGenerateEdit() && !this.isInterface() && this.getProvider() != GenProviderKind.NONE_LITERAL;
    }

    public boolean canGenerateEditor() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateEdit(Monitor progressMonitor) {
        block9: {
            block8: {
                try {
                    if (!this.canGenerateEdit()) {
                        Object var6_2 = null;
                        break block8;
                    }
                    progressMonitor.beginTask("", 2 + this.getAllCreateChildFeatures().size());
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingProvider_message", new Object[]{this.getFormattedName()}));
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{this.getQualifiedProviderClassName()}));
                    this.generate(this.createMonitor(progressMonitor, 1), Generator.EMF_EDIT_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getGenModel().getEditDirectory(), this.getGenPackage().getProviderPackageName(), this.getProviderClassName(), this.getGenModel().getItemProviderEmitter());
                    if (this.isImage()) {
                        progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingItemIcon_message", new Object[]{this.getItemIconFileName()}));
                        this.generate(this.createMonitor(progressMonitor, 1), Generator.EMF_EDIT_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getItemIconFileName(), ((GenModelImpl)this.getGenModel()).getItemGIFEmitter(), this.getName());
                    }
                    if (this.getGenModel().isCreationCommands() && this.getGenModel().isCreationIcons()) {
                        Iterator iter = this.getAllCreateChildFeaturesIncludingDelegation().iterator();
                        while (iter.hasNext()) {
                            GenFeature feature = (GenFeature)iter.next();
                            Iterator cIter = this.getChildrenClasses(feature).iterator();
                            while (cIter.hasNext()) {
                                GenClass childClass = (GenClass)cIter.next();
                                progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingCreateChildIcon_message", new Object[]{this.getCreateChildIconFileName(feature, childClass)}));
                                this.generate(this.createMonitor(progressMonitor, 1), Generator.EMF_EDIT_PROJECT_STYLE, this.getGenModel().getEffectiveModelPluginVariables(), this.getCreateChildIconFileName(feature, childClass), ((GenModelImpl)this.getGenModel()).getCreateChildGIFEmitter(), this.getName(), childClass.getName());
                            }
                        }
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var6_3 = null;
                    progressMonitor.done();
                    throw throwable;
                }
            }
            progressMonitor.done();
            return;
        }
        Object var6_4 = null;
        progressMonitor.done();
    }

    public boolean hasTests() {
        Iterator i = this.getAllGenFeatures().iterator();
        while (i.hasNext()) {
            GenFeature genFeature = (GenFeature)i.next();
            if (!(genFeature.isGet() && !genFeature.isSuppressedGetVisibility() || genFeature.isSet() && !genFeature.isSuppressedSetVisibility() || genFeature.isUnset() && !genFeature.isSuppressedUnsetVisibility()) && (!genFeature.isIsSet() || genFeature.isSuppressedIsSetVisibility()) || !genFeature.isVolatile() && !genFeature.isDerived()) continue;
            return true;
        }
        return !this.getAllGenOperations().isEmpty();
    }

    public boolean canGenerateTests() {
        return this.getGenModel().canGenerateTests() && !this.isExternalInterface();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateTests(Monitor progressMonitor) {
        block5: {
            block4: {
                try {
                    if (!this.canGenerateTests()) {
                        Object var2_2 = null;
                        break block4;
                    }
                    progressMonitor.beginTask("", 1);
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingTestCase_message", new Object[]{this.getFormattedName()}));
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingJavaClass_message", new Object[]{this.getQualifiedTestCaseClassName()}));
                    this.generate(this.createMonitor(progressMonitor, 1), Generator.EMF_TESTS_PROJECT_STYLE, Collections.EMPTY_LIST, this.getGenModel().getTestsDirectory(), this.getGenPackage().getTestsPackageName(), this.getTestCaseClassName(), this.getGenModel().getTestCaseEmitter());
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    progressMonitor.done();
                    throw throwable;
                }
            }
            progressMonitor.done();
            return;
        }
        Object var2_4 = null;
        progressMonitor.done();
    }

    public boolean reconcile(GenClass oldGenClassVersion) {
        if (this.getEcoreClass().getName().equals(oldGenClassVersion.getEcoreClass().getName())) {
            Iterator j;
            Iterator i = this.getGenFeatures().iterator();
            block0: while (i.hasNext()) {
                GenFeature genFeature = (GenFeature)i.next();
                j = oldGenClassVersion.getGenFeatures().iterator();
                while (j.hasNext()) {
                    GenFeature oldGenFeatureVersion = (GenFeature)j.next();
                    if (genFeature.reconcile(oldGenFeatureVersion)) continue block0;
                }
            }
            i = this.getGenOperations().iterator();
            block2: while (i.hasNext()) {
                GenOperation genOperation = (GenOperation)i.next();
                j = oldGenClassVersion.getGenOperations().iterator();
                while (j.hasNext()) {
                    GenOperation oldGenOperation = (GenOperation)j.next();
                    if (genOperation.reconcile(oldGenOperation)) continue block2;
                }
            }
            this.reconcileSettings(oldGenClassVersion);
            return true;
        }
        return false;
    }

    protected void reconcileSettings(GenClass oldGenClassVersion) {
        EStructuralFeature newLabelFeature;
        this.setProvider(oldGenClassVersion.getProvider());
        this.setImage(oldGenClassVersion.isImage());
        GenFeature oldLabelFeature = ((GenClassImpl)oldGenClassVersion).getLabelFeatureGen();
        if (oldLabelFeature != null && (newLabelFeature = this.getEcoreClass().getEStructuralFeature(oldLabelFeature.getEcoreFeature().getName())) != null) {
            this.setLabelFeature(this.findGenFeature(newLabelFeature));
        }
        this.setDynamic(oldGenClassVersion.isDynamic());
        this.reconcileGenAnnotations(oldGenClassVersion);
    }

    public boolean reconcile() {
        block5: {
            EClass eClass = this.getEcoreClass();
            if (eClass != null && !eClass.eIsProxy() && eClass.eResource() != null) break block5;
            return false;
        }
        try {
            Iterator i = this.getGenFeatures().iterator();
            while (i.hasNext()) {
                GenFeature genFeature = (GenFeature)i.next();
                if (genFeature.reconcile()) continue;
                i.remove();
            }
            i = this.getGenOperations().iterator();
            while (i.hasNext()) {
                GenOperation genOperation = (GenOperation)i.next();
                if (genOperation.reconcile()) continue;
                i.remove();
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public List getGenConstraints() {
        UniqueEList result = new UniqueEList((Collection)super.getGenConstraints());
        Iterator i = this.getInvariantOperations().iterator();
        while (i.hasNext()) {
            GenOperation genOperation = (GenOperation)i.next();
            result.add(genOperation.getName());
        }
        return result;
    }

    public List getAllGenConstraints() {
        ArrayList result = new ArrayList(INTRINSIC_CONSTRAINTS);
        result.addAll(this.collectGenConstraints(this.getAllBaseGenClasses(), this.getGenConstraints(), null));
        return result;
    }

    public GenClassifier getConstraintImplementor(String constraint) {
        if (this.getGenConstraints().contains(constraint)) {
            return this;
        }
        Iterator i = this.getBaseGenClasses().iterator();
        while (i.hasNext()) {
            GenClass baseGenClass = (GenClass)i.next();
            if (baseGenClass.getGenConstraints().contains(constraint)) {
                return baseGenClass;
            }
            if (!baseGenClass.getAllGenConstraints().contains(constraint)) continue;
            return baseGenClass.getConstraintImplementor(constraint);
        }
        return null;
    }

    public GenClassifier getConstraintDelegate(String constraint) {
        Iterator i = this.getBaseGenClasses().iterator();
        while (i.hasNext()) {
            GenClass baseGenClass = (GenClass)i.next();
            if (baseGenClass.getGenConstraints().contains(constraint)) {
                return baseGenClass;
            }
            if (!baseGenClass.getAllGenConstraints().contains(constraint)) continue;
            return baseGenClass.getConstraintImplementor(constraint);
        }
        return null;
    }

    public boolean hasOnlyDefaultConstraints() {
        Iterator i = this.getAllGenConstraints().iterator();
        while (i.hasNext()) {
            String genConstraint = (String)i.next();
            if (this.getConstraintImplementor(genConstraint) == null) continue;
            return false;
        }
        return true;
    }

    public List getInvariantOperations() {
        return this.collectGenOperations(null, (List)this.getGenOperations(), new GenBaseImpl.GenOperationFilter(){

            public boolean accept(GenOperation genOperation) {
                return genOperation.isInvariant();
            }
        });
    }

    public GenOperation getInvariantOperation(String constraint) {
        Iterator j = this.getInvariantOperations().iterator();
        while (j.hasNext()) {
            GenOperation genOperation = (GenOperation)j.next();
            if (!genOperation.getName().equals(constraint)) continue;
            return genOperation;
        }
        return null;
    }

    public boolean isDocumentRoot() {
        return this.getExtendedMetaData().getDocumentRoot(this.getEcoreClass().getEPackage()) == this.getEcoreClass();
    }

    protected boolean isMixed() {
        return this.getExtendedMetaData().getContentKind(this.getEcoreClass()) == 3;
    }

    public GenFeature getMixedGenFeature() {
        if (!this.isMixed()) {
            return null;
        }
        EAttribute mixedFeature = this.getExtendedMetaData().getMixedFeature(this.getEcoreClass());
        return mixedFeature != null ? this.findGenFeature((EStructuralFeature)mixedFeature) : null;
    }

    public String getListConstructor(GenFeature genFeature) {
        String unsettable;
        StringBuffer sb = new StringBuffer();
        String string = unsettable = genFeature.isUnsettable() ? ".Unsettable" : "";
        if (genFeature.isMapType()) {
            GenClass mapGenClass = genFeature.getMapEntryTypeGenClass();
            sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.EcoreEMap"));
            sb.append(unsettable);
            sb.append("(");
            sb.append(mapGenClass.getQualifiedClassifierAccessor());
            sb.append(", ");
            sb.append(genFeature.getImportedMapEntryType());
            sb.append(".class, this, ");
            sb.append(this.getQualifiedFeatureID(genFeature));
            sb.append(")");
        } else if (genFeature.isFeatureMapType()) {
            if (genFeature.isWrappedFeatureMapType()) {
                sb.append(genFeature.getImportedEffectiveFeatureMapWrapperClass());
                sb.append("(new ");
            }
            sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.BasicFeatureMap"));
            sb.append("(this, ");
            sb.append(this.getQualifiedFeatureID(genFeature));
            sb.append(")");
            if (genFeature.isWrappedFeatureMapType()) {
                sb.append(")");
            }
        } else if (this.getGenModel().isSuppressNotification()) {
            sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.BasicInternalEList"));
            sb.append("(");
            sb.append(genFeature.getListItemType());
            sb.append(".class)");
        } else if (genFeature.isEffectiveContains()) {
            if (genFeature.isBidirectional()) {
                GenFeature reverseFeature = genFeature.getReverse();
                sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList"));
                sb.append(unsettable);
                if (genFeature.isResolveProxies()) {
                    sb.append(".Resolving");
                }
                sb.append("(");
                sb.append(genFeature.getListItemType());
                sb.append(".class, this, ");
                sb.append(this.getQualifiedFeatureID(genFeature));
                sb.append(", ");
                sb.append(reverseFeature.getGenClass().getQualifiedFeatureID(reverseFeature));
                sb.append(")");
            } else {
                sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.EObjectContainmentEList"));
                sb.append(unsettable);
                if (genFeature.isResolveProxies()) {
                    sb.append(".Resolving");
                }
                sb.append("(");
                sb.append(genFeature.getListItemType());
                sb.append(".class, this, ");
                sb.append(this.getQualifiedFeatureID(genFeature));
                sb.append(")");
            }
        } else if (genFeature.isReferenceType()) {
            if (genFeature.isBidirectional()) {
                GenFeature reverseFeature = genFeature.getReverse();
                if (genFeature.isResolveProxies()) {
                    sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList"));
                } else {
                    sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.EObjectWithInverseEList"));
                }
                sb.append(unsettable);
                if (reverseFeature.isListType()) {
                    sb.append(".ManyInverse");
                }
                sb.append("(");
                sb.append(genFeature.getListItemType());
                sb.append(".class, this, ");
                sb.append(this.getQualifiedFeatureID(genFeature));
                sb.append(", ");
                sb.append(reverseFeature.getGenClass().getQualifiedFeatureID(reverseFeature));
                sb.append(")");
            } else {
                if (genFeature.isResolveProxies()) {
                    sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.EObjectResolvingEList"));
                } else {
                    sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.EObjectEList"));
                }
                sb.append(unsettable);
                sb.append("(");
                sb.append(genFeature.getListItemType());
                sb.append(".class, this, ");
                sb.append(this.getQualifiedFeatureID(genFeature));
                sb.append(")");
            }
        } else {
            if (genFeature.isUnique()) {
                sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.EDataTypeUniqueEList"));
            } else {
                sb.append(this.getGenModel().getImportedName("org.eclipse.emf.ecore.util.EDataTypeEList"));
            }
            sb.append(unsettable);
            sb.append("(");
            sb.append(genFeature.getListItemType());
            sb.append(".class, this, ");
            sb.append(this.getQualifiedFeatureID(genFeature));
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isModelRoot() {
        return this.getClassExtendsGenClass() == null || this.getClassExtendsGenClass().getGenModel() != this.getGenModel();
    }

    public List getDeclaredFieldGenFeatures() {
        return this.getImplementedGenFeatures();
    }

    public boolean isFlag(GenFeature genFeature) {
        return this.getImplementingGenModel(genFeature).isBooleanFlagsEnabled() && genFeature.isFlag();
    }

    public boolean isESetFlag(GenFeature genFeature) {
        GenModel genModel = this.getImplementingGenModel(genFeature);
        return (!genModel.isVirtualDelegation() || genFeature.isPrimitiveType()) && genModel.isBooleanFlagsEnabled() && genFeature.isESetFlag();
    }

    public boolean isField(GenFeature genFeature) {
        GenModel genModel = this.getImplementingGenModel(genFeature);
        return !genModel.isReflectiveDelegation() && (!genModel.isVirtualDelegation() || genFeature.isPrimitiveType()) && genFeature.isField();
    }

    public boolean isESetField(GenFeature genFeature) {
        GenModel genModel = this.getImplementingGenModel(genFeature);
        return !genModel.isReflectiveDelegation() && (!genModel.isVirtualDelegation() || genFeature.isPrimitiveType()) && genFeature.isESetField();
    }

    public boolean implementsAny(Collection genFeatures) {
        List implementedGenFeatures = this.getImplementedGenFeatures();
        if (!implementedGenFeatures.isEmpty()) {
            Iterator i = genFeatures.iterator();
            while (i.hasNext()) {
                if (!implementedGenFeatures.contains(i.next())) continue;
                return true;
            }
        }
        return false;
    }

    protected int getNonPrimitiveFeatureCount() {
        return this.collectGenFeatures(this.getAllBaseGenClasses(), (List)this.getGenFeatures(), new GenBaseImpl.GenFeatureFilter(){

            public boolean accept(GenFeature genFeature) {
                return !genFeature.isPrimitiveType();
            }
        }).size();
    }

    public String getEVirtualValuesField() {
        String eVirtualValuesField = null;
        GenClass classExtendsGenClass = this.getClassExtendsGenClass();
        while (eVirtualValuesField == null && classExtendsGenClass != null) {
            eVirtualValuesField = classExtendsGenClass.getEVirtualValuesField();
            classExtendsGenClass = classExtendsGenClass.getClassExtendsGenClass();
        }
        return eVirtualValuesField == null && this.getGenModel().isVirtualDelegation() && this.getNonPrimitiveFeatureCount() > 0 ? "eVirtualValues" : null;
    }

    public List getEVirtualIndexBitFields(List eVirtualIndexBitFields) {
        if (this.getGenModel().isVirtualDelegation() && this.getNonPrimitiveFeatureCount() > 0) {
            GenClass classExtendsGenClass = this.getClassExtendsGenClass();
            int i = classExtendsGenClass == null ? 0 : classExtendsGenClass.getAllEVirtualIndexBitFields(new ArrayList()).size();
            while (i < this.getFeatureCount() / 32 + 1) {
                eVirtualIndexBitFields.add("eVirtualIndexBits" + i);
                ++i;
            }
        }
        return eVirtualIndexBitFields;
    }

    public List getAllEVirtualIndexBitFields(List allEVirtualIndexBitFields) {
        GenClass classExtendsGenClass = this.getClassExtendsGenClass();
        return this.getEVirtualIndexBitFields(classExtendsGenClass == null ? allEVirtualIndexBitFields : classExtendsGenClass.getAllEVirtualIndexBitFields(allEVirtualIndexBitFields));
    }

    public boolean isJavaIOSerializable() {
        Iterator i = this.getAllBaseGenClasses().iterator();
        while (i.hasNext()) {
            GenClass baseGenClass = (GenClass)i.next();
            if (!"java.io.Serializeable".equals(baseGenClass.getQualifiedInterfaceName())) continue;
            return true;
        }
        GenClass rootImplementsInterfaceGenClass = this.getGenModel().getRootImplementsInterfaceGenClass();
        if (rootImplementsInterfaceGenClass != null) {
            Iterator i2 = rootImplementsInterfaceGenClass.getAllBaseGenClasses().iterator();
            while (i2.hasNext()) {
                GenClass baseGenClass = (GenClass)i2.next();
                if (!"java.io.Serializable".equals(baseGenClass.getQualifiedInterfaceName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasFactoryInterfaceCreateMethod() {
        return !this.isAbstract() && !this.isMapEntry() && (!this.getGenModel().isSuppressEMFMetaData() || !"org.eclipse.emf.ecore.EObject".equals(this.getQualifiedInterfaceName()));
    }

    public class CollidingGenOperationFilter
    implements GenBaseImpl.GenOperationFilter {
        protected List allGenFeatures;
        protected List extendsGenClassOperations;

        public CollidingGenOperationFilter() {
            this.allGenFeatures = GenClassImpl.this.getAllGenFeatures();
            GenClass extendsClass = GenClassImpl.this.getClassExtendsGenClass();
            this.extendsGenClassOperations = extendsClass != null ? extendsClass.getAllGenOperations() : Collections.EMPTY_LIST;
        }

        public boolean accept(GenOperation genOperation) {
            GenFeature genFeature;
            Iterator i;
            if (genOperation.getName().startsWith("isSet") && genOperation.getGenParameters().isEmpty()) {
                i = this.allGenFeatures.iterator();
                while (i.hasNext()) {
                    genFeature = (GenFeature)i.next();
                    if (!genFeature.isChangeable() || !genFeature.isUnsettable() || !genOperation.getName().equals("isSet" + genFeature.getAccessorName())) continue;
                    return false;
                }
            } else if ((genOperation.getName().startsWith("get") || genOperation.getName().startsWith("is")) && genOperation.getGenParameters().isEmpty()) {
                i = this.allGenFeatures.iterator();
                while (i.hasNext()) {
                    genFeature = (GenFeature)i.next();
                    if (!genFeature.getGetAccessor().equals(genOperation.getName())) continue;
                    return false;
                }
            } else if (genOperation.getName().startsWith("set") && genOperation.getGenParameters().size() == 1) {
                GenParameter genParameter = (GenParameter)genOperation.getGenParameters().get(0);
                Iterator i2 = this.allGenFeatures.iterator();
                while (i2.hasNext()) {
                    GenFeature genFeature2 = (GenFeature)i2.next();
                    if (!genFeature2.isChangeable() || genFeature2.isListType() || !genOperation.getName().equals("set" + genFeature2.getAccessorName()) || !genParameter.getType().equals(genFeature2.getType())) continue;
                    return false;
                }
            } else if (genOperation.getName().startsWith("unset") && genOperation.getGenParameters().isEmpty()) {
                i = this.allGenFeatures.iterator();
                while (i.hasNext()) {
                    genFeature = (GenFeature)i.next();
                    if (!genFeature.isChangeable() || !genFeature.isUnsettable() || !genOperation.getName().equals("unset" + genFeature.getAccessorName())) continue;
                    return false;
                }
            }
            if (!genOperation.hasBody()) {
                i = this.extendsGenClassOperations.iterator();
                while (i.hasNext()) {
                    GenOperation baseOperation = (GenOperation)i.next();
                    if (!baseOperation.isOverrideOf(genOperation)) continue;
                    return false;
                }
            }
            return !genOperation.getGenClass().isEObject();
        }
    }
}

