/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import com.darwinsys.util.FixedLengthFIFO;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;

public class FixedLengthFIFOTest
extends TestCase {
    private static final int SMALL_TEST_SIZE = 10;
    private static final String JUNKSTRING = "fjdklsjfdls";
    private static final String[] moreJunk = new String[]{"fjdklsjfdls", "jdklsfj", "abc", "def", "ghi", "jkl", "mno", "pqr", "stuart", "vwx", "zzz", "zzzz"};
    FixedLengthFIFO<String> ff;

    protected void setUp() throws Exception {
        this.ff = new FixedLengthFIFO(10);
    }

    public void testBasics() throws Exception {
        this.ff.add("hello");
        this.ff.add("goodbye");
        FixedLengthFIFOTest.assertEquals((int)2, (int)this.ff.size());
        FixedLengthFIFOTest.assertEquals((String)"hello", (String)this.ff.get(0));
        this.ff.remove("hello");
        FixedLengthFIFOTest.assertEquals((int)1, (int)this.ff.size());
        FixedLengthFIFOTest.assertFalse((boolean)this.ff.remove("nobody here"));
        this.ff.add(JUNKSTRING);
        FixedLengthFIFOTest.assertEquals((int)2, (int)this.ff.size());
        this.ff.add(JUNKSTRING);
        FixedLengthFIFOTest.assertEquals((int)3, (int)this.ff.size());
        FixedLengthFIFOTest.assertSame((Object)this.ff.indexOf(JUNKSTRING), (Object)this.ff.indexOf(JUNKSTRING));
        FixedLengthFIFOTest.assertNotSame((Object)this.ff.indexOf(JUNKSTRING), (Object)this.ff.lastIndexOf(JUNKSTRING));
    }

    public void testOnlyOne() throws Exception {
        this.ff = new FixedLengthFIFO(10);
        String string = "One";
        this.ff.add(string);
        this.ff.remove(string);
    }

    public void testLimits() throws Exception {
        FixedLengthFIFOTest.assertTrue((moreJunk.length > 10 ? 1 : 0) != 0);
        String[] stringArray = moreJunk;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String d = stringArray[n];
            this.ff.add(d);
            ++n;
        }
        FixedLengthFIFOTest.assertEquals((int)10, (int)this.ff.size());
        FixedLengthFIFOTest.assertSame((Object)this.ff.get(9), (Object)moreJunk[moreJunk.length - 1]);
    }

    public void testIterator() throws Exception {
        this.ff.add("Test data one");
        this.ff.add("Test data two");
        Iterator<String> it = this.ff.iterator();
        try {
            System.out.println("First element from first iterator: " + it.next());
            it.remove();
            FixedLengthFIFOTest.fail((String)"Iterator.remove() did not throw expected Exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        while (it.hasNext()) {
            System.out.println("Iterator 1 output: " + it.next());
        }
        Iterator<String> it2 = this.ff.iterator();
        FixedLengthFIFOTest.assertNotSame(it, it2);
        while (it2.hasNext()) {
            System.out.println("Iterator 2 output: " + it2.next());
        }
        Iterator<String> it3 = this.ff.iterator();
        this.ff.add("any old thing");
        try {
            Boolean o = it3.hasNext();
            System.out.println(o);
            FixedLengthFIFOTest.fail((String)"did not throw ConcurrentModificationException");
        }
        catch (ConcurrentModificationException e) {
            System.out.println("Did catch expected ConcurrentModificationException");
        }
    }

    public void testTypes() {
        FixedLengthFIFO<Date> ff = new FixedLengthFIFO<Date>(15);
        ff.add(new Date());
        Date today = Calendar.getInstance().getTime();
        ff.add(today);
        FixedLengthFIFOTest.assertEquals((int)2, (int)ff.size());
        FixedLengthFIFOTest.assertSame(ff.get(1), (Object)today);
    }

    public void testToArrayArrayType() {
        String[] o = this.ff.toArray((String[])new String[0]);
        FixedLengthFIFOTest.assertNotNull((Object)o);
        System.out.println(o.getClass().getName());
        Vector vv = new Vector();
        String[] ov = vv.toArray(new String[0]);
        System.out.println(ov.getClass().getName());
    }

    public void testLastIndex() {
        int where = this.ff.size();
        String d = "JKDJFLSJLKDJF";
        this.ff.add(d);
        this.ff.add(new Date().toString());
        FixedLengthFIFOTest.assertEquals((int)where, (int)this.ff.lastIndexOf(d));
    }

    public void testSet() {
        this.ff.add("hello");
        this.ff.add("goodbye");
        this.ff.set(0, "new");
        FixedLengthFIFOTest.assertEquals((int)2, (int)this.ff.size());
        FixedLengthFIFOTest.assertEquals((String)"goodbye", (String)this.ff.get(1));
        FixedLengthFIFOTest.assertEquals((String)"new", (String)this.ff.get(0));
    }

    public void testSubList() {
        FixedLengthFIFO<Integer> gg = new FixedLengthFIFO<Integer>(10);
        Integer i1 = 10;
        Integer i2 = 20;
        Integer i3 = 30;
        Integer i4 = 40;
        gg.add(i1);
        gg.add(i2);
        gg.add(i3);
        gg.add(i4);
        List remnant = gg.subList(1, 2);
        FixedLengthFIFOTest.assertEquals((int)2, (int)remnant.size());
        FixedLengthFIFOTest.assertSame((Object)i2, remnant.get(0));
        FixedLengthFIFOTest.assertSame((Object)i3, remnant.get(1));
    }
}

