/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.event;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.swingui.ArchitectSwingWorker;
import ca.sqlpower.architect.swingui.Lister;
import ca.sqlpower.architect.swingui.ListerProgressBarUpdater;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseComboBoxListener
extends ArchitectSwingWorker
implements ActionListener,
Lister {
    private static final Logger logger = Logger.getLogger(DatabaseComboBoxListener.class);
    protected SQLDatabase.PopulateProgressMonitor progressMonitor;
    private SQLDatabase database;
    private JComboBox databaseComboBox;
    private JComboBox catalogComboBox;
    private JComboBox schemaComboBox;
    private JProgressBar progressBar;
    private JPanel panel;
    private List<JComponent> enableDisableList;
    private List<JComponent> disableEnableList;
    private List<JComponent> visableInvisableList;
    private List<JComponent> invisableVisableList;

    public DatabaseComboBoxListener(JPanel panel, JComboBox databaseComboBox, JComboBox catalogComboBox, JComboBox schemaComboBox, JProgressBar progressBar) {
        this.panel = panel;
        this.databaseComboBox = databaseComboBox;
        this.catalogComboBox = catalogComboBox;
        this.schemaComboBox = schemaComboBox;
        this.progressBar = progressBar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.catalogComboBox.setEnabled(false);
        this.schemaComboBox.setEnabled(false);
        this.catalogComboBox.removeAllItems();
        this.schemaComboBox.removeAllItems();
        if (this.databaseComboBox.getSelectedItem() == null) {
            return;
        }
        this.database = new SQLDatabase((ArchitectDataSource)this.databaseComboBox.getSelectedItem());
        try {
            this.progressMonitor = this.database.getProgressMonitor();
        }
        catch (ArchitectException e1) {
            logger.debug((Object)"Error getting progressMonitor", (Throwable)e1);
        }
        new Thread(this).start();
    }

    @Override
    public void doStuff() throws Exception {
        try {
            ListerProgressBarUpdater progressBarUpdater = new ListerProgressBarUpdater(this.progressBar, this);
            progressBarUpdater.setDisableEnableList(this.disableEnableList);
            progressBarUpdater.setEnableDisableList(this.enableDisableList);
            progressBarUpdater.setInvisableVisableList(this.invisableVisableList);
            progressBarUpdater.setVisableInvisableList(this.visableInvisableList);
            new Timer(100, progressBarUpdater).start();
            this.database.populate();
        }
        catch (ArchitectException e) {
            logger.debug((Object)"Unexpected architect exception in ConnectionListener", (Throwable)e);
        }
    }

    @Override
    public void cleanup() throws ArchitectException {
        this.setCleanupExceptionMessage("Could not populate catalog dropdown!");
        this.catalogComboBox.removeAllItems();
        this.catalogComboBox.setEnabled(false);
        this.schemaComboBox.removeAllItems();
        this.schemaComboBox.setEnabled(false);
        try {
            if (this.database.isCatalogContainer()) {
                for (SQLObject o : this.database.getChildren()) {
                    this.catalogComboBox.addItem(o);
                }
                this.catalogComboBox.setEnabled(true);
            }
            if (this.database.isSchemaContainer()) {
                for (SQLObject o : this.database.getChildren()) {
                    this.schemaComboBox.addItem(o);
                }
                this.schemaComboBox.setEnabled(true);
                logger.info((Object)"Schema enabled");
            }
        }
        catch (ArchitectException ex) {
            JOptionPane.showMessageDialog(this.panel, "Database Connection Erorr", "Error", 0);
            this.database = null;
        }
    }

    @Override
    public Integer getJobSize() throws ArchitectException {
        if (this.progressMonitor != null) {
            return this.progressMonitor.getJobSize();
        }
        return null;
    }

    @Override
    public int getProgress() throws ArchitectException {
        if (this.progressMonitor != null) {
            return this.progressMonitor.getProgress();
        }
        return 0;
    }

    @Override
    public boolean isFinished() throws ArchitectException {
        if (this.progressMonitor != null) {
            return this.progressMonitor.isFinished();
        }
        return true;
    }

    public SQLDatabase getDatabase() {
        return this.database;
    }

    public void setEnableDisableList(List<JComponent> enableDisableList) {
        this.enableDisableList = enableDisableList;
    }

    public void setVisableInvisableList(List<JComponent> visableInvisableList) {
        this.visableInvisableList = visableInvisableList;
    }

    public void setDisableEnableList(List<JComponent> disableEnableList) {
        this.disableEnableList = disableEnableList;
    }

    public void setInvisableVisableList(List<JComponent> invisableVisableList) {
        this.invisableVisableList = invisableVisableList;
    }
}

