/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.LockedColumnException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.BasicTablePaneUI;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.DnDTreePathTransferable;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePaneUI;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePane
extends PlayPenComponent
implements Serializable,
Selectable,
DragSourceListener,
LayoutNode {
    private static final Logger logger = Logger.getLogger(TablePane.class);
    public static final int COLUMN_INDEX_TITLE = -1;
    public static final int COLUMN_INDEX_NONE = -2;
    public static final int COLUMN_INDEX_END_OF_PK = -3;
    public static final int COLUMN_INDEX_START_OF_NON_PK = -4;
    protected int insertionPoint;
    protected Insets margin = new Insets(1, 1, 1, 1);
    protected boolean selected;
    protected DropTargetListener dtl;
    protected ArrayList<Boolean> columnSelection;
    protected Map<SQLColumn, List<Color>> columnHighlight;
    protected SQLColumn draggingColumn;
    private boolean fullyQualifiedNameInHeader = false;
    private SQLTable model;
    SQLObjectListener columnListener = new ColumnListener();
    protected List<SelectionListener> selectionListeners = new LinkedList<SelectionListener>();

    static {
        UIManager.put("TablePaneUI", "ca.sqlpower.architect.swingui.BasicTablePaneUI");
    }

    public TablePane(TablePane tp, PlayPenContentPane parent) {
        super(parent);
        this.model = tp.model;
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.dtl = new TablePaneDropListener(this);
        this.margin = (Insets)tp.margin.clone();
        this.columnSelection = new ArrayList<Boolean>(tp.columnSelection);
        this.columnHighlight = new HashMap<SQLColumn, List<Color>>(tp.columnHighlight);
        try {
            PlayPenComponentUI newUi = (PlayPenComponentUI)tp.getUI().getClass().newInstance();
            newUi.installUI(this);
            this.setUI(newUi);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Woops, couldn't invoke no-args constructor of " + tp.getUI().getClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Woops, couldn't access no-args constructor of " + tp.getUI().getClass().getName());
        }
        this.insertionPoint = tp.insertionPoint;
        this.draggingColumn = tp.draggingColumn;
        this.selected = false;
    }

    public TablePane(SQLTable m, PlayPen parentPP) {
        super(parentPP.getPlayPenContentPane());
        this.setModel(m);
        this.setOpaque(true);
        this.setInsertionPoint(-2);
        this.dtl = new TablePaneDropListener(this);
        this.updateUI();
    }

    public String toString() {
        return "TablePane: " + this.model;
    }

    public void updateUI() {
        TablePaneUI ui = (TablePaneUI)BasicTablePaneUI.createUI(this);
        ui.installUI(this);
        this.setUI(ui);
    }

    public String getUIClassID() {
        return "TablePaneUI";
    }

    public Point getLocationOnScreen() {
        Point p = new Point();
        PlayPen pp = this.getPlayPen();
        this.getLocation(p);
        pp.zoomPoint(p);
        SwingUtilities.convertPointToScreen(p, pp);
        return p;
    }

    public void destroy() {
        try {
            ArchitectUtils.unlistenToHierarchy(this.columnListener, this.model);
        }
        catch (ArchitectException e) {
            logger.error((Object)"Caught exception while unlistening to all children", (Throwable)e);
        }
    }

    @Override
    public SQLTable getModel() {
        return this.model;
    }

    public void setModel(SQLTable m) {
        SQLTable old = this.model;
        if (m == null) {
            throw new IllegalArgumentException("model may not be null");
        }
        this.model = m;
        if (old != null) {
            try {
                ArchitectUtils.unlistenToHierarchy(this.columnListener, old);
            }
            catch (ArchitectException e) {
                logger.error((Object)"Caught exception while unlistening to old model", (Throwable)e);
            }
        }
        try {
            this.columnSelection = new ArrayList(m.getColumns().size());
            int i = 0;
            while (i < m.getColumns().size()) {
                this.columnSelection.add(Boolean.FALSE);
                ++i;
            }
            this.columnHighlight = new HashMap<SQLColumn, List<Color>>();
            for (SQLColumn column : this.model.getColumns()) {
                this.columnHighlight.put(column, new ArrayList());
            }
        }
        catch (ArchitectException e) {
            logger.error((Object)"Error getting children on new model", (Throwable)e);
        }
        try {
            ArchitectUtils.listenToHierarchy(this.columnListener, this.model);
        }
        catch (ArchitectException e) {
            logger.error((Object)"Caught exception while listening to new model", (Throwable)e);
        }
        this.setName("TablePane: " + this.model.getShortDisplayName());
        this.firePropertyChange("model", old, this.model);
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets argMargin) {
        Insets old = this.margin;
        this.margin = (Insets)argMargin.clone();
        this.firePropertyChange("margin", old, this.margin);
        this.revalidate();
    }

    public int getInsertionPoint() {
        return this.insertionPoint;
    }

    public void setInsertionPoint(int ip) {
        int old = this.insertionPoint;
        this.insertionPoint = ip;
        if (ip != old) {
            this.firePropertyChange("insertionPoint", old, this.insertionPoint);
            this.repaint();
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean isSelected) {
        if (!isSelected) {
            this.selectNone();
        }
        if (this.selected != isSelected) {
            this.selected = isSelected;
            this.fireSelectionEvent(new SelectionEvent(this, this.selected ? 1 : 2));
            this.repaint();
        }
    }

    public DropTargetListener getDropTargetListener() {
        return this.dtl;
    }

    public void selectNone() {
        int i = 0;
        while (i < this.columnSelection.size()) {
            this.columnSelection.set(i, Boolean.FALSE);
            ++i;
        }
        this.repaint();
    }

    public void deselectColumn(int i) {
        if (i < 0) {
            this.selectNone();
            return;
        }
        this.columnSelection.set(i, Boolean.FALSE);
        this.repaint();
    }

    public void selectColumn(int i) {
        if (i < 0) {
            this.selectNone();
            return;
        }
        this.columnSelection.set(i, Boolean.TRUE);
        this.repaint();
    }

    public boolean isColumnSelected(int i) {
        try {
            return this.columnSelection.get(i);
        }
        catch (IndexOutOfBoundsException ex) {
            logger.error((Object)("Couldn't determine selected status of col " + i + " on table " + this.model.getName()));
            return false;
        }
    }

    public int getSelectedColumnIndex() {
        ListIterator<Boolean> it = this.columnSelection.listIterator();
        while (it.hasNext()) {
            if (!it.next().booleanValue()) continue;
            return it.previousIndex();
        }
        return -2;
    }

    public List<SQLColumn> getSelectedColumns() throws ArchitectException {
        ArrayList<SQLColumn> selectedColumns = new ArrayList<SQLColumn>();
        int i = 0;
        while (i < this.getModel().getColumns().size()) {
            if (this.isColumnSelected(i)) {
                selectedColumns.add(this.getModel().getColumn(i));
            }
            ++i;
        }
        return selectedColumns;
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.add(l);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        this.selectionListeners.remove(l);
    }

    protected void fireSelectionEvent(SelectionEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notifying " + this.selectionListeners.size() + " listeners of selection change"));
        }
        Iterator<SelectionListener> it = this.selectionListeners.iterator();
        if (e.getType() == 1) {
            while (it.hasNext()) {
                it.next().itemSelected(e);
            }
        } else if (e.getType() == 2) {
            while (it.hasNext()) {
                it.next().itemDeselected(e);
            }
        } else {
            throw new IllegalStateException("Unknown selection event type " + e.getType());
        }
    }

    public int pointToColumnIndex(Point p) throws ArchitectException {
        return ((TablePaneUI)this.getUI()).pointToColumnIndex(p);
    }

    public boolean insertObjects(List<SQLObject> items, int insertionPoint) throws ArchitectException {
        boolean newColumnsInPk = false;
        if (insertionPoint == -3) {
            insertionPoint = this.getModel().getPkSize();
            newColumnsInPk = true;
        } else if (insertionPoint == -4) {
            insertionPoint = this.getModel().getPkSize();
            newColumnsInPk = false;
        } else if (insertionPoint == -1) {
            insertionPoint = 0;
            newColumnsInPk = true;
        } else if (insertionPoint < 0) {
            insertionPoint = this.getModel().getColumns().size();
            newColumnsInPk = false;
        } else if (insertionPoint < this.getModel().getPkSize()) {
            newColumnsInPk = true;
        }
        int i = items.size() - 1;
        while (i >= 0) {
            SQLObject someData = items.get(i);
            logger.debug((Object)("insertObjects: got item of type " + someData.getClass().getName()));
            if (someData instanceof SQLTable) {
                SQLTable table = (SQLTable)someData;
                if (table.getParentDatabase() == this.getModel().getParentDatabase()) {
                    return false;
                }
                this.getModel().inherit(insertionPoint, table);
            } else if (someData instanceof SQLColumn) {
                SQLColumn col = (SQLColumn)someData;
                if (col.getParentTable() == this.getModel()) {
                    int oldIndex = col.getParentTable().getColumns().indexOf(col);
                    if (insertionPoint > oldIndex) {
                        --insertionPoint;
                    }
                    this.getModel().changeColumnIndex(oldIndex, insertionPoint, newColumnsInPk);
                } else if (col.getParentTable().getParentDatabase() == this.getModel().getParentDatabase()) {
                    col.getParentTable().removeColumn(col);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Moving column '" + col.getName() + "' to table '" + this.getModel().getName() + "' at position " + insertionPoint));
                    }
                    try {
                        this.getModel().setMagicEnabled(false);
                        this.getModel().addColumn(insertionPoint, col);
                        if (newColumnsInPk) {
                            col.setPrimaryKeySeq(new Integer(insertionPoint));
                        }
                        col.setPrimaryKeySeq(null);
                    }
                    finally {
                        this.getModel().setMagicEnabled(true);
                    }
                } else {
                    this.getModel().inherit(insertionPoint, col, newColumnsInPk);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Inherited " + col.getName() + " to table"));
                    }
                }
            } else {
                return false;
            }
            --i;
        }
        return true;
    }

    void deSelectEverythingElse(MouseEvent evt) {
        for (TablePane t3 : this.getPlayPen().getSelectedTables()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("(" + this.getModel().getName() + ") zoomed selected table point: " + this.getLocationOnScreen()));
                logger.debug((Object)("(" + t3.getModel().getName() + ") zoomed iterator table point: " + t3.getLocationOnScreen()));
            }
            if (this.getLocationOnScreen().equals(t3.getLocationOnScreen())) continue;
            logger.debug((Object)"found matching table!");
            t3.setSelected(false);
            t3.selectNone();
        }
        for (Relationship r : this.getPlayPen().getSelectedRelationShips()) {
            r.setSelected(false);
        }
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess()) {
            logger.debug((Object)"Succesful drop");
        } else {
            logger.debug((Object)"Unsuccesful drop");
        }
        this.draggingColumn = null;
    }

    public void addColumnHighlight(SQLColumn column, Color colour) {
        this.columnHighlight.get(column).add(colour);
        this.repaint();
    }

    public void removeColumnHighlight(SQLColumn column, Color colour) {
        this.columnHighlight.get(column).remove(colour);
        this.repaint();
    }

    public Color getColumnHighlight(int i) throws ArchitectException {
        return this.getColumnHighlight(this.model.getColumn(i));
    }

    public Color getColumnHighlight(SQLColumn column) {
        logger.debug((Object)("Checking column " + column));
        if (this.columnHighlight.get(column).isEmpty()) {
            return this.getForeground();
        }
        float[] rgbsum = new float[3];
        for (Color c : this.columnHighlight.get(column)) {
            float[] comps = c.getRGBColorComponents(new float[3]);
            rgbsum[0] = rgbsum[0] + comps[0];
            rgbsum[1] = rgbsum[1] + comps[1];
            rgbsum[2] = rgbsum[2] + comps[2];
        }
        float sz = this.columnHighlight.get(column).size();
        return new Color(rgbsum[0] / sz, rgbsum[1] / sz, rgbsum[2] / sz);
    }

    public void setFullyQualifiedNameInHeader(boolean fullyQualifiedNameInHeader) {
        this.fullyQualifiedNameInHeader = fullyQualifiedNameInHeader;
    }

    public boolean isFullyQualifiedNameInHeader() {
        return this.fullyQualifiedNameInHeader;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public List<LayoutEdge> getInboundEdges() {
        try {
            List<SQLRelationship> relationships = this.getModel().getImportedKeys();
            ArrayList<LayoutEdge> edges = new ArrayList<LayoutEdge>();
            for (SQLRelationship r : relationships) {
                edges.add(this.getPlayPen().findRelationship(r));
            }
            return edges;
        }
        catch (ArchitectException ex) {
            throw new ArchitectRuntimeException(ex);
        }
    }

    @Override
    public List<LayoutEdge> getOutboundEdges() {
        try {
            List<SQLRelationship> relationships = this.getModel().getExportedKeys();
            ArrayList<LayoutEdge> edges = new ArrayList<LayoutEdge>();
            for (SQLRelationship r : relationships) {
                edges.add(this.getPlayPen().findRelationship(r));
            }
            return edges;
        }
        catch (ArchitectException ex) {
            throw new ArchitectRuntimeException(ex);
        }
    }

    private class ColumnListener
    implements SQLObjectListener {
        private SQLColumn mostRecentSelectedRemoval;

        private ColumnListener() {
        }

        public void dbChildrenInserted(SQLObjectEvent e) {
            if (e.getSource() == TablePane.this.getModel().getColumnsFolder()) {
                int[] ci = e.getChangedIndices();
                if (logger.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    int[] nArray = ci;
                    int n = 0;
                    int n2 = nArray.length;
                    while (n < n2) {
                        int i = nArray[n];
                        sb.append(i).append(' ');
                        ++n;
                    }
                    logger.debug((Object)("Columns inserted. Syncing select/highlight lists. New indices=[" + sb + "]"));
                }
                int i = 0;
                while (i < ci.length) {
                    boolean wasSelectedPreviously;
                    boolean bl = wasSelectedPreviously = e.getChildren()[i] == this.mostRecentSelectedRemoval;
                    if (wasSelectedPreviously) {
                        TablePane.this.selectNone();
                    }
                    TablePane.this.columnSelection.add(ci[i], wasSelectedPreviously);
                    if (TablePane.this.columnHighlight.get((SQLColumn)e.getChildren()[i]) == null) {
                        TablePane.this.columnHighlight.put((SQLColumn)e.getChildren()[i], new ArrayList());
                    }
                    ++i;
                }
            }
            try {
                ArchitectUtils.listenToHierarchy((SQLObjectListener)this, e.getChildren());
            }
            catch (ArchitectException ex) {
                logger.error((Object)"Caught exception while listening to added children", (Throwable)ex);
            }
            TablePane.this.firePropertyChange("model.children", null, null);
        }

        public void dbChildrenRemoved(SQLObjectEvent e) {
            if (e.getSource() == TablePane.this.model.getColumnsFolder()) {
                int[] ci = e.getChangedIndices();
                if (logger.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    int[] nArray = ci;
                    int n = 0;
                    int n2 = nArray.length;
                    while (n < n2) {
                        int i = nArray[n];
                        sb.append(i).append(' ');
                        ++n;
                    }
                    logger.debug((Object)("Columns removed. Syncing select/highlight lists. Removed indices=[" + sb + "]"));
                }
                int i = 0;
                while (i < ci.length) {
                    if (TablePane.this.columnSelection.get(ci[i]).booleanValue()) {
                        this.mostRecentSelectedRemoval = (SQLColumn)e.getChildren()[i];
                    }
                    TablePane.this.columnSelection.remove(ci[i]);
                    ++i;
                }
                if (TablePane.this.columnSelection.size() > 0) {
                    TablePane.this.selectNone();
                    TablePane.this.columnSelection.set(Math.min(ci[0], TablePane.this.columnSelection.size() - 1), Boolean.TRUE);
                }
                try {
                    if (TablePane.this.columnSelection.size() != TablePane.this.model.getColumns().size()) {
                        throw new IllegalStateException("out-of-sync selection list (event source=" + e.getSource() + "): selection=" + TablePane.this.columnSelection + "; children=" + TablePane.this.model.getColumns());
                    }
                }
                catch (ArchitectException ex) {
                    throw new ArchitectRuntimeException(ex);
                }
            }
            TablePane.this.firePropertyChange("model.children", null, null);
        }

        public void dbObjectChanged(SQLObjectEvent e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TablePane got object changed event.  Source=" + e.getSource() + " Property=" + e.getPropertyName() + " oldVal=" + e.getOldValue() + " newVal=" + e.getNewValue()));
            }
            TablePane.this.firePropertyChange("model." + e.getPropertyName(), null, null);
        }

        public void dbStructureChanged(SQLObjectEvent e) {
            logger.debug((Object)("TablePane got db structure change event. source=" + e.getSource()));
            if (e.getSource() == TablePane.this.model.getColumnsFolder()) {
                int numCols = e.getChildren().length;
                TablePane.this.columnSelection = new ArrayList(numCols);
                int i = 0;
                while (i < numCols) {
                    TablePane.this.columnSelection.add(Boolean.FALSE);
                    ++i;
                }
                TablePane.this.columnHighlight = new HashMap<SQLColumn, List<Color>>();
                try {
                    for (SQLColumn child : TablePane.this.model.getColumnsFolder().getChildren()) {
                        TablePane.this.columnHighlight.put(child, new ArrayList());
                    }
                }
                catch (ArchitectException e1) {
                    throw new ArchitectRuntimeException(e1);
                }
                TablePane.this.firePropertyChange("model.children", null, null);
            }
        }
    }

    public static class TablePaneDropListener
    implements DropTargetListener {
        protected TablePane tp;

        public TablePaneDropListener(TablePane tp) {
            this.tp = tp;
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DragEnter event on " + this.tp.getName()));
            }
        }

        public void dragExit(DropTargetEvent dte) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DragExit event on " + this.tp.getName()));
            }
            this.tp.setInsertionPoint(-2);
        }

        public void dragOver(DropTargetDragEvent dtde) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DragOver event on " + this.tp.getName() + ": " + dtde));
                logger.debug((Object)("Drop Action = " + dtde.getDropAction()));
                logger.debug((Object)("Source Actions = " + dtde.getSourceActions()));
            }
            dtde.acceptDrag(3 & dtde.getDropAction());
            try {
                Point loc = this.tp.getPlayPen().unzoomPoint(new Point(dtde.getLocation()));
                loc.x -= this.tp.getX();
                loc.y -= this.tp.getY();
                int idx = this.tp.pointToColumnIndex(loc);
                this.tp.setInsertionPoint(idx);
            }
            catch (ArchitectException e) {
                logger.error((Object)"Got exception translating drag location", (Throwable)e);
            }
        }

        public void drop(DropTargetDropEvent dtde) {
            PlayPen pp = this.tp.getPlayPen();
            Point loc = pp.unzoomPoint(new Point(dtde.getLocation()));
            loc.x -= this.tp.getX();
            loc.y -= this.tp.getY();
            logger.debug((Object)("Drop target drop event on " + this.tp.getName() + ": " + dtde));
            Transferable t = dtde.getTransferable();
            DataFlavor importFlavor = this.bestImportFlavor(pp, t.getTransferDataFlavors());
            if (importFlavor == null) {
                dtde.rejectDrop();
                this.tp.setInsertionPoint(-2);
            } else {
                try {
                    try {
                        DBTree dbtree = ArchitectFrame.getMainInstance().dbTree;
                        int insertionPoint = this.tp.pointToColumnIndex(loc);
                        ArrayList paths = (ArrayList)t.getTransferData(importFlavor);
                        logger.debug((Object)("Importing items from tree: " + paths));
                        ArchitectFrame.getMainInstance().playpen.startCompoundEdit("Drag and Drop");
                        ArrayList<SQLObject> droppedItems = new ArrayList<SQLObject>();
                        for (int[] path : paths) {
                            droppedItems.add(dbtree.getNodeForDnDPath(path));
                        }
                        boolean success = false;
                        try {
                            success = this.tp.insertObjects(droppedItems, insertionPoint);
                        }
                        catch (LockedColumnException ex) {
                            JOptionPane.showConfirmDialog(pp, "Could not delete the column " + ex.getCol().getName() + " because it is part of\n" + "the relationship \"" + ex.getLockingRelationship() + "\".\n\n", "Column is Locked", -1);
                            success = false;
                        }
                        if (success) {
                            dtde.acceptDrop(1);
                        } else {
                            dtde.rejectDrop();
                        }
                        dtde.dropComplete(success);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"Error processing drop operation", (Throwable)ex);
                        dtde.rejectDrop();
                        dtde.dropComplete(false);
                        ASUtils.showExceptionDialog("Error processing drop operation", ex);
                    }
                }
                finally {
                    this.tp.setInsertionPoint(-2);
                    this.tp.getModel().normalizePrimaryKey();
                    ArchitectFrame.getMainInstance().playpen.endCompoundEdit("End drag and drop");
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public DataFlavor bestImportFlavor(JComponent c, DataFlavor[] flavors) {
            logger.debug((Object)("can I import " + Arrays.asList(flavors)));
            int i = 0;
            while (i < flavors.length) {
                String cls = flavors[i].getDefaultRepresentationClassAsString();
                logger.debug((Object)("representation class = " + cls));
                logger.debug((Object)("mime type = " + flavors[i].getMimeType()));
                logger.debug((Object)("type = " + flavors[i].getPrimaryType()));
                logger.debug((Object)("subtype = " + flavors[i].getSubType()));
                logger.debug((Object)("class = " + flavors[i].getParameter("class")));
                logger.debug((Object)("isSerializedObject = " + flavors[i].isFlavorSerializedObjectType()));
                logger.debug((Object)("isInputStream = " + flavors[i].isRepresentationClassInputStream()));
                logger.debug((Object)("isRemoteObject = " + flavors[i].isFlavorRemoteObjectType()));
                logger.debug((Object)("isLocalObject = " + flavors[i].getMimeType().equals("application/x-java-jvm-local-objectref")));
                if (flavors[i].equals(DnDTreePathTransferable.TREEPATH_ARRAYLIST_FLAVOR)) {
                    logger.debug((Object)"YES");
                    return flavors[i];
                }
                ++i;
            }
            logger.debug((Object)"NO!");
            return null;
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            return this.bestImportFlavor(c, flavors) != null;
        }
    }
}

