/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;

public class SaveDocument
extends JFileChooser {
    public SaveDocument(Component owner, AbstractDocument doc, ASUtils.FileExtensionFilter fef) {
        this.setFileFilter(fef);
        int returnVal = this.showSaveDialog(owner);
        while (returnVal != 1) {
            if (returnVal != 0) continue;
            File file = this.getSelectedFile();
            String fileName = file.getPath();
            String fileExt = ASUtils.FileExtensionFilter.getExtension(file);
            if (fileExt.length() == 0) {
                file = new File(String.valueOf(fileName) + "." + fef.getFilterExtension(new Integer(0)));
            }
            if (file.exists() && JOptionPane.showOptionDialog(owner, "Are your sure you want to overwrite this file?", "Confirm Overwrite", 0, 3, null, null, null) == 1) {
                returnVal = this.showSaveDialog(owner);
                continue;
            }
            this.writeDocument(doc, file);
            break;
        }
    }

    protected void writeDocument(AbstractDocument doc, File file) {
        try {
            String s;
            StringReader sr = new StringReader(doc.getText(0, doc.getLength()));
            BufferedReader br = new BufferedReader(sr);
            PrintWriter out = new PrintWriter(file);
            while ((s = br.readLine()) != null) {
                out.println(s);
            }
            out.close();
        }
        catch (IOException e1) {
            ASUtils.showExceptionDialog("Save file Error!", e1);
        }
        catch (BadLocationException e1) {
            ASUtils.showExceptionDialog("Open file Error!", e1);
        }
    }
}

