/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.SaveDocument;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class CompareDMFrame
extends JDialog {
    private static Logger logger = Logger.getLogger(CompareDMFrame.class);
    private JTextPane leftOutputArea;
    private JTextPane rightOutputArea;
    private AbstractDocument sourceOutputText;
    private AbstractDocument targetOutputText;
    private String title;
    private String whatTheHeckIsGoingOn;
    private JComponent panel;

    public CompareDMFrame(AbstractDocument sourceOutputText, AbstractDocument targetOutputText, String leftTitle, String rightTitle) {
        super(ArchitectFrame.getMainInstance());
        this.setTitle("Data Model comparison");
        this.sourceOutputText = sourceOutputText;
        this.targetOutputText = targetOutputText;
        this.title = "Comparing " + leftTitle + " to " + rightTitle + ".";
        this.whatTheHeckIsGoingOn = "The following changes need to be done to make one into the other:";
        this.panel = this.mainFrame();
        this.getContentPane().add(this.panel);
        SimpleAttributeSet att = new SimpleAttributeSet();
        StyleConstants.setForeground(att, Color.black);
        StyleConstants.setFontSize(att, this.leftOutputArea.getFont().getSize() * 2);
        try {
            sourceOutputText.insertString(0, String.valueOf(leftTitle) + "\n\n", att);
            targetOutputText.insertString(0, String.valueOf(rightTitle) + "\n\n", att);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public JComponent mainFrame() {
        FormLayout layout = new FormLayout("4dlu,fill:min(150dlu;default):grow, 6dlu, fill:min(150dlu;default):grow, 4dlu", " min(300dlu;default), 6dlu, min(300dlu;default), 6dlu,  min(300dlu;default), 3dlu, fill:min(300dlu;default):grow, 3dlu, 20dlu,6dlu,20dlu");
        CellConstraints cc = new CellConstraints();
        JLabel titleLabel = new JLabel(this.title);
        Font oldFont = titleLabel.getFont();
        Font titleFont = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() * 2);
        titleLabel.setFont(titleFont);
        JLabel subTitleLabel = new JLabel(this.whatTheHeckIsGoingOn);
        this.leftOutputArea = new JTextPane();
        this.leftOutputArea.setMargin(new Insets(6, 10, 4, 6));
        this.leftOutputArea.setDocument(this.sourceOutputText);
        this.leftOutputArea.setEditable(false);
        JPanel comparePanel = new JPanel(new GridLayout(1, 2));
        JScrollPane sp = new JScrollPane(comparePanel);
        comparePanel.add(this.leftOutputArea);
        sourceCopyAction sourceCopy = new sourceCopyAction(this.sourceOutputText);
        AbstractAction sourceSave = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                new SaveDocument(CompareDMFrame.this, CompareDMFrame.this.sourceOutputText, (ASUtils.FileExtensionFilter)ASUtils.TEXT_FILE_FILTER);
            }
        };
        CloseAction close = new CloseAction();
        close.setDialog(this);
        ButtonBarBuilder sourcebbBuilder = new ButtonBarBuilder();
        JButton copySource = new JButton(sourceCopy);
        copySource.setText("Copy");
        sourcebbBuilder.addGridded((JComponent)copySource);
        sourcebbBuilder.addRelatedGap();
        sourcebbBuilder.addGlue();
        JButton sourceSaveButton = new JButton(sourceSave);
        sourceSaveButton.setText("Save");
        sourcebbBuilder.addGridded((JComponent)sourceSaveButton);
        sourcebbBuilder.addRelatedGap();
        sourcebbBuilder.addGlue();
        ButtonBarBuilder closeBar = new ButtonBarBuilder();
        JButton closeButton = new JButton(close);
        closeButton.setText("Close");
        closeBar.addGridded((JComponent)closeButton);
        layout.setColumnGroups((int[][])new int[][]{{2, 4}});
        Object p = logger.isDebugEnabled() ? new FormDebugPanel(layout) : new JPanel((LayoutManager)layout);
        PanelBuilder pb = new PanelBuilder(layout, (JPanel)p);
        pb.setDefaultDialogBorder();
        this.rightOutputArea = new JTextPane();
        this.rightOutputArea.setMargin(new Insets(6, 10, 4, 6));
        this.rightOutputArea.setDocument(this.targetOutputText);
        this.rightOutputArea.setEditable(false);
        comparePanel.add(this.rightOutputArea);
        targetCopyAction targetCopy = new targetCopyAction(this.targetOutputText);
        ButtonBarBuilder targetbbBuilder = new ButtonBarBuilder();
        JButton copyTarget = new JButton(targetCopy);
        copyTarget.setText("Copy");
        targetbbBuilder.addGridded((JComponent)copyTarget);
        targetbbBuilder.addRelatedGap();
        targetbbBuilder.addGlue();
        AbstractAction targetSaveAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                new SaveDocument(CompareDMFrame.this, CompareDMFrame.this.targetOutputText, (ASUtils.FileExtensionFilter)ASUtils.TEXT_FILE_FILTER);
            }
        };
        JButton targetSave = new JButton(targetSaveAction);
        targetSave.setText("Save");
        targetbbBuilder.addGridded((JComponent)targetSave);
        targetbbBuilder.addRelatedGap();
        targetbbBuilder.addGlue();
        pb.add((Component)titleLabel, cc.xyw(2, 1, 3, "c,c"));
        pb.add((Component)subTitleLabel, cc.xyw(2, 3, 3, "c,c"));
        pb.add((Component)new JLabel("Source"), cc.xy(2, 5));
        pb.add((Component)new JLabel("Target"), cc.xy(4, 5));
        pb.add((Component)sp, cc.xyw(2, 7, 3));
        pb.add((Component)sourcebbBuilder.getPanel(), cc.xy(2, 9, "l,c"));
        pb.add((Component)targetbbBuilder.getPanel(), cc.xy(4, 9, "r,c"));
        pb.add((Component)closeBar.getPanel(), cc.xy(4, 11, "r,c"));
        return pb.getPanel();
    }

    public JPanel getPanel() {
        return (JPanel)this.panel;
    }

    public void setPanel(JPanel panel) {
        this.panel = panel;
    }

    public void pack() {
        super.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        logger.debug((Object)("Before change: Window width =" + this.getWidth() + " screen width =" + d.width));
        if (this.getWidth() > d.width - this.getX()) {
            this.setSize(d.width - this.getX(), this.getHeight());
        }
        logger.debug((Object)("Before change: Window height =" + this.getHeight() + " screen height =" + d.height));
        if (this.getHeight() > d.height - this.getY()) {
            this.setSize(this.getWidth(), d.height - this.getY());
        }
    }

    public class sourceCopyAction
    extends AbstractAction {
        AbstractDocument doc;

        public sourceCopyAction(AbstractDocument doc) {
            this.doc = doc;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                StringSelection selection = new StringSelection(this.doc.getText(0, this.doc.getLength()));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
            }
            catch (BadLocationException e1) {
                logger.debug((Object)("Unable to get the text for copying" + e1));
            }
        }
    }

    public class targetCopyAction
    extends AbstractAction {
        AbstractDocument doc;

        public targetCopyAction(AbstractDocument doc) {
            this.doc = doc;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                StringSelection selection = new StringSelection(this.doc.getText(0, this.doc.getLength()));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
            }
            catch (BadLocationException e1) {
                logger.debug((Object)("Unable to get the text for copying" + e1));
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        JDialog localDialog;

        public void setDialog(JDialog dialog) {
            this.localDialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            this.localDialog.setVisible(false);
        }
    }
}

