/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PostgresDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 1.17 $";
    private static final Logger logger = Logger.getLogger(PostgresDDLGenerator.class);
    private static HashSet reservedWords = new HashSet();

    static {
        reservedWords.add("ABORT");
        reservedWords.add("ABSOLUTE");
        reservedWords.add("ACTION");
        reservedWords.add("ADD");
        reservedWords.add("ALL");
        reservedWords.add("ALLOCATE");
        reservedWords.add("ALTER");
        reservedWords.add("ANALYZE");
        reservedWords.add("AND");
        reservedWords.add("ANY");
        reservedWords.add("ARE");
        reservedWords.add("AS");
        reservedWords.add("ASC");
        reservedWords.add("ASSERTION");
        reservedWords.add("AT");
        reservedWords.add("AUTHORIZATION");
        reservedWords.add("AVG");
        reservedWords.add("BEGIN");
        reservedWords.add("BETWEEN");
        reservedWords.add("BINARY");
        reservedWords.add("BIT");
        reservedWords.add("BIT_LENGTH");
        reservedWords.add("BOOLEAN");
        reservedWords.add("BOTH");
        reservedWords.add("BY");
        reservedWords.add("CASCADE");
        reservedWords.add("CASCADED");
        reservedWords.add("CASE");
        reservedWords.add("CAST");
        reservedWords.add("CATALOG");
        reservedWords.add("CHAR");
        reservedWords.add("CHARACTER");
        reservedWords.add("CHARACTER_LENGTH");
        reservedWords.add("CHAR_LENGTH");
        reservedWords.add("CHECK");
        reservedWords.add("CLOSE");
        reservedWords.add("CLUSTER");
        reservedWords.add("COALESCE");
        reservedWords.add("COLLATE");
        reservedWords.add("COLLATION");
        reservedWords.add("COLUMN");
        reservedWords.add("COMMIT");
        reservedWords.add("CONNECT");
        reservedWords.add("CONNECTION");
        reservedWords.add("CONSTRAINT");
        reservedWords.add("CONSTRAINTS");
        reservedWords.add("CONTINUE");
        reservedWords.add("CONVERT");
        reservedWords.add("COPY");
        reservedWords.add("CORRESPONDING");
        reservedWords.add("COUNT");
        reservedWords.add("CREATE");
        reservedWords.add("CROSS");
        reservedWords.add("CURRENT");
        reservedWords.add("CURRENT_DATE");
        reservedWords.add("CURRENT_SESSION");
        reservedWords.add("CURRENT_TIME");
        reservedWords.add("CURRENT_TIMESTAMP");
        reservedWords.add("CURRENT_USER");
        reservedWords.add("CURSOR");
        reservedWords.add("DATE");
        reservedWords.add("DATETIME");
        reservedWords.add("DAY");
        reservedWords.add("DEALLOCATE");
        reservedWords.add("DEC");
        reservedWords.add("DECIMAL");
        reservedWords.add("DECLARE");
        reservedWords.add("DEFAULT");
        reservedWords.add("DEFERRABLE");
        reservedWords.add("DEFERRED");
        reservedWords.add("DELETE");
        reservedWords.add("DESC");
        reservedWords.add("DESC");
        reservedWords.add("DESCRIBE");
        reservedWords.add("DESCRIPTOR");
        reservedWords.add("DIAGNOSTICS");
        reservedWords.add("DISCONNECT");
        reservedWords.add("DISTINCT");
        reservedWords.add("DO");
        reservedWords.add("DOMAIN");
        reservedWords.add("DOUBLE");
        reservedWords.add("DROP");
        reservedWords.add("ELSE");
        reservedWords.add("END");
        reservedWords.add("ESCAPE");
        reservedWords.add("EXCEPT");
        reservedWords.add("EXCEPTION");
        reservedWords.add("EXEC");
        reservedWords.add("EXECUTE");
        reservedWords.add("EXISTS");
        reservedWords.add("EXPLAIN");
        reservedWords.add("EXTEND");
        reservedWords.add("EXTERNAL");
        reservedWords.add("EXTRACT");
        reservedWords.add("EXTRACT");
        reservedWords.add("FALSE");
        reservedWords.add("FETCH");
        reservedWords.add("FIRST");
        reservedWords.add("FLOAT");
        reservedWords.add("FLOAT");
        reservedWords.add("FOR");
        reservedWords.add("FOR");
        reservedWords.add("FOREIGN");
        reservedWords.add("FOUND");
        reservedWords.add("FROM");
        reservedWords.add("FULL");
        reservedWords.add("FULL");
        reservedWords.add("GET");
        reservedWords.add("GLOBAL");
        reservedWords.add("GO");
        reservedWords.add("GOTO");
        reservedWords.add("GRANT");
        reservedWords.add("GROUP");
        reservedWords.add("HAVING");
        reservedWords.add("HOUR");
        reservedWords.add("IDENTITY");
        reservedWords.add("IMMEDIATE");
        reservedWords.add("IN");
        reservedWords.add("IN");
        reservedWords.add("INDICATOR");
        reservedWords.add("INITIALLY");
        reservedWords.add("INNER");
        reservedWords.add("INPUT");
        reservedWords.add("INSENSITIVE");
        reservedWords.add("INSERT");
        reservedWords.add("INT");
        reservedWords.add("INTEGER");
        reservedWords.add("INTERSECT");
        reservedWords.add("INTERVAL");
        reservedWords.add("INTO");
        reservedWords.add("IS");
        reservedWords.add("IS");
        reservedWords.add("ISOLATION");
        reservedWords.add("JOIN");
        reservedWords.add("JOIN");
        reservedWords.add("KEY");
        reservedWords.add("LANGUAGE");
        reservedWords.add("LAST");
        reservedWords.add("LEADING");
        reservedWords.add("LEFT");
        reservedWords.add("LEFT");
        reservedWords.add("LEVEL");
        reservedWords.add("LIKE");
        reservedWords.add("LIKE");
        reservedWords.add("LISTEN");
        reservedWords.add("LOAD");
        reservedWords.add("LOCAL");
        reservedWords.add("LOCAL");
        reservedWords.add("LOCK");
        reservedWords.add("LOWER");
        reservedWords.add("MATCH");
        reservedWords.add("MAX");
        reservedWords.add("MIN");
        reservedWords.add("MINUTE");
        reservedWords.add("MODULE");
        reservedWords.add("MONTH");
        reservedWords.add("MOVE");
        reservedWords.add("NAMES");
        reservedWords.add("NATIONAL");
        reservedWords.add("NATURAL");
        reservedWords.add("NATURAL");
        reservedWords.add("NCHAR");
        reservedWords.add("NCHAR");
        reservedWords.add("NEW");
        reservedWords.add("NEXT");
        reservedWords.add("NO");
        reservedWords.add("NONE");
        reservedWords.add("NOT");
        reservedWords.add("NOTIFY");
        reservedWords.add("NULL");
        reservedWords.add("NULL");
        reservedWords.add("NULLIF");
        reservedWords.add("NUMERIC");
        reservedWords.add("OCTET_LENGTH");
        reservedWords.add("OF");
        reservedWords.add("OFFSET");
        reservedWords.add("ON");
        reservedWords.add("ON");
        reservedWords.add("ONLY");
        reservedWords.add("OPEN");
        reservedWords.add("OPTION");
        reservedWords.add("OR");
        reservedWords.add("OR");
        reservedWords.add("ORDER");
        reservedWords.add("OUTER");
        reservedWords.add("OUTPUT");
        reservedWords.add("OVERLAPS");
        reservedWords.add("OVERLAPS");
        reservedWords.add("PARTIAL");
        reservedWords.add("PENDANT");
        reservedWords.add("POSITION");
        reservedWords.add("PRECISION");
        reservedWords.add("PREPARE");
        reservedWords.add("PRESERVE");
        reservedWords.add("PRIMARY");
        reservedWords.add("PRIOR");
        reservedWords.add("PRIVILEGES");
        reservedWords.add("PRIVILEGES");
        reservedWords.add("PROCEDURE");
        reservedWords.add("PUBLIC");
        reservedWords.add("PUBLIC");
        reservedWords.add("READ");
        reservedWords.add("REAL");
        reservedWords.add("REFERENCES");
        reservedWords.add("RELATIVE");
        reservedWords.add("RESET");
        reservedWords.add("RESTRICT");
        reservedWords.add("REVOKE");
        reservedWords.add("RIGHT");
        reservedWords.add("ROLLBACK");
        reservedWords.add("ROWS");
        reservedWords.add("SCHEMA");
        reservedWords.add("SCROLL");
        reservedWords.add("SECOND");
        reservedWords.add("SECTION");
        reservedWords.add("SELECT");
        reservedWords.add("SESSION");
        reservedWords.add("SESSION_USER");
        reservedWords.add("SET");
        reservedWords.add("SETOF");
        reservedWords.add("SHOW");
        reservedWords.add("SIZE");
        reservedWords.add("SMALLINT");
        reservedWords.add("SOME");
        reservedWords.add("SQL");
        reservedWords.add("SQLCODE");
        reservedWords.add("SQLERROR");
        reservedWords.add("SQLSTATE");
        reservedWords.add("SUBSTRING");
        reservedWords.add("SUM");
        reservedWords.add("SYSTEM_USER");
        reservedWords.add("TABLE");
        reservedWords.add("TEMPORARY");
        reservedWords.add("THEN");
        reservedWords.add("TIME");
        reservedWords.add("TIMESPAN");
        reservedWords.add("TIMESTAMP");
        reservedWords.add("TIMEZONE_HOUR");
        reservedWords.add("TIMEZONE_MINUTE");
        reservedWords.add("TO");
        reservedWords.add("TO");
        reservedWords.add("TRAILING");
        reservedWords.add("TRANSACTION");
        reservedWords.add("TRANSLATE");
        reservedWords.add("TRANSLATION");
        reservedWords.add("TRIGGER");
        reservedWords.add("TRIM");
        reservedWords.add("TRUE");
        reservedWords.add("UNION");
        reservedWords.add("UNION");
        reservedWords.add("UNIQUE");
        reservedWords.add("UNKNOWN");
        reservedWords.add("UNLISTEN");
        reservedWords.add("UNTIL");
        reservedWords.add("UPDATE");
        reservedWords.add("UPPER");
        reservedWords.add("USAGE");
        reservedWords.add("USER");
        reservedWords.add("USING");
        reservedWords.add("VACUUM");
        reservedWords.add("VALUE");
        reservedWords.add("VALUES");
        reservedWords.add("VARCHAR");
        reservedWords.add("VARYING");
        reservedWords.add("VERBOSE");
        reservedWords.add("VIEW");
        reservedWords.add("WHEN");
        reservedWords.add("WHENEVER");
        reservedWords.add("WHERE");
        reservedWords.add("WITH");
        reservedWords.add("WORK");
        reservedWords.add("WRITE");
        reservedWords.add("YEAR");
        reservedWords.add("ZONE");
    }

    public boolean isReservedWord(String word) {
        return reservedWords.contains(word.toUpperCase());
    }

    public void writeHeader() {
        this.println("-- Created by SQLPower PostgreSQL DDL Generator $Revision: 1.17 $ --");
    }

    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(new Integer(-5), new GenericTypeDescriptor("NUMERIC", -5, 1000L, null, null, 1, true, false));
        this.typeMap.put(new Integer(-2), new GenericTypeDescriptor("BYTEA", -2, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(new Integer(-7), new GenericTypeDescriptor("BIT", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(new Integer(2004), new GenericTypeDescriptor("BYTEA", 2004, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(new Integer(1), new GenericTypeDescriptor("CHAR", 1, 4000000000L, "'", "'", 1, true, false));
        this.typeMap.put(new Integer(2005), new GenericTypeDescriptor("TEXT", 2005, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(new Integer(91), new GenericTypeDescriptor("DATE", 91, 0L, "'", "'", 1, false, false));
        this.typeMap.put(new Integer(3), new GenericTypeDescriptor("NUMERIC", 3, 1000L, null, null, 1, true, true));
        this.typeMap.put(new Integer(8), new GenericTypeDescriptor("DOUBLE PRECISION", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(new Integer(6), new GenericTypeDescriptor("REAL", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(new Integer(4), new GenericTypeDescriptor("INTEGER", 4, 38L, null, null, 1, false, false));
        this.typeMap.put(new Integer(-4), new GenericTypeDescriptor("BYTEA", -4, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(new Integer(-1), new GenericTypeDescriptor("TEXT", -1, 4000000000L, "'", "'", 1, false, false));
        this.typeMap.put(new Integer(2), new GenericTypeDescriptor("NUMERIC", 2, 1000L, null, null, 1, true, true));
        this.typeMap.put(new Integer(7), new GenericTypeDescriptor("REAL", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(new Integer(5), new GenericTypeDescriptor("SMALLINT", 5, 16L, null, null, 1, false, false));
        this.typeMap.put(new Integer(92), new GenericTypeDescriptor("TIME", 92, 0L, "'", "'", 1, false, false));
        this.typeMap.put(new Integer(93), new GenericTypeDescriptor("TIMESTAMP", 93, 0L, "'", "'", 1, false, false));
        this.typeMap.put(new Integer(-6), new GenericTypeDescriptor("SMALLINT", -6, 16L, null, null, 1, false, false));
        this.typeMap.put(new Integer(-3), new GenericTypeDescriptor("BYTEA", -3, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(new Integer(12), new GenericTypeDescriptor("VARCHAR", 12, 4000000000L, "'", "'", 1, true, false));
    }

    protected void createProfileFunctionMap() {
        this.profileFunctionMap = new HashMap();
        this.profileFunctionMap.put("varchar", new ProfileFunctionDescriptor("varchar", 12, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("char", new ProfileFunctionDescriptor("char", 1, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("name", new ProfileFunctionDescriptor("name", 1, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("bpchar", new ProfileFunctionDescriptor("bpchar", 1, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("date", new ProfileFunctionDescriptor("date", 91, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("time", new ProfileFunctionDescriptor("time", 92, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("timestamp", new ProfileFunctionDescriptor("timestamp", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("timestamptz", new ProfileFunctionDescriptor("timestamptz", 93, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("timetz", new ProfileFunctionDescriptor("timetz", 92, true, true, true, false, true, true, true, true));
        this.profileFunctionMap.put("float4", new ProfileFunctionDescriptor("float", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("float8", new ProfileFunctionDescriptor("float", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("int2", new ProfileFunctionDescriptor("int", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("int4", new ProfileFunctionDescriptor("int", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("int8", new ProfileFunctionDescriptor("int", 4, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("float4", new ProfileFunctionDescriptor("float", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("float4", new ProfileFunctionDescriptor("float", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("numeric", new ProfileFunctionDescriptor("numeric", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("interval", new ProfileFunctionDescriptor("interval", 6, true, true, true, true, true, true, true, true));
        this.profileFunctionMap.put("bool", new ProfileFunctionDescriptor("bool", 16, true, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("bit", new ProfileFunctionDescriptor("bit", -7, true, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("bytea", new ProfileFunctionDescriptor("bytea", 2004, false, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("text", new ProfileFunctionDescriptor("text", 2004, false, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("oid", new ProfileFunctionDescriptor("oid", 2004, false, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("xid", new ProfileFunctionDescriptor("xid", 2004, false, false, false, false, false, false, false, true));
        this.profileFunctionMap.put("cid", new ProfileFunctionDescriptor("cid", 2004, false, false, false, false, false, false, false, true));
        HashMap<String, ProfileFunctionDescriptor> profileFunctionMap2 = new HashMap<String, ProfileFunctionDescriptor>();
        for (Map.Entry entry : this.profileFunctionMap.entrySet()) {
            String key = (String)entry.getKey();
            ProfileFunctionDescriptor pfd = (ProfileFunctionDescriptor)entry.getValue();
            profileFunctionMap2.put("_" + key, pfd);
        }
        this.profileFunctionMap.putAll(profileFunctionMap2);
    }

    private String toIdentifier(String logicalName, String physicalName) {
        if (logicalName == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getting physical name for: " + logicalName));
        }
        String ident = logicalName.replace(' ', '_').toLowerCase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after replace of spaces: " + ident));
        }
        ident = ident.replaceAll("[^a-zA-Z0-9_$]", "_");
        if (physicalName == null) {
            if (ident.length() <= 63) {
                return ident;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("truncating identifier: " + ident));
            }
            String base = ident.substring(0, 60);
            int tiebreaker = (ident.hashCode() % 1000 + 1000) % 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new identifier: " + base + tiebreaker));
            }
            return String.valueOf(base) + tiebreaker;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("physical identifier is not unique, regenerating: " + physicalName));
        }
        String base = ident;
        if (ident.length() > 63) {
            base = ident.substring(0, 60);
        }
        int tiebreaker = ((String.valueOf(ident) + physicalName).hashCode() % 1000 + 1000) % 1000;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("regenerated identifier is: " + base + tiebreaker));
        }
        return String.valueOf(base) + tiebreaker;
    }

    public String toIdentifier(String name) {
        return this.toIdentifier(name, null);
    }

    public String makeDropForeignKeySQL(String fkTable, String fkName) {
        return "\n ALTER TABLE ONLY " + this.toQualifiedName(fkTable) + " DROP CONSTRAINT " + fkName;
    }

    public void modifyColumn(SQLColumn c) {
        HashMap colNameMap = new HashMap();
        SQLTable t = c.getParentTable();
        this.print("\n ALTER TABLE ONLY ");
        this.print(this.toQualifiedName(t));
        this.print(" ALTER COLUMN ");
        String columnPhysName = this.createPhysicalName(colNameMap, c);
        this.print(columnPhysName);
        this.print(" TYPE ");
        this.print(this.columnType(c));
        this.print(", ALTER COLUMN ");
        this.print(columnPhysName);
        this.print(" ");
        this.print(c.isDefinitelyNullable() ? "DROP" : "SET");
        this.print(" NOT NULL");
        this.endStatement(DDLStatement.StatementType.MODIFY, c);
    }

    public String getCatalogTerm() {
        return null;
    }

    public String getSchemaTerm() {
        return "Schema";
    }

    public String getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return "public";
    }
}

