/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLIndex;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLSchema;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLTable
extends SQLObject {
    private static Logger logger = Logger.getLogger(SQLTable.class);
    protected SQLObject parent;
    protected String remarks = "";
    private String objectType;
    protected String primaryKeyName;
    protected String physicalPrimaryKeyName;
    protected Folder<SQLColumn> columnsFolder;
    protected Folder<SQLRelationship> exportedKeysFolder;
    protected Folder<SQLRelationship> importedKeysFolder;
    private Folder<SQLIndex> indicesFolder;

    public SQLTable(SQLObject parent, String name, String remarks, String objectType, boolean startPopulated) throws ArchitectException {
        logger.debug((Object)("NEW TABLE " + name + "@" + this.hashCode()));
        this.setup(parent, name, remarks, objectType);
        this.initFolders(startPopulated);
    }

    private void setup(SQLObject parent, String name, String remarks, String objectType) {
        this.parent = parent;
        this.setName(name);
        this.remarks = remarks;
        this.objectType = objectType;
        if (this.objectType == null) {
            throw new NullPointerException();
        }
        this.children = new ArrayList();
    }

    public SQLTable(SQLDatabase parent, boolean startPopulated) throws ArchitectException {
        this(parent, "", "", "TABLE", startPopulated);
    }

    public SQLTable() {
        this.setup(null, null, null, "TABLE");
    }

    public void initFolders(boolean populated) throws ArchitectException {
        this.addChild(new Folder(1, populated));
        this.addChild(new Folder(3, populated));
        this.addChild(new Folder(2, populated));
        this.addChild(new Folder(4, populated));
    }

    public static SQLTable getDerivedInstance(SQLTable source, SQLDatabase parent) throws ArchitectException {
        source.populateColumns();
        source.populateRelationships();
        SQLTable t = new SQLTable(parent, true);
        t.setName(source.getName());
        t.remarks = source.remarks;
        t.setPhysicalName(source.getPhysicalName());
        t.primaryKeyName = source.getPrimaryKeyName();
        t.physicalPrimaryKeyName = source.getPhysicalPrimaryKeyName();
        t.inherit(source);
        parent.addChild(t);
        return t;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void populateColumns() throws ArchitectException {
        if (this.columnsFolder.isPopulated()) {
            return;
        }
        if (this.columnsFolder.children.size() > 0) {
            throw new IllegalStateException("Can't populate table because it already contains columns");
        }
        SQLTable.logger.debug((Object)"column folder populate starting");
        try {
            try {
                SQLColumn.addColumnsToTable(this, this.getCatalogName(), this.getSchemaName(), this.getName());
            }
            catch (SQLException e) {
                throw new ArchitectException("Failed to populate columns of table " + this.getName(), e);
            }
        }
        finally {
            this.columnsFolder.populated = true;
            Collections.sort(this.columnsFolder.children, new SQLColumn.SortByPKSeq());
            this.normalizePrimaryKey();
            newSize = this.columnsFolder.children.size();
            changedIndices = new int[newSize];
            i = 0;
            ** while (i < newSize)
        }
lbl-1000:
        // 1 sources

        {
            changedIndices[i] = i;
            ++i;
            continue;
        }
lbl23:
        // 1 sources

        this.columnsFolder.fireDbChildrenInserted(changedIndices, this.columnsFolder.children);
        SQLTable.logger.debug((Object)"column folder populate finished");
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void populateIndices() throws ArchitectException {
        if (this.indicesFolder.isPopulated()) {
            return;
        }
        if (this.indicesFolder.children.size() > 0) {
            throw new IllegalStateException("Can't populate indices folder because it already contains children!");
        }
        SQLTable.logger.debug((Object)"index folder populate starting");
        try {
            try {
                SQLIndex.addIndicesToTable(this, this.getCatalogName(), this.getSchemaName(), this.getName());
            }
            catch (SQLException e) {
                throw new ArchitectException("Failed to populate indices of table " + this.getName(), e);
            }
        }
        finally {
            this.indicesFolder.populated = true;
            newSize = this.indicesFolder.children.size();
            changedIndices = new int[newSize];
            i = 0;
            ** while (i < newSize)
        }
lbl-1000:
        // 1 sources

        {
            changedIndices[i] = i;
            ++i;
            continue;
        }
lbl21:
        // 1 sources

        this.indicesFolder.fireDbChildrenInserted(changedIndices, this.indicesFolder.children);
        SQLTable.logger.debug((Object)"index folder populate finished");
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void populateRelationships() throws ArchitectException {
        block10: {
            if (!this.columnsFolder.isPopulated()) {
                throw new IllegalStateException("Table must be populated before relationships are added");
            }
            if (this.importedKeysFolder.isPopulated()) {
                return;
            }
            SQLTable.logger.debug((Object)"SQLTable: relationship populate starting");
            oldSize = this.importedKeysFolder.children.size();
            this.importedKeysFolder.populated = true;
            try {
                SQLRelationship.addImportedRelationshipsToTable(this);
            }
            finally {
                newSize = this.importedKeysFolder.children.size();
                if (newSize <= oldSize) break block10;
                changedIndices = new int[newSize - oldSize];
                i = 0;
                n = newSize - oldSize;
                ** while (i < n)
            }
lbl-1000:
            // 1 sources

            {
                changedIndices[i] = oldSize + i;
                ++i;
                continue;
            }
lbl21:
            // 1 sources

            try {
                this.importedKeysFolder.fireDbChildrenInserted(changedIndices, this.importedKeysFolder.children.subList(oldSize, newSize));
            }
            catch (IndexOutOfBoundsException ex) {
                SQLTable.logger.error((Object)("Index out of bounds while adding imported keys to table " + this.getName() + " where oldSize=" + oldSize + "; newSize=" + newSize + "; imported keys=" + this.importedKeysFolder.children));
            }
        }
        SQLTable.logger.debug((Object)"SQLTable: relationship populate finished");
    }

    void addImportedKey(SQLRelationship r) throws ArchitectException {
        this.importedKeysFolder.addChild(r);
    }

    public void removeImportedKey(SQLRelationship r) {
        this.importedKeysFolder.removeChild(r);
    }

    void addExportedKey(SQLRelationship r) throws ArchitectException {
        this.exportedKeysFolder.addChild(r);
    }

    public void removeExportedKey(SQLRelationship r) {
        this.exportedKeysFolder.removeChild(r);
    }

    public int getPkSize() {
        int size = 0;
        for (SQLColumn c : this.columnsFolder.children) {
            if (c.getPrimaryKeySeq() == null) break;
            ++size;
        }
        return size;
    }

    public void inherit(SQLTable source) throws ArchitectException {
        this.inherit(this.columnsFolder.children.size(), source);
    }

    public void inherit(int pos, SQLTable source) throws ArchitectException {
        boolean addToPK;
        if (source == this) {
            throw new ArchitectException("Cannot inherit from self");
        }
        int pkSize = this.getPkSize();
        int sourceSize = source.getColumns().size();
        int originalSize = this.getColumns().size();
        if (originalSize == 0 || pos < pkSize) {
            addToPK = true;
            this.normalizePrimaryKey();
            int i = pos;
            while (i < pkSize) {
                ((SQLColumn)this.columnsFolder.children.get((int)i)).primaryKeySeq = new Integer(i + sourceSize);
                ++i;
            }
        } else {
            addToPK = false;
        }
        for (SQLColumn child : source.getColumns()) {
            SQLColumn c = SQLColumn.getDerivedInstance(child, this);
            if (originalSize > 0) {
                c.primaryKeySeq = addToPK ? new Integer(pos) : null;
            }
            this.columnsFolder.addChild(pos, c);
            ++pos;
        }
    }

    public void inherit(int pos, SQLColumn sourceCol, boolean addToPK) throws ArchitectException {
        if (addToPK && pos > 0 && !this.getColumn(pos - 1).isPrimaryKey()) {
            throw new IllegalArgumentException("Can't inherit new PK column below a non-PK column! Insert pos=" + pos + "; addToPk=" + addToPK);
        }
        SQLColumn c = SQLColumn.getDerivedInstance(sourceCol, this);
        c.primaryKeySeq = addToPK ? new Integer(1) : null;
        this.columnsFolder.addChild(pos, c);
    }

    public SQLColumn getColumn(int idx) throws ArchitectException {
        return (SQLColumn)this.columnsFolder.getChild(idx);
    }

    public SQLColumn getColumnByName(String colName) throws ArchitectException {
        return this.getColumnByName(colName, true);
    }

    public SQLColumn getColumnByName(String colName, boolean populate) throws ArchitectException {
        if (populate) {
            this.populateColumns();
        }
        logger.debug((Object)("Looking for column " + colName + " in " + this.children));
        for (SQLColumn col : this.columnsFolder.children) {
            if (!col.getName().equalsIgnoreCase(colName)) continue;
            logger.debug((Object)"FOUND");
            return col;
        }
        logger.debug((Object)"NOT FOUND");
        return null;
    }

    public int getColumnIndex(SQLColumn col) throws ArchitectException {
        logger.debug((Object)("Looking for column index of: " + col));
        Iterator<SQLColumn> it = this.getColumns().iterator();
        int colIdx = 0;
        while (it.hasNext()) {
            if (it.next() == col) {
                return colIdx;
            }
            ++colIdx;
        }
        logger.debug((Object)"NOT FOUND");
        return -1;
    }

    public void addColumn(SQLColumn col) throws ArchitectException {
        this.addColumnImpl(this.columnsFolder.children.size(), col);
    }

    public void addColumn(int pos, SQLColumn col) throws ArchitectException {
        this.addColumnImpl(pos, col);
    }

    private void addColumnImpl(int pos, SQLColumn col) throws ArchitectException {
        if (this.getColumnIndex(col) != -1) {
            col.addReference();
            return;
        }
        if (this.isMagicEnabled()) {
            boolean addToPK = false;
            int pkSize = this.getPkSize();
            if (this.getColumns().size() > 0 && pos < pkSize) {
                addToPK = true;
                this.normalizePrimaryKey();
                int i = pos;
                while (i < pkSize) {
                    this.getColumns().get((int)i).primaryKeySeq = new Integer(i + 1);
                    ++i;
                }
            }
            col.setParent(null);
            if (addToPK) {
                col.nullable = 0;
                col.primaryKeySeq = new Integer(pos);
            } else {
                col.primaryKeySeq = null;
            }
        }
        this.columnsFolder.addChild(pos, col);
    }

    public void addIndex(SQLIndex idx) throws ArchitectException {
        this.getIndicesFolder().addChild(idx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addChildImpl(int index, SQLObject child) throws ArchitectException {
        if (!(child instanceof Folder)) throw new UnsupportedOperationException("You can only add Folders to SQLTable");
        if (this.children.size() == 0) {
            this.columnsFolder = (Folder)child;
        } else if (this.children.size() == 1) {
            this.exportedKeysFolder = (Folder)child;
        } else if (this.children.size() == 2) {
            this.importedKeysFolder = (Folder)child;
        } else {
            if (this.children.size() != 3) throw new UnsupportedOperationException("Can't add a 5th folder to SQLTable");
            this.indicesFolder = (Folder)child;
        }
        super.addChildImpl(index, child);
    }

    public void removeColumn(int index) throws ArchitectException {
        this.removeColumn((SQLColumn)this.columnsFolder.children.get(index));
    }

    public void removeColumn(SQLColumn col) throws ArchitectException {
        if (!this.isMagicEnabled()) {
            this.columnsFolder.removeChild(col);
        } else {
            for (SQLRelationship r : this.getImportedKeys()) {
                r.checkColumnLocked(col);
            }
            this.columnsFolder.removeChild(col);
            this.normalizePrimaryKey();
        }
    }

    public void changeColumnIndex(int oldIdx, int newIdx, boolean putInPK) throws ArchitectException {
        try {
            Integer interimPkSeq;
            this.startCompoundEdit("Changing column index");
            SQLColumn col = (SQLColumn)this.columnsFolder.children.get(oldIdx);
            Integer oldPkSeq = col.primaryKeySeq;
            if (putInPK) {
                interimPkSeq = new Integer(1);
                col.setNullable(0);
            } else {
                interimPkSeq = null;
            }
            col.primaryKeySeq = interimPkSeq;
            col.fireDbObjectChanged("primaryKeySeq", oldPkSeq, interimPkSeq);
            this.columnsFolder.children.remove(oldIdx);
            this.columnsFolder.fireDbChildRemoved(oldIdx, col);
            this.columnsFolder.children.add(newIdx, col);
            this.columnsFolder.fireDbChildInserted(newIdx, col);
            this.normalizePrimaryKey();
        }
        finally {
            this.endCompoundEdit("Changing column index");
        }
    }

    public void normalizePrimaryKey() {
        block8: {
            this.startCompoundEdit("Normalizing Primary Key");
            if (!this.getColumns().isEmpty()) break block8;
            this.endCompoundEdit("Normalizing Primary Key");
            return;
        }
        try {
            try {
                boolean donePk = false;
                int i = 0;
                for (SQLColumn col : this.getColumns()) {
                    if (col.getPrimaryKeySeq() == null) {
                        donePk = true;
                    }
                    Integer oldValue = col.getPrimaryKeySeq();
                    Integer newValue = !donePk ? new Integer(i) : null;
                    col.primaryKeySeq = newValue;
                    col.fireDbObjectChanged("primaryKeySeq", oldValue, newValue);
                    ++i;
                }
            }
            catch (ArchitectException e) {
                logger.warn((Object)("Unexpected ArchitectException in normalizePrimaryKey " + e));
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.endCompoundEdit("Normalizing Primary Key");
        }
    }

    public List<SQLRelationship> keysOfColumn(SQLColumn col) throws ArchitectException {
        LinkedList<SQLRelationship> keys = new LinkedList<SQLRelationship>();
        for (SQLRelationship r : this.getExportedKeys()) {
            if (!r.containsPkColumn(col)) continue;
            keys.add(r);
        }
        for (SQLRelationship r : this.getExportedKeys()) {
            if (!r.containsFkColumn(col)) continue;
            keys.add(r);
        }
        return keys;
    }

    public String toString() {
        return this.getShortDisplayName();
    }

    @Override
    public SQLObject getParent() {
        return this.parent;
    }

    @Override
    protected void setParent(SQLObject newParent) {
        logger.debug((Object)("Setting " + this.getName() + "'s parent to " + newParent));
        if (this.parent == newParent) {
            return;
        }
        SQLObject oldVal = this.parent;
        this.parent = newParent;
        this.fireDbObjectChanged("parent", oldVal, this.parent);
    }

    @Override
    public String getShortDisplayName() {
        SQLSchema schema = this.getSchema();
        if (schema != null) {
            return String.valueOf(schema.getName()) + "." + this.getName() + " (" + this.objectType + ")";
        }
        if (this.objectType != null) {
            return String.valueOf(this.getName()) + " (" + this.objectType + ")";
        }
        return this.getName();
    }

    @Override
    public void populate() throws ArchitectException {
        logger.debug((Object)"SQLTable: populate is a no-op");
    }

    @Override
    public boolean isPopulated() {
        return true;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        return Folder.class;
    }

    public SQLDatabase getParentDatabase() {
        SQLObject o = this.parent;
        while (o != null && !(o instanceof SQLDatabase)) {
            o = o.getParent();
        }
        return (SQLDatabase)o;
    }

    public String getCatalogName() {
        SQLCatalog catalog = this.getCatalog();
        if (catalog == null) {
            return "";
        }
        return catalog.getName();
    }

    public SQLCatalog getCatalog() {
        SQLObject o = this.parent;
        while (o != null && !(o instanceof SQLCatalog)) {
            o = o.getParent();
        }
        return (SQLCatalog)o;
    }

    public String getSchemaName() {
        SQLSchema schema = this.getSchema();
        if (schema == null) {
            return "";
        }
        return schema.getName();
    }

    public SQLSchema getSchema() {
        SQLObject o = this.parent;
        while (o != null && !(o instanceof SQLSchema)) {
            o = o.getParent();
        }
        return (SQLSchema)o;
    }

    public Folder<SQLColumn> getColumnsFolder() {
        return this.columnsFolder;
    }

    public Folder<SQLRelationship> getImportedKeysFolder() {
        return this.importedKeysFolder;
    }

    public Folder<SQLRelationship> getExportedKeysFolder() {
        return this.exportedKeysFolder;
    }

    public Folder<SQLIndex> getIndicesFolder() {
        return this.indicesFolder;
    }

    @Override
    public void setName(String argName) {
        if (!this.isMagicEnabled()) {
            super.setName(argName);
        } else {
            try {
                String oldName = this.getName();
                this.startCompoundEdit("Table Name Change");
                super.setName(argName);
                if (this.primaryKeyName == null || this.primaryKeyName.equals("") || this.primaryKeyName.equals(String.valueOf(oldName) + "_pk")) {
                    this.setPrimaryKeyName(String.valueOf(this.getName()) + "_pk");
                }
            }
            finally {
                this.endCompoundEdit("Ending table name compound edit");
            }
        }
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String argRemarks) {
        String oldRemarks = this.remarks;
        this.remarks = argRemarks;
        this.fireDbObjectChanged("remarks", oldRemarks, argRemarks);
    }

    public synchronized List<SQLColumn> getColumns() throws ArchitectException {
        this.populateColumns();
        return this.columnsFolder.getChildren();
    }

    public List<SQLRelationship> getImportedKeys() throws ArchitectException {
        return this.importedKeysFolder.getChildren();
    }

    public List<SQLRelationship> getExportedKeys() throws ArchitectException {
        return this.exportedKeysFolder.getChildren();
    }

    public SQLRelationship getExportedKeyByName(String name) throws ArchitectException {
        return this.getExportedKeyByName(name, true);
    }

    public SQLRelationship getExportedKeyByName(String name, boolean populate) throws ArchitectException {
        if (populate) {
            this.populateRelationships();
        }
        logger.debug((Object)("Looking for Exported Key [" + name + "] in " + this.exportedKeysFolder.getChildren()));
        for (SQLRelationship r : this.exportedKeysFolder.children) {
            if (!r.getName().equalsIgnoreCase(name)) continue;
            logger.debug((Object)"FOUND");
            return r;
        }
        logger.debug((Object)"NOT FOUND");
        return null;
    }

    public synchronized List<SQLIndex> getUniqueIndex() throws ArchitectException {
        this.populateColumns();
        this.populateIndices();
        ArrayList<SQLIndex> list = new ArrayList<SQLIndex>();
        for (SQLIndex idx : this.getIndicesFolder().children) {
            if (!idx.isUnique()) continue;
            list.add(idx);
        }
        return list;
    }

    public SQLIndex getIndexByName(String name) throws ArchitectException {
        return this.getIndexByName(name, true);
    }

    public SQLIndex getIndexByName(String name, boolean populate) throws ArchitectException {
        if (populate) {
            this.populateColumns();
            this.populateIndices();
        }
        logger.debug((Object)("Looking for Index [" + name + "] in " + this.getIndicesFolder().children));
        for (SQLIndex idx : this.getIndicesFolder().children) {
            if (!idx.getName().equalsIgnoreCase(name)) continue;
            logger.debug((Object)"FOUND");
            return idx;
        }
        logger.debug((Object)"NOT FOUND");
        return null;
    }

    public boolean isColumnsPopulated() {
        return this.columnsFolder.isPopulated();
    }

    public boolean isRelationshipsPopulated() {
        return this.importedKeysFolder.isPopulated() && this.exportedKeysFolder.isPopulated();
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyName;
    }

    public void setPrimaryKeyName(String argPrimaryKeyName) {
        String oldPrimaryKeyName = this.primaryKeyName;
        this.primaryKeyName = argPrimaryKeyName;
        this.fireDbObjectChanged("primaryKeyName", oldPrimaryKeyName, argPrimaryKeyName);
    }

    public String getPhysicalPrimaryKeyName() {
        return this.physicalPrimaryKeyName;
    }

    public void setPhysicalPrimaryKeyName(String argPhysicalPrimaryKeyName) {
        String oldPhysicalPrimaryKeyName = this.physicalPrimaryKeyName;
        this.physicalPrimaryKeyName = argPhysicalPrimaryKeyName;
        this.fireDbObjectChanged("physicalPrimaryKeyName", oldPhysicalPrimaryKeyName, argPhysicalPrimaryKeyName);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String argObjectType) {
        String oldObjectType = this.objectType;
        this.objectType = argObjectType;
        if (this.objectType == null) {
            throw new NullPointerException();
        }
        this.fireDbObjectChanged("objectType", oldObjectType, argObjectType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Folder<T extends SQLObject>
    extends SQLObject {
        protected int type;
        protected String name;
        protected SQLTable parent;
        public static final int COLUMNS = 1;
        public static final int IMPORTED_KEYS = 2;
        public static final int EXPORTED_KEYS = 3;
        public static final int INDICES = 4;

        public Folder(int type, boolean populated) {
            this.populated = populated;
            this.type = type;
            this.children = new ArrayList();
            if (type == 1) {
                this.name = "Columns";
            } else if (type == 2) {
                this.name = "Imported Keys";
            } else if (type == 3) {
                this.name = "Exported Keys";
            } else if (type == 4) {
                this.name = "Indices";
            } else {
                throw new IllegalArgumentException("Unknown folder type: " + type);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String n) {
            String oldName = this.name;
            this.name = n;
            this.fireDbObjectChanged("name", oldName, this.name);
        }

        @Override
        public SQLTable getParent() {
            return this.parent;
        }

        @Override
        protected void setParent(SQLObject newParentTable) {
            this.parent = (SQLTable)newParentTable;
        }

        @Override
        public void populate() throws ArchitectException {
            block24: {
                if (this.populated) {
                    return;
                }
                logger.debug((Object)("SQLTable.Folder[" + this.getName() + "]: populate starting"));
                try {
                    if (this.type == 1) {
                        this.parent.populateColumns();
                        break block24;
                    }
                    if (this.type == 2) {
                        this.parent.populateColumns();
                        this.parent.populateRelationships();
                        break block24;
                    }
                    if (this.type == 3) {
                        ResultSet rs = null;
                        Connection con = null;
                        try {
                            try {
                                con = this.parent.getParentDatabase().getConnection();
                                DatabaseMetaData dbmd = con.getMetaData();
                                rs = dbmd.getExportedKeys(this.parent.getCatalogName(), this.parent.getSchemaName(), this.parent.getName());
                                while (rs.next()) {
                                    if (rs.getInt(9) != 1) continue;
                                    String cat = rs.getString(5);
                                    String sch = rs.getString(6);
                                    String tab = rs.getString(7);
                                    SQLTable fkTable = this.parent.getParentDatabase().getTableByName(cat, sch, tab);
                                    fkTable.populateColumns();
                                    fkTable.populateRelationships();
                                }
                                break block24;
                            }
                            catch (SQLException ex) {
                                throw new ArchitectException("Couldn't locate related tables", ex);
                            }
                        }
                        finally {
                            try {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                            catch (SQLException ex) {
                                logger.warn((Object)"Couldn't close resultset", (Throwable)ex);
                            }
                            try {
                                if (con != null) {
                                    con.close();
                                }
                            }
                            catch (SQLException ex) {
                                logger.warn((Object)"Couldn't close resultset", (Throwable)ex);
                            }
                        }
                    }
                    if (this.type == 4) {
                        this.parent.populateColumns();
                        this.parent.populateIndices();
                        break block24;
                    }
                    throw new IllegalArgumentException("Unknown folder type: " + this.type);
                }
                finally {
                    this.populated = true;
                }
            }
            logger.debug((Object)("SQLTable.Folder[" + this.getName() + "]: populate finished"));
        }

        @Override
        protected void addChildImpl(int index, SQLObject child) throws ArchitectException {
            logger.debug((Object)("\u001b[31mAdding child " + child.getName() + " to folder " + this.getName() + "\u001b[0m"));
            super.addChildImpl(index, child);
        }

        @Override
        public String getShortDisplayName() {
            return this.name;
        }

        @Override
        public boolean allowsChildren() {
            return true;
        }

        public String toString() {
            if (this.parent == null) {
                return String.valueOf(this.name) + " folder (no parent)";
            }
            return String.valueOf(this.name) + " folder of " + this.parent.getName();
        }

        public int getType() {
            return this.type;
        }

        @Override
        public Class<? extends SQLObject> getChildType() {
            return SQLColumn.class;
        }
    }
}

