/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.log4j.Logger;

public class LogWriter {
    private static final Logger logger = Logger.getLogger(LogWriter.class);
    private boolean ready = false;
    private int lineCount = 0;
    PrintWriter pw;

    public LogWriter(String path) throws ArchitectException {
        try {
            this.pw = new PrintWriter(new FileWriter(path, true));
            this.ready = true;
        }
        catch (IOException ex) {
            throw new ArchitectException("could not open ETL log file for writing: " + path, ex);
        }
    }

    public void info(String strLine) {
        if (this.ready) {
            ++this.lineCount;
            this.pw.println("(" + this.lineCount + ") " + strLine);
        } else {
            logger.error((Object)"tried to write to closed ETL log file.");
        }
    }

    public void flush() {
        if (this.ready) {
            this.pw.flush();
        } else {
            logger.error((Object)"tried to flush closed ETL log file.");
        }
    }

    public void close() {
        this.ready = false;
        if (this.pw != null) {
            try {
                this.pw.close();
            }
            catch (Exception e) {
                logger.error((Object)"error closing ETL log file handle", (Throwable)e);
            }
        }
    }
}

