/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;

public class JDBCClassLoader
extends ClassLoader {
    private static final Logger logger = Logger.getLogger(JDBCClassLoader.class);
    protected ArchitectSession session;

    protected JDBCClassLoader(ArchitectSession session) {
        super(session.getClass().getClassLoader());
        this.session = session;
        Policy.setPolicy(new Policy(){

            public PermissionCollection getPermissions(CodeSource codesource) {
                Permissions perms = new Permissions();
                perms.add(new AllPermission());
                return perms;
            }

            public void refresh() {
            }
        });
    }

    public Class findClass(String name) throws ClassNotFoundException {
        logger.debug((Object)("Looking for class " + name));
        Iterator<String> it = this.session.getDriverJarList().iterator();
        while (it.hasNext()) {
            try {
                File listedFile = new File(it.next());
                if (!listedFile.exists()) {
                    logger.debug((Object)("Skipping non-existant JAR file " + listedFile.getPath()));
                    continue;
                }
                JarFile jf = new JarFile(listedFile);
                ZipEntry ent = jf.getEntry(String.valueOf(name.replace('.', '/')) + ".class");
                if (ent == null) {
                    jf.close();
                    continue;
                }
                byte[] buf = new byte[(int)ent.getSize()];
                InputStream is = jf.getInputStream(ent);
                int start = 0;
                int n = 0;
                while ((n = is.read(buf, start, buf.length - start)) > 0) {
                    start += n;
                }
                if ((long)(start + n) != ent.getSize()) {
                    logger.warn((Object)("What gives?  ZipEntry " + ent.getName() + " is " + ent.getSize() + " bytes long, but we only read " + (start + n) + " bytes!"));
                }
                jf.close();
                return this.defineClass(name, buf, 0, buf.length);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException("IO Exception reading class from jar file", ex);
            }
        }
        throw new ClassNotFoundException("Could not locate class " + name + " in any of the JDBC Driver JAR files " + this.session.getDriverJarList());
    }

    protected URL findResource(String name) {
        logger.debug((Object)("Looking for resource " + name));
        Iterator<String> it = this.session.getDriverJarList().iterator();
        while (it.hasNext()) {
            File listedFile = new File(it.next());
            try {
                if (!listedFile.exists()) {
                    logger.debug((Object)("Skipping non-existant JAR file " + listedFile.getPath()));
                    continue;
                }
                JarFile jf = new JarFile(listedFile);
                if (jf.getEntry(name) == null) continue;
                URI jarUri = listedFile.toURI();
                return new URL("jar:" + jarUri.toURL() + "!/" + name);
            }
            catch (IOException ex) {
                logger.warn((Object)("IO Exception while searching " + listedFile.getPath() + " for resource " + name + ". Continuing..."), (Throwable)ex);
            }
        }
        return null;
    }
}

