/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.util.SQLPowerUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class DBConnectionSpec
implements Serializable,
Comparable {
    static final long serialVersionUID = 6238643669579317332L;
    protected boolean singleLogin;
    protected int seqNo;
    protected String name;
    protected String displayName;
    protected String driverClass;
    protected String url;
    protected String user;
    protected String pass;
    protected transient PropertyChangeSupport pcs;

    protected PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public static DBConnectionSpec searchListForName(List dbcsList, String dbname) {
        DBConnectionSpec dbcs = null;
        Iterator it = dbcsList.iterator();
        while (it.hasNext()) {
            DBConnectionSpec temp = (DBConnectionSpec)it.next();
            if (!temp.getName().equals(dbname)) continue;
            dbcs = temp;
            break;
        }
        return dbcs;
    }

    public static DBConnectionSpec searchListForServer(List dbcsList, String dbHostName, int dbPort, String dbInstanceName) {
        dbHostName = dbHostName.toUpperCase();
        dbInstanceName = dbInstanceName.toUpperCase();
        DBConnectionSpec dbcs = null;
        Iterator it = dbcsList.iterator();
        while (it.hasNext()) {
            DBConnectionSpec temp = (DBConnectionSpec)it.next();
            String url = temp.getUrl().toUpperCase();
            if (url.indexOf(dbHostName) < 0 || url.indexOf(String.valueOf(dbPort)) < 0 || url.indexOf(dbInstanceName) < 0) continue;
            dbcs = temp;
            break;
        }
        return dbcs;
    }

    public int compareTo(Object other) {
        return new Integer(this.getSeqNo()).compareTo(new Integer(((DBConnectionSpec)other).getSeqNo()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DBConnectionSpec)) {
            return false;
        }
        DBConnectionSpec otherDbcs = (DBConnectionSpec)other;
        return this.getSeqNo() == otherDbcs.getSeqNo() && SQLPowerUtils.areEqual(this.getDriverClass(), otherDbcs.getDriverClass()) && SQLPowerUtils.areEqual(this.getUrl(), otherDbcs.getUrl()) && SQLPowerUtils.areEqual(this.getUser(), otherDbcs.getUser()) && SQLPowerUtils.areEqual(this.getPass(), otherDbcs.getPass());
    }

    public String toString() {
        return "DBConnectionSpec: singleLogin=" + this.singleLogin + ", " + this.name + ", " + this.displayName + ", " + this.driverClass + ", " + this.url;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().removePropertyChangeListener(l);
    }

    public boolean isSingleLogin() {
        return this.singleLogin;
    }

    public void setSingleLogin(boolean v) {
        boolean oldValue = this.singleLogin;
        this.singleLogin = v;
        this.getPcs().firePropertyChange("singleLogin", oldValue, this.singleLogin);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String argName) {
        String oldValue = this.name;
        this.name = argName;
        this.getPcs().firePropertyChange("name", oldValue, this.name);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String argDisplayName) {
        String oldValue = this.displayName;
        this.displayName = argDisplayName;
        this.getPcs().firePropertyChange("displayName", oldValue, this.displayName);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String argUrl) {
        String oldValue = this.url;
        this.url = argUrl;
        this.getPcs().firePropertyChange("url", oldValue, this.url);
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String argDriverClass) {
        String oldValue = this.driverClass;
        this.driverClass = argDriverClass;
        this.getPcs().firePropertyChange("driverClass", oldValue, this.driverClass);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String argUser) {
        String oldValue = this.user;
        this.user = argUser;
        this.getPcs().firePropertyChange("user", oldValue, this.user);
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String argPass) {
        String oldValue = this.pass;
        this.pass = argPass;
        this.getPcs().firePropertyChange("pass", oldValue, this.pass);
    }

    public int getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(int argSeqNo) {
        int oldValue = this.seqNo;
        this.seqNo = argSeqNo;
        this.getPcs().firePropertyChange("seqNo", oldValue, this.seqNo);
    }
}

