/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat4;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.util.StringParser;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.tomcat4.CoyoteConnector;
import org.apache.coyote.tomcat4.CoyoteInputStream;
import org.apache.coyote.tomcat4.CoyoteRequestFacade;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.http.Parameters;

public class CoyoteRequest
implements HttpRequest,
HttpServletRequest {
    protected Request coyoteRequest;
    protected static StringManager sm = StringManager.getManager((String)"org.apache.coyote.tomcat4");
    protected Cookie[] cookies = null;
    protected SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static Locale defaultLocale = Locale.getDefault();
    protected HashMap attributes = new HashMap();
    protected ArrayList locales = new ArrayList();
    private transient HashMap notes = new HashMap();
    protected String authType = null;
    protected BufferedReader reader = null;
    protected CoyoteInputStream inputStream = new CoyoteInputStream();
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected String contextPath = "";
    protected String pathInfo = null;
    protected String servletPath = null;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean requestParametersParsed = false;
    protected boolean secure = false;
    protected static int CACHED_POST_LEN = 8192;
    protected byte[] postData = null;
    protected ParameterMap parameterMap = new ParameterMap();
    protected Session session = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected Socket socket = null;
    protected boolean localesParsed = false;
    private StringParser parser = new StringParser();
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String authorization = null;
    protected CoyoteConnector connector;
    protected Context context = null;
    protected static final String info = "org.apache.coyote.catalina.CoyoteRequest/1.0";
    protected CoyoteRequestFacade facade = null;
    protected Response response = null;
    protected B2CConverter URIConverter = null;
    protected Wrapper wrapper = null;

    public void setCoyoteRequest(Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
        this.inputStream.setRequest(coyoteRequest);
    }

    public Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    public void recycle() {
        this.context = null;
        this.wrapper = null;
        this.authorization = null;
        this.authType = null;
        this.usingInputStream = false;
        this.usingReader = false;
        this.contextPath = "";
        this.pathInfo = null;
        this.servletPath = null;
        this.reader = null;
        this.inputStream.recycle();
        this.userPrincipal = null;
        this.sessionParsed = false;
        this.authorization = null;
        this.requestParametersParsed = false;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.attributes.clear();
        this.notes.clear();
        this.cookies = null;
        this.session = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionURL = false;
        this.parameterMap.setLocked(false);
        this.parameterMap.clear();
        if (this.facade != null) {
            this.facade.clear();
            this.facade = null;
        }
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = (CoyoteConnector)connector;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getInfo() {
        return info;
    }

    public ServletRequest getRequest() {
        if (this.facade == null) {
            this.facade = new CoyoteRequestFacade(this);
        }
        return this.facade;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
        this.remoteHost = null;
        this.remoteAddr = null;
    }

    public InputStream getStream() {
        return this.inputStream;
    }

    public void setStream(InputStream stream) {
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter URIConverter) {
        this.URIConverter = URIConverter;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public ServletInputStream createInputStream() throws IOException {
        return this.inputStream;
    }

    public void finishRequest() throws IOException {
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public void setContentLength(int length) {
    }

    public void setContentType(String type) {
    }

    public void setProtocol(String protocol) {
    }

    public void setRemoteAddr(String remoteAddr) {
    }

    public void setRemoteHost(String remoteHost) {
    }

    public void setScheme(String scheme) {
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerName(String name) {
        this.coyoteRequest.serverName().setString(name);
    }

    public void setServerPort(int port) {
        this.coyoteRequest.setServerPort(port);
    }

    public Object getAttribute(String name) {
        Object attr = this.attributes.get(name);
        if (attr != null) {
            return attr;
        }
        attr = this.coyoteRequest.getAttribute(name);
        if (attr != null) {
            this.attributes.put(name, attr);
            return attr;
        }
        if ("org.apache.coyote.request.X509Certificate".equals(name)) {
            this.coyoteRequest.action(ActionCode.ACTION_REQ_SSL_CERTIFICATE, null);
            attr = this.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put(name, attr);
            }
        }
        return attr;
    }

    public Enumeration getAttributeNames() {
        return new Enumerator(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.coyoteRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.coyoteRequest.getContentLength();
    }

    public String getContentType() {
        return this.coyoteRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getInputStream.ise"));
        }
        this.usingInputStream = true;
        return this.inputStream;
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return (Locale)this.locales.get(0);
        }
        return defaultLocale;
    }

    public Enumeration getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return new Enumerator((Collection)this.locales);
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return new Enumerator(results);
    }

    public String getParameter(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration paramNames = this.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = paramNames.nextElement().toString();
            String[] values = this.getParameterValues(name);
            this.parameterMap.put((Object)name, (Object)values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.requestParametersParsed) {
            this.parseRequestParameters();
        }
        return this.coyoteRequest.getParameters().getParameterValues(name);
    }

    public String getProtocol() {
        return this.coyoteRequest.protocol().toString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getReader.ise"));
        }
        this.usingReader = true;
        if (this.reader == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
            }
            InputStreamReader r = new InputStreamReader((InputStream)((Object)this.inputStream), encoding);
            this.reader = new BufferedReader(r);
        }
        return this.reader;
    }

    public String getRealPath(String path) {
        if (this.context == null) {
            return null;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return null;
        }
        try {
            return servletContext.getRealPath(path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteAddr = inet.getHostAddress();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE, (Object)this.coyoteRequest);
                this.remoteAddr = this.coyoteRequest.remoteAddr().toString();
            }
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (!this.connector.getEnableLookups()) {
                this.remoteHost = this.getRemoteAddr();
            } else if (this.socket != null) {
                InetAddress inet = this.socket.getInetAddress();
                this.remoteHost = inet.getHostName();
            } else {
                this.coyoteRequest.action(ActionCode.ACTION_REQ_HOST_ATTRIBUTE, (Object)this.coyoteRequest);
                this.remoteHost = this.coyoteRequest.remoteHost().toString();
            }
        }
        return this.remoteHost;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.context == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? RequestUtil.normalize((String)(requestPath.substring(0, pos + 1) + path)) : RequestUtil.normalize((String)(requestPath + path));
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    public String getScheme() {
        return this.coyoteRequest.scheme().toString();
    }

    public String getServerName() {
        return this.coyoteRequest.serverName().toString();
    }

    public int getServerPort() {
        return this.coyoteRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("coyoteRequest.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        this.attributes.put(name, value);
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        byte[] buffer = new byte[]{97};
        String dummy = new String(buffer, enc);
        this.coyoteRequest.setCharacterEncoding(enc);
    }

    public void addCookie(Cookie cookie) {
        int size = 0;
        if (this.cookies != null) {
            size = this.cookies.length;
        }
        Cookie[] newCookies = new Cookie[size + 1];
        for (int i = 0; i < size; ++i) {
            newCookies[i] = this.cookies[i];
        }
        newCookies[size] = cookie;
        this.cookies = newCookies;
    }

    public void addHeader(String name, String value) {
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addParameter(String name, String[] values) {
        this.coyoteRequest.getParameters().addParameterValues(name, values);
    }

    public void clearCookies() {
        this.cookies = null;
    }

    public void clearHeaders() {
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
    }

    public void setAuthType(String type) {
        this.authType = type;
    }

    public void setContextPath(String path) {
        this.contextPath = path == null ? "" : path;
    }

    public void setMethod(String method) {
    }

    public void setQueryString(String query) {
    }

    public void setPathInfo(String path) {
        this.pathInfo = path;
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    public void setRequestedSessionId(String id) {
        this.requestedSessionId = id;
    }

    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    public void setRequestURI(String uri) {
    }

    public void setDecodedRequestURI(String uri) {
    }

    public String getDecodedRequestURI() {
        return this.coyoteRequest.decodedURI().toString();
    }

    public void setServletPath(String path) {
        this.servletPath = path;
    }

    public void setUserPrincipal(Principal principal) {
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        value = value + " ";
        for (int i = 0; i < this.formats.length; ++i) {
            try {
                Date date = this.formats[i].parse(value);
                return date.getTime();
            }
            catch (ParseException e) {
                continue;
            }
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        return this.coyoteRequest.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.coyoteRequest.getMimeHeaders().values(name);
    }

    public Enumeration getHeaderNames() {
        return this.coyoteRequest.getMimeHeaders().names();
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.coyoteRequest.method().toString();
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        if (this.context == null) {
            return null;
        }
        if (this.pathInfo == null) {
            return null;
        }
        return this.context.getServletContext().getRealPath(this.pathInfo);
    }

    public String getQueryString() {
        String queryString = this.coyoteRequest.queryString().toString();
        if (queryString == null || queryString.equals("")) {
            return null;
        }
        return queryString;
    }

    public String getRemoteUser() {
        if (this.userPrincipal != null) {
            return this.userPrincipal.getName();
        }
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.coyoteRequest.requestURI().toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (System.getSecurityManager() != null) {
            PrivilegedGetSession dp = new PrivilegedGetSession(create);
            return (HttpSession)AccessController.doPrivileged(dp);
        }
        return this.doGetSession(create);
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionCookie;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId != null) {
            return this.requestedSessionURL;
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return false;
        }
        Session session = null;
        try {
            session = manager.findSession(this.requestedSessionId);
        }
        catch (IOException e) {
            session = null;
        }
        return session != null && session.isValid();
    }

    public boolean isUserInRole(String role) {
        String realRole;
        if (this.userPrincipal == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        if (this.wrapper != null && (realRole = this.wrapper.findSecurityReference(role)) != null && realm.hasRole(this.userPrincipal, realRole)) {
            return true;
        }
        return realm.hasRole(this.userPrincipal, role);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    protected HttpSession doGetSession(boolean create) {
        if (this.context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session.getSession();
        }
        Manager manager = null;
        if (this.context != null) {
            manager = this.context.getManager();
        }
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            try {
                this.session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException e) {
                this.session = null;
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                return this.session.getSession();
            }
        }
        if (!create) {
            return null;
        }
        if (this.context != null && this.response != null && this.context.getCookies() && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.sessionCreateCommitted"));
        }
        this.session = manager.createSession();
        if (this.session != null && this.getContext() != null && this.getContext().getCookies()) {
            Cookie cookie = new Cookie("JSESSIONID", this.session.getId());
            cookie.setMaxAge(-1);
            String contextPath = null;
            if (this.context != null) {
                contextPath = this.context.getPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
            if (this.isSecure()) {
                cookie.setSecure(true);
            }
            ((HttpServletResponse)this.response).addCookie(cookie);
        }
        if (this.session != null) {
            return this.session.getSession();
        }
        return null;
    }

    protected void parseRequestParameters() {
        int semicolon;
        this.requestParametersParsed = true;
        Parameters parameters = this.coyoteRequest.getParameters();
        String enc = this.coyoteRequest.getCharacterEncoding();
        boolean useBodyEncodingForURI = this.connector.getUseBodyEncodingForURI();
        if (enc != null) {
            parameters.setEncoding(enc);
            if (useBodyEncodingForURI) {
                parameters.setQueryStringEncoding(enc);
            }
        } else {
            parameters.setEncoding("ISO-8859-1");
            if (useBodyEncodingForURI) {
                parameters.setQueryStringEncoding("ISO-8859-1");
            }
        }
        parameters.handleQueryParameters();
        if (this.usingInputStream || this.usingReader) {
            return;
        }
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            return;
        }
        int len = this.getContentLength();
        if (len > 0) {
            try {
                byte[] formData = null;
                if (len < CACHED_POST_LEN) {
                    if (this.postData == null) {
                        this.postData = new byte[CACHED_POST_LEN];
                    }
                    formData = this.postData;
                } else {
                    formData = new byte[len];
                }
                int actualLen = this.readPostBody(formData, len);
                if (actualLen == len) {
                    parameters.processParameters(formData, 0, len);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    protected int readPostBody(byte[] body, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = this.getStream().read(body, offset, len - offset)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    protected void parseLocales() {
        this.localesParsed = true;
        Enumeration values = this.getHeaders("accept-language");
        while (values.hasMoreElements()) {
            String value = values.nextElement().toString();
            this.parseLocalesHeader(value);
        }
    }

    protected void parseLocalesHeader(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuffer sb = new StringBuffer();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value = sb.toString();
        }
        this.parser.setString(value);
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    quality = Double.parseDouble(entry.substring(semi + 3));
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            String variant = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            Locale locale = new Locale(language, country, variant);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        Iterator keys = locales.keySet().iterator();
        while (keys.hasNext()) {
            Double key = (Double)keys.next();
            ArrayList list = (ArrayList)locales.get(key);
            Iterator values = list.iterator();
            while (values.hasNext()) {
                Locale locale = (Locale)values.next();
                this.addLocale(locale);
            }
        }
    }

    protected class PrivilegedGetSession
    implements PrivilegedAction {
        private boolean create;

        PrivilegedGetSession(boolean create) {
            this.create = create;
        }

        public Object run() {
            return CoyoteRequest.this.doGetSession(this.create);
        }
    }
}

