//
// Register Declarations for Microchip 16C926 Processor
//
//
// This header file was automatically generated by:
//
//	inc2h.pl V1.6
//
//	Copyright (c) 2002, Kevin L. Pauba, All Rights Reserved
//
//	SDCC is licensed under the GNU Public license (GPL) v2.  Note that
//	this license covers the code to the compiler and other executables,
//	but explicitly does not cover any code or objects generated by sdcc.
//	We have not yet decided on a license for the run time libraries, but
//	it will not put any requirements on code linked against it. See:
// 
//	http://www.gnu.org/copyleft/gpl/html
//
//	See http://sdcc.sourceforge.net/ for the latest information on sdcc.
//
// 
#ifndef P16C926_H
#define P16C926_H

//
// Register addresses.
//
#define INDF_ADDR	0x0000
#define TMR0_ADDR	0x0001
#define PCL_ADDR	0x0002
#define STATUS_ADDR	0x0003
#define FSR_ADDR	0x0004
#define PORTA_ADDR	0x0005
#define PORTB_ADDR	0x0006
#define PORTC_ADDR	0x0007
#define PORTD_ADDR	0x0008
#define PORTE_ADDR	0x0009
#define PCLATH_ADDR	0x000A
#define INTCON_ADDR	0x000B
#define PIR1_ADDR	0x000C
#define TMR1L_ADDR	0x000E
#define TMR1H_ADDR	0x000F
#define T1CON_ADDR	0x0010
#define TMR2_ADDR	0x0011
#define T2CON_ADDR	0x0012
#define SSPBUF_ADDR	0x0013
#define SSPCON_ADDR	0x0014
#define CCPR1L_ADDR	0x0015
#define CCPR1H_ADDR	0x0016
#define CCP1CON_ADDR	0x0017
#define ADRESH_ADDR	0x001E
#define ADCON0_ADDR	0x001F
#define OPTION_REG_ADDR	0x0081
#define TRISA_ADDR	0x0085
#define TRISB_ADDR	0x0086
#define TRISC_ADDR	0x0087
#define TRISD_ADDR	0x0088
#define TRISE_ADDR	0x0089
#define PIE1_ADDR	0x008C
#define PCON_ADDR	0x008E
#define PR2_ADDR	0x0092
#define SSPADD_ADDR	0x0093
#define SSPSTAT_ADDR	0x0094
#define ADRESL_ADDR	0x009E
#define ADCON1_ADDR	0x009F
#define PORTF_ADDR	0x0107
#define PORTG_ADDR	0x0108
#define PMCON1_ADDR	0x010C
#define LCDSE_ADDR	0x010D
#define LCDPS_ADDR	0x010E
#define LCDCON_ADDR	0x010F
#define LCDD00_ADDR	0x0110
#define LCDD01_ADDR	0x0111
#define LCDD02_ADDR	0x0112
#define LCDD03_ADDR	0x0113
#define LCDD04_ADDR	0x0114
#define LCDD05_ADDR	0x0115
#define LCDD06_ADDR	0x0116
#define LCDD07_ADDR	0x0117
#define LCDD08_ADDR	0x0118
#define LCDD09_ADDR	0x0119
#define LCDD10_ADDR	0x011A
#define LCDD11_ADDR	0x011B
#define LCDD12_ADDR	0x011C
#define LCDD13_ADDR	0x011D
#define LCDD14_ADDR	0x011E
#define LCDD15_ADDR	0x011F
#define TRISF_ADDR	0x0187
#define TRISG_ADDR	0x0188
#define PMDATA_ADDR	0x018C
#define PMDATH_ADDR	0x018D
#define PMADR_ADDR	0x018E
#define PMADRH_ADDR	0x018F

//
// Memory organization.
//

#pragma memmap INDF_ADDR INDF_ADDR SFR 0x000	// INDF
#pragma memmap TMR0_ADDR TMR0_ADDR SFR 0x000	// TMR0
#pragma memmap PCL_ADDR PCL_ADDR SFR 0x000	// PCL
#pragma memmap STATUS_ADDR STATUS_ADDR SFR 0x000	// STATUS
#pragma memmap FSR_ADDR FSR_ADDR SFR 0x000	// FSR
#pragma memmap PORTA_ADDR PORTA_ADDR SFR 0x000	// PORTA
#pragma memmap PORTB_ADDR PORTB_ADDR SFR 0x000	// PORTB
#pragma memmap PORTC_ADDR PORTC_ADDR SFR 0x000	// PORTC
#pragma memmap PORTD_ADDR PORTD_ADDR SFR 0x000	// PORTD
#pragma memmap PORTE_ADDR PORTE_ADDR SFR 0x000	// PORTE
#pragma memmap PCLATH_ADDR PCLATH_ADDR SFR 0x000	// PCLATH
#pragma memmap INTCON_ADDR INTCON_ADDR SFR 0x000	// INTCON
#pragma memmap PIR1_ADDR PIR1_ADDR SFR 0x000	// PIR1
#pragma memmap TMR1L_ADDR TMR1L_ADDR SFR 0x000	// TMR1L
#pragma memmap TMR1H_ADDR TMR1H_ADDR SFR 0x000	// TMR1H
#pragma memmap T1CON_ADDR T1CON_ADDR SFR 0x000	// T1CON
#pragma memmap TMR2_ADDR TMR2_ADDR SFR 0x000	// TMR2
#pragma memmap T2CON_ADDR T2CON_ADDR SFR 0x000	// T2CON
#pragma memmap SSPBUF_ADDR SSPBUF_ADDR SFR 0x000	// SSPBUF
#pragma memmap SSPCON_ADDR SSPCON_ADDR SFR 0x000	// SSPCON
#pragma memmap CCPR1L_ADDR CCPR1L_ADDR SFR 0x000	// CCPR1L
#pragma memmap CCPR1H_ADDR CCPR1H_ADDR SFR 0x000	// CCPR1H
#pragma memmap CCP1CON_ADDR CCP1CON_ADDR SFR 0x000	// CCP1CON
#pragma memmap ADRESH_ADDR ADRESH_ADDR SFR 0x000	// ADRESH
#pragma memmap ADCON0_ADDR ADCON0_ADDR SFR 0x000	// ADCON0
#pragma memmap OPTION_REG_ADDR OPTION_REG_ADDR SFR 0x000	// OPTION_REG
#pragma memmap TRISA_ADDR TRISA_ADDR SFR 0x000	// TRISA
#pragma memmap TRISB_ADDR TRISB_ADDR SFR 0x000	// TRISB
#pragma memmap TRISC_ADDR TRISC_ADDR SFR 0x000	// TRISC
#pragma memmap TRISD_ADDR TRISD_ADDR SFR 0x000	// TRISD
#pragma memmap TRISE_ADDR TRISE_ADDR SFR 0x000	// TRISE
#pragma memmap PIE1_ADDR PIE1_ADDR SFR 0x000	// PIE1
#pragma memmap PCON_ADDR PCON_ADDR SFR 0x000	// PCON
#pragma memmap PR2_ADDR PR2_ADDR SFR 0x000	// PR2
#pragma memmap SSPADD_ADDR SSPADD_ADDR SFR 0x000	// SSPADD
#pragma memmap SSPSTAT_ADDR SSPSTAT_ADDR SFR 0x000	// SSPSTAT
#pragma memmap ADRESL_ADDR ADRESL_ADDR SFR 0x000	// ADRESL
#pragma memmap ADCON1_ADDR ADCON1_ADDR SFR 0x000	// ADCON1
#pragma memmap PORTF_ADDR PORTF_ADDR SFR 0x000	// PORTF
#pragma memmap PORTG_ADDR PORTG_ADDR SFR 0x000	// PORTG
#pragma memmap PMCON1_ADDR PMCON1_ADDR SFR 0x000	// PMCON1
#pragma memmap LCDSE_ADDR LCDSE_ADDR SFR 0x000	// LCDSE
#pragma memmap LCDPS_ADDR LCDPS_ADDR SFR 0x000	// LCDPS
#pragma memmap LCDCON_ADDR LCDCON_ADDR SFR 0x000	// LCDCON
#pragma memmap LCDD00_ADDR LCDD00_ADDR SFR 0x000	// LCDD00
#pragma memmap LCDD01_ADDR LCDD01_ADDR SFR 0x000	// LCDD01
#pragma memmap LCDD02_ADDR LCDD02_ADDR SFR 0x000	// LCDD02
#pragma memmap LCDD03_ADDR LCDD03_ADDR SFR 0x000	// LCDD03
#pragma memmap LCDD04_ADDR LCDD04_ADDR SFR 0x000	// LCDD04
#pragma memmap LCDD05_ADDR LCDD05_ADDR SFR 0x000	// LCDD05
#pragma memmap LCDD06_ADDR LCDD06_ADDR SFR 0x000	// LCDD06
#pragma memmap LCDD07_ADDR LCDD07_ADDR SFR 0x000	// LCDD07
#pragma memmap LCDD08_ADDR LCDD08_ADDR SFR 0x000	// LCDD08
#pragma memmap LCDD09_ADDR LCDD09_ADDR SFR 0x000	// LCDD09
#pragma memmap LCDD10_ADDR LCDD10_ADDR SFR 0x000	// LCDD10
#pragma memmap LCDD11_ADDR LCDD11_ADDR SFR 0x000	// LCDD11
#pragma memmap LCDD12_ADDR LCDD12_ADDR SFR 0x000	// LCDD12
#pragma memmap LCDD13_ADDR LCDD13_ADDR SFR 0x000	// LCDD13
#pragma memmap LCDD14_ADDR LCDD14_ADDR SFR 0x000	// LCDD14
#pragma memmap LCDD15_ADDR LCDD15_ADDR SFR 0x000	// LCDD15
#pragma memmap TRISF_ADDR TRISF_ADDR SFR 0x000	// TRISF
#pragma memmap TRISG_ADDR TRISG_ADDR SFR 0x000	// TRISG
#pragma memmap PMDATA_ADDR PMDATA_ADDR SFR 0x000	// PMDATA
#pragma memmap PMDATH_ADDR PMDATH_ADDR SFR 0x000	// PMDATH
#pragma memmap PMADR_ADDR PMADR_ADDR SFR 0x000	// PMADR
#pragma memmap PMADRH_ADDR PMADRH_ADDR SFR 0x000	// PMADRH


//         LIST
// P16C926.INC  Standard Header File, Version 1.02   Microchip Technology, Inc.
//         NOLIST

// This header file defines configurations, registers, and other useful bits of
// information for the PIC16C926 microcontroller.  These names are taken to match 
// the data sheets as closely as possible.  

// Note that the processor must be selected before this file is 
// included.  The processor may be selected the following ways:

//       1. Command line switch:
//               C:\ MPASM MYFILE.ASM /PIC16C926
//       2. LIST directive in the source file
//               LIST   P=PIC16C926
//       3. Processor Type entry in the MPASM full-screen interface

//==========================================================================
//
//       Revision History
//
//==========================================================================

//Rev:   Date:    Reason:

//1.00   10/11/00 Initial Release
//1.01   02/27/01 Changes to reflect design changes to data memory map:
//                1.) Locations of PMDATA and PMCON1 swapped.
//                2.) Locations of PMDATH and PMADR swapped.
//1.02   03/02/01 PORTF, PORTG, TRISF, and TRISG addresses corrected.
//1.03   03/06/01 RD bit in PMCON1 defined.
//1.04   03/12/01 Locations of PMDATH and PMADR restored to before v1.01.
//1.05	10/19/01 Locations of PMDATH and PMADR restored to before v1.04.
//1.06	06/03/01 Values for _CP_ALL, _CP_75, _CP_50, and _BODEN_OFF corrected.

//==========================================================================
//
//       Verify Processor
//
//==========================================================================

//        IFNDEF __16C926
//            MESSG "Processor-header file mismatch.  Verify selected processor."
//         ENDIF

//==========================================================================
//
//       Register Definitions
//
//==========================================================================

#define W                    0x0000
#define F                    0x0001

//----- Register Files------------------------------------------------------

extern __data __at (INDF_ADDR) volatile char      INDF;
extern __sfr  __at (TMR0_ADDR)                    TMR0;
extern __data __at (PCL_ADDR) volatile char       PCL;
extern __sfr  __at (STATUS_ADDR)                  STATUS;
extern __sfr  __at (FSR_ADDR)                     FSR;
extern __sfr  __at (PORTA_ADDR)                   PORTA;
extern __sfr  __at (PORTB_ADDR)                   PORTB;
extern __sfr  __at (PORTC_ADDR)                   PORTC;
extern __sfr  __at (PORTD_ADDR)                   PORTD;
extern __sfr  __at (PORTE_ADDR)                   PORTE;
extern __sfr  __at (PCLATH_ADDR)                  PCLATH;
extern __sfr  __at (INTCON_ADDR)                  INTCON;
extern __sfr  __at (PIR1_ADDR)                    PIR1;
extern __sfr  __at (TMR1L_ADDR)                   TMR1L;
extern __sfr  __at (TMR1H_ADDR)                   TMR1H;
extern __sfr  __at (T1CON_ADDR)                   T1CON;
extern __sfr  __at (TMR2_ADDR)                    TMR2;
extern __sfr  __at (T2CON_ADDR)                   T2CON;
extern __sfr  __at (SSPBUF_ADDR)                  SSPBUF;
extern __sfr  __at (SSPCON_ADDR)                  SSPCON;
extern __sfr  __at (CCPR1L_ADDR)                  CCPR1L;
extern __sfr  __at (CCPR1H_ADDR)                  CCPR1H;
extern __sfr  __at (CCP1CON_ADDR)                 CCP1CON;
extern __sfr  __at (ADRESH_ADDR)                  ADRESH;
extern __sfr  __at (ADCON0_ADDR)                  ADCON0;

extern __sfr  __at (OPTION_REG_ADDR)              OPTION_REG;
extern __sfr  __at (TRISA_ADDR)                   TRISA;
extern __sfr  __at (TRISB_ADDR)                   TRISB;
extern __sfr  __at (TRISC_ADDR)                   TRISC;
extern __sfr  __at (TRISD_ADDR)                   TRISD;
extern __sfr  __at (TRISE_ADDR)                   TRISE;
extern __sfr  __at (PIE1_ADDR)                    PIE1;
extern __sfr  __at (PCON_ADDR)                    PCON;
extern __sfr  __at (PR2_ADDR)                     PR2;
extern __sfr  __at (SSPADD_ADDR)                  SSPADD;
extern __sfr  __at (SSPSTAT_ADDR)                 SSPSTAT;
extern __sfr  __at (ADRESL_ADDR)                  ADRESL;
extern __sfr  __at (ADCON1_ADDR)                  ADCON1;

extern __sfr  __at (PORTF_ADDR)                   PORTF;
extern __sfr  __at (PORTG_ADDR)                   PORTG;
extern __sfr  __at (PMCON1_ADDR)                  PMCON1;
extern __sfr  __at (LCDSE_ADDR)                   LCDSE;
extern __sfr  __at (LCDPS_ADDR)                   LCDPS;
extern __sfr  __at (LCDCON_ADDR)                  LCDCON;
extern __sfr  __at (LCDD00_ADDR)                  LCDD00;
extern __sfr  __at (LCDD01_ADDR)                  LCDD01;
extern __sfr  __at (LCDD02_ADDR)                  LCDD02;
extern __sfr  __at (LCDD03_ADDR)                  LCDD03;
extern __sfr  __at (LCDD04_ADDR)                  LCDD04;
extern __sfr  __at (LCDD05_ADDR)                  LCDD05;
extern __sfr  __at (LCDD06_ADDR)                  LCDD06;
extern __sfr  __at (LCDD07_ADDR)                  LCDD07;
extern __sfr  __at (LCDD08_ADDR)                  LCDD08;
extern __sfr  __at (LCDD09_ADDR)                  LCDD09;
extern __sfr  __at (LCDD10_ADDR)                  LCDD10;
extern __sfr  __at (LCDD11_ADDR)                  LCDD11;
extern __sfr  __at (LCDD12_ADDR)                  LCDD12;
extern __sfr  __at (LCDD13_ADDR)                  LCDD13;
extern __sfr  __at (LCDD14_ADDR)                  LCDD14;
extern __sfr  __at (LCDD15_ADDR)                  LCDD15;

extern __sfr  __at (TRISF_ADDR)                   TRISF;
extern __sfr  __at (TRISG_ADDR)                   TRISG;
extern __sfr  __at (PMDATA_ADDR)                  PMDATA;
extern __sfr  __at (PMDATH_ADDR)                  PMDATH;
extern __sfr  __at (PMADR_ADDR)                   PMADR;
extern __sfr  __at (PMADRH_ADDR)                  PMADRH;


//----- STATUS Bits --------------------------------------------------------


//----- INTCON Bits --------------------------------------------------------


//----- PIR1 Bits ----------------------------------------------------------


//----- T1CON Bits ---------------------------------------------------------


//----- T2CON Bits ---------------------------------------------------------


//----- SSPCON Bits --------------------------------------------------------


//----- CCP1CON Bits -------------------------------------------------------


//----- ADCON0 Bits --------------------------------------------------------


//----- ADCON1 Bits --------------------------------------------------------



//----- OPTION Bits --------------------------------------------------------


//----- TRISE Bits ---------------------------------------------------------


//----- PIE1 Bits ----------------------------------------------------------


//----- PCON Bits ----------------------------------------------------------


//----- SSPSTAT Bits -------------------------------------------------------


//----- LCDSE Bits ---------------------------------------------------------


//----- LCDPS Bits ---------------------------------------------------------


//----- LCDCON Bits --------------------------------------------------------


//----- PMCON1 Bits --------------------------------------------------------

//==========================================================================
//
//       RAM Definition
//
//==========================================================================

//         __MAXRAM H'1FF'
//         __BADRAM H'0D', H'18'-H'1D'
//         __BADRAM H'8D', H'8F'-H'91', H'95'-H'9D'
//         __BADRAM H'105', H'109'
//         __BADRAM H'185', H'189', H'190'-H'19F'

//==========================================================================
//
//       Configuration Bits
//
//==========================================================================

#define _CP_ALL              0x3FCF
#define _CP_75               0x3FDF
#define _CP_50               0x3FEF
#define _CP_OFF              0x3FFF
#define _BODEN_OFF           0x3FBF
#define _BODEN_ON            0x3FFF
#define _PWRTE_OFF           0x3FFF
#define _PWRTE_ON            0x3FF7
#define _WDT_ON              0x3FFF
#define _WDT_OFF             0x3FFB
#define _LP_OSC              0x3FFC
#define _XT_OSC              0x3FFD
#define _HS_OSC              0x3FFE
#define _RC_OSC              0x3FFF

//         LIST

// ----- ADCON0 bits --------------------
typedef union {
  struct {
    unsigned char ADON:1;
    unsigned char :1;
    unsigned char GO:1;
    unsigned char CHS0:1;
    unsigned char CHS1:1;
    unsigned char CHS2:1;
    unsigned char ADCS0:1;
    unsigned char ADCS1:1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_DONE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char GO_DONE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __ADCON0_bits_t;
extern volatile __ADCON0_bits_t __at(ADCON0_ADDR) ADCON0_bits;

#define ADON                 ADCON0_bits.ADON
#define GO                   ADCON0_bits.GO
#define NOT_DONE             ADCON0_bits.NOT_DONE
#define GO_DONE              ADCON0_bits.GO_DONE
#define CHS0                 ADCON0_bits.CHS0
#define CHS1                 ADCON0_bits.CHS1
#define CHS2                 ADCON0_bits.CHS2
#define ADCS0                ADCON0_bits.ADCS0
#define ADCS1                ADCON0_bits.ADCS1

// ----- ADCON1 bits --------------------
typedef union {
  struct {
    unsigned char PCFG0:1;
    unsigned char PCFG1:1;
    unsigned char PCFG2:1;
    unsigned char PCFG3:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char ADFM:1;
  };
} __ADCON1_bits_t;
extern volatile __ADCON1_bits_t __at(ADCON1_ADDR) ADCON1_bits;

#define PCFG0                ADCON1_bits.PCFG0
#define PCFG1                ADCON1_bits.PCFG1
#define PCFG2                ADCON1_bits.PCFG2
#define PCFG3                ADCON1_bits.PCFG3
#define ADFM                 ADCON1_bits.ADFM

// ----- CCP1CON bits --------------------
typedef union {
  struct {
    unsigned char CCP1M0:1;
    unsigned char CCP1M1:1;
    unsigned char CCP1M2:1;
    unsigned char CCP1M3:1;
    unsigned char CCP1Y:1;
    unsigned char CCP1X:1;
    unsigned char :1;
    unsigned char :1;
  };
} __CCP1CON_bits_t;
extern volatile __CCP1CON_bits_t __at(CCP1CON_ADDR) CCP1CON_bits;

#define CCP1M0               CCP1CON_bits.CCP1M0
#define CCP1M1               CCP1CON_bits.CCP1M1
#define CCP1M2               CCP1CON_bits.CCP1M2
#define CCP1M3               CCP1CON_bits.CCP1M3
#define CCP1Y                CCP1CON_bits.CCP1Y
#define CCP1X                CCP1CON_bits.CCP1X

// ----- INTCON bits --------------------
typedef union {
  struct {
    unsigned char RBIF:1;
    unsigned char INTF:1;
    unsigned char T0IF:1;
    unsigned char RBIE:1;
    unsigned char INTE:1;
    unsigned char T0IE:1;
    unsigned char PEIE:1;
    unsigned char GIE:1;
  };
} __INTCON_bits_t;
extern volatile __INTCON_bits_t __at(INTCON_ADDR) INTCON_bits;

#define RBIF                 INTCON_bits.RBIF
#define INTF                 INTCON_bits.INTF
#define T0IF                 INTCON_bits.T0IF
#define RBIE                 INTCON_bits.RBIE
#define INTE                 INTCON_bits.INTE
#define T0IE                 INTCON_bits.T0IE
#define PEIE                 INTCON_bits.PEIE
#define GIE                  INTCON_bits.GIE

// ----- LCDCON bits --------------------
typedef union {
  struct {
    unsigned char LMUX0:1;
    unsigned char LMUX1:1;
    unsigned char CS0:1;
    unsigned char CS1:1;
    unsigned char BIAS:1;
    unsigned char WERR:1;
    unsigned char SLPEN:1;
    unsigned char LCDEN:1;
  };
} __LCDCON_bits_t;
extern volatile __LCDCON_bits_t __at(LCDCON_ADDR) LCDCON_bits;

#define LMUX0                LCDCON_bits.LMUX0
#define LMUX1                LCDCON_bits.LMUX1
#define CS0                  LCDCON_bits.CS0
#define CS1                  LCDCON_bits.CS1
#define BIAS                 LCDCON_bits.BIAS
#define WERR                 LCDCON_bits.WERR
#define SLPEN                LCDCON_bits.SLPEN
#define LCDEN                LCDCON_bits.LCDEN

// ----- LCDPS bits --------------------
typedef union {
  struct {
    unsigned char LP0:1;
    unsigned char LP1:1;
    unsigned char LP2:1;
    unsigned char LP3:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __LCDPS_bits_t;
extern volatile __LCDPS_bits_t __at(LCDPS_ADDR) LCDPS_bits;

#define LP0                  LCDPS_bits.LP0
#define LP1                  LCDPS_bits.LP1
#define LP2                  LCDPS_bits.LP2
#define LP3                  LCDPS_bits.LP3

// ----- LCDSE bits --------------------
typedef union {
  struct {
    unsigned char SE0:1;
    unsigned char SE5:1;
    unsigned char SE9:1;
    unsigned char SE12:1;
    unsigned char SE16:1;
    unsigned char SE20:1;
    unsigned char SE27:1;
    unsigned char SE29:1;
  };
} __LCDSE_bits_t;
extern volatile __LCDSE_bits_t __at(LCDSE_ADDR) LCDSE_bits;

#define SE0                  LCDSE_bits.SE0
#define SE5                  LCDSE_bits.SE5
#define SE9                  LCDSE_bits.SE9
#define SE12                 LCDSE_bits.SE12
#define SE16                 LCDSE_bits.SE16
#define SE20                 LCDSE_bits.SE20
#define SE27                 LCDSE_bits.SE27
#define SE29                 LCDSE_bits.SE29

// ----- OPTION_REG bits --------------------
typedef union {
  struct {
    unsigned char PS0:1;
    unsigned char PS1:1;
    unsigned char PS2:1;
    unsigned char PSA:1;
    unsigned char T0SE:1;
    unsigned char T0CS:1;
    unsigned char INTEDG:1;
    unsigned char NOT_RBPU:1;
  };
} __OPTION_REG_bits_t;
extern volatile __OPTION_REG_bits_t __at(OPTION_REG_ADDR) OPTION_REG_bits;

#define PS0                  OPTION_REG_bits.PS0
#define PS1                  OPTION_REG_bits.PS1
#define PS2                  OPTION_REG_bits.PS2
#define PSA                  OPTION_REG_bits.PSA
#define T0SE                 OPTION_REG_bits.T0SE
#define T0CS                 OPTION_REG_bits.T0CS
#define INTEDG               OPTION_REG_bits.INTEDG
#define NOT_RBPU             OPTION_REG_bits.NOT_RBPU

// ----- PCON bits --------------------
typedef union {
  struct {
    unsigned char NOT_BOR:1;
    unsigned char NOT_POR:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __PCON_bits_t;
extern volatile __PCON_bits_t __at(PCON_ADDR) PCON_bits;

#define NOT_BOR              PCON_bits.NOT_BOR
#define NOT_POR              PCON_bits.NOT_POR

// ----- PIE1 bits --------------------
typedef union {
  struct {
    unsigned char TMR1IE:1;
    unsigned char TMR2IE:1;
    unsigned char CCP1IE:1;
    unsigned char SSPIE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char ADIE:1;
    unsigned char LCDIE:1;
  };
} __PIE1_bits_t;
extern volatile __PIE1_bits_t __at(PIE1_ADDR) PIE1_bits;

#define TMR1IE               PIE1_bits.TMR1IE
#define TMR2IE               PIE1_bits.TMR2IE
#define CCP1IE               PIE1_bits.CCP1IE
#define SSPIE                PIE1_bits.SSPIE
#define ADIE                 PIE1_bits.ADIE
#define LCDIE                PIE1_bits.LCDIE

// ----- PIR1 bits --------------------
typedef union {
  struct {
    unsigned char TMR1IF:1;
    unsigned char TMR2IF:1;
    unsigned char CCP1IF:1;
    unsigned char SSPIF:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char ADIF:1;
    unsigned char LCDIF:1;
  };
} __PIR1_bits_t;
extern volatile __PIR1_bits_t __at(PIR1_ADDR) PIR1_bits;

#define TMR1IF               PIR1_bits.TMR1IF
#define TMR2IF               PIR1_bits.TMR2IF
#define CCP1IF               PIR1_bits.CCP1IF
#define SSPIF                PIR1_bits.SSPIF
#define ADIF                 PIR1_bits.ADIF
#define LCDIF                PIR1_bits.LCDIF

// ----- PMCON1 bits --------------------
typedef union {
  struct {
    unsigned char RD:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __PMCON1_bits_t;
extern volatile __PMCON1_bits_t __at(PMCON1_ADDR) PMCON1_bits;

#define RD                   PMCON1_bits.RD

// ----- SSPCON bits --------------------
typedef union {
  struct {
    unsigned char SSPM0:1;
    unsigned char SSPM1:1;
    unsigned char SSPM2:1;
    unsigned char SSPM3:1;
    unsigned char CKP:1;
    unsigned char SSPEN:1;
    unsigned char SSPOV:1;
    unsigned char WCOL:1;
  };
} __SSPCON_bits_t;
extern volatile __SSPCON_bits_t __at(SSPCON_ADDR) SSPCON_bits;

#define SSPM0                SSPCON_bits.SSPM0
#define SSPM1                SSPCON_bits.SSPM1
#define SSPM2                SSPCON_bits.SSPM2
#define SSPM3                SSPCON_bits.SSPM3
#define CKP                  SSPCON_bits.CKP
#define SSPEN                SSPCON_bits.SSPEN
#define SSPOV                SSPCON_bits.SSPOV
#define WCOL                 SSPCON_bits.WCOL

// ----- SSPSTAT bits --------------------
typedef union {
  struct {
    unsigned char BF:1;
    unsigned char UA:1;
    unsigned char R:1;
    unsigned char S:1;
    unsigned char P:1;
    unsigned char D:1;
    unsigned char CKE:1;
    unsigned char SMP:1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char I2C_READ:1;
    unsigned char I2C_START:1;
    unsigned char I2C_STOP:1;
    unsigned char I2C_DATA:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_W:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_A:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_WRITE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char NOT_ADDRESS:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char R_W:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char D_A:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char READ_WRITE:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char DATA_ADDRESS:1;
    unsigned char :1;
    unsigned char :1;
  };
} __SSPSTAT_bits_t;
extern volatile __SSPSTAT_bits_t __at(SSPSTAT_ADDR) SSPSTAT_bits;

#define BF                   SSPSTAT_bits.BF
#define UA                   SSPSTAT_bits.UA
#define R                    SSPSTAT_bits.R
#define I2C_READ             SSPSTAT_bits.I2C_READ
#define NOT_W                SSPSTAT_bits.NOT_W
#define NOT_WRITE            SSPSTAT_bits.NOT_WRITE
#define R_W                  SSPSTAT_bits.R_W
#define READ_WRITE           SSPSTAT_bits.READ_WRITE
#define S                    SSPSTAT_bits.S
#define I2C_START            SSPSTAT_bits.I2C_START
#define P                    SSPSTAT_bits.P
#define I2C_STOP             SSPSTAT_bits.I2C_STOP
#define D                    SSPSTAT_bits.D
#define I2C_DATA             SSPSTAT_bits.I2C_DATA
#define NOT_A                SSPSTAT_bits.NOT_A
#define NOT_ADDRESS          SSPSTAT_bits.NOT_ADDRESS
#define D_A                  SSPSTAT_bits.D_A
#define DATA_ADDRESS         SSPSTAT_bits.DATA_ADDRESS
#define CKE                  SSPSTAT_bits.CKE
#define SMP                  SSPSTAT_bits.SMP

// ----- STATUS bits --------------------
typedef union {
  struct {
    unsigned char C:1;
    unsigned char DC:1;
    unsigned char Z:1;
    unsigned char NOT_PD:1;
    unsigned char NOT_TO:1;
    unsigned char RP0:1;
    unsigned char RP1:1;
    unsigned char IRP:1;
  };
} __STATUS_bits_t;
extern volatile __STATUS_bits_t __at(STATUS_ADDR) STATUS_bits;

#define C                    STATUS_bits.C
#define DC                   STATUS_bits.DC
#define Z                    STATUS_bits.Z
#define NOT_PD               STATUS_bits.NOT_PD
#define NOT_TO               STATUS_bits.NOT_TO
#define RP0                  STATUS_bits.RP0
#define RP1                  STATUS_bits.RP1
#define IRP                  STATUS_bits.IRP

// ----- T1CON bits --------------------
typedef union {
  struct {
    unsigned char TMR1ON:1;
    unsigned char TMR1CS:1;
    unsigned char NOT_T1SYNC:1;
    unsigned char T1OSCEN:1;
    unsigned char T1CKPS0:1;
    unsigned char T1CKPS1:1;
    unsigned char :1;
    unsigned char :1;
  };
  struct {
    unsigned char :1;
    unsigned char :1;
    unsigned char T1INSYNC:1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
    unsigned char :1;
  };
} __T1CON_bits_t;
extern volatile __T1CON_bits_t __at(T1CON_ADDR) T1CON_bits;

#define TMR1ON               T1CON_bits.TMR1ON
#define TMR1CS               T1CON_bits.TMR1CS
#define NOT_T1SYNC           T1CON_bits.NOT_T1SYNC
#define T1INSYNC             T1CON_bits.T1INSYNC
#define T1OSCEN              T1CON_bits.T1OSCEN
#define T1CKPS0              T1CON_bits.T1CKPS0
#define T1CKPS1              T1CON_bits.T1CKPS1

// ----- T2CON bits --------------------
typedef union {
  struct {
    unsigned char T2CKPS0:1;
    unsigned char T2CKPS1:1;
    unsigned char TMR2ON:1;
    unsigned char TOUTPS0:1;
    unsigned char TOUTPS1:1;
    unsigned char TOUTPS2:1;
    unsigned char TOUTPS3:1;
    unsigned char :1;
  };
} __T2CON_bits_t;
extern volatile __T2CON_bits_t __at(T2CON_ADDR) T2CON_bits;

#define T2CKPS0              T2CON_bits.T2CKPS0
#define T2CKPS1              T2CON_bits.T2CKPS1
#define TMR2ON               T2CON_bits.TMR2ON
#define TOUTPS0              T2CON_bits.TOUTPS0
#define TOUTPS1              T2CON_bits.TOUTPS1
#define TOUTPS2              T2CON_bits.TOUTPS2
#define TOUTPS3              T2CON_bits.TOUTPS3

// ----- TRISE bits --------------------
typedef union {
  struct {
    unsigned char TRISE0:1;
    unsigned char TRISE1:1;
    unsigned char TRISE2:1;
    unsigned char :1;
    unsigned char PSPMODE:1;
    unsigned char IBOV:1;
    unsigned char OBF:1;
    unsigned char IBF:1;
  };
} __TRISE_bits_t;
extern volatile __TRISE_bits_t __at(TRISE_ADDR) TRISE_bits;

#define TRISE0               TRISE_bits.TRISE0
#define TRISE1               TRISE_bits.TRISE1
#define TRISE2               TRISE_bits.TRISE2
#define PSPMODE              TRISE_bits.PSPMODE
#define IBOV                 TRISE_bits.IBOV
#define OBF                  TRISE_bits.OBF
#define IBF                  TRISE_bits.IBF

#endif
