/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.scriptio.ScriptReaderBase;

public class ScriptRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(Database database, String string, int n) throws HsqlException {
        Session session;
        IntKeyHashMap intKeyHashMap = new IntKeyHashMap();
        Session session2 = session = database.getSessionManager().getSysSession();
        int n2 = 0;
        database.setReferentialIntegrity(false);
        ScriptReaderBase scriptReaderBase = null;
        try {
            StopWatch stopWatch = new StopWatch();
            scriptReaderBase = ScriptReaderBase.newScriptReader(database, string, 0);
            while (scriptReaderBase.readLoggedStatement(session2)) {
                int n3 = scriptReaderBase.getSessionNumber();
                if (n2 != n3 && (session2 = (Session)intKeyHashMap.get(n2 = n3)) == null) {
                    session2 = database.getSessionManager().newSession(database, session.getUser(), false, true);
                    intKeyHashMap.put(n2, session2);
                }
                if (session2.isClosed()) {
                    intKeyHashMap.remove(n2);
                    continue;
                }
                Result result = null;
                switch (scriptReaderBase.getStatementType()) {
                    case 1: {
                        result = session2.sqlExecuteDirectNoPreChecks(scriptReaderBase.getLoggedStatement());
                        if (result == null || result.mode != 2) break;
                        if (result.getException() != null) {
                            throw result.getException();
                        }
                        throw Trace.error(result);
                    }
                    case 4: {
                        scriptReaderBase.getCurrentSequence().reset(scriptReaderBase.getSequenceValue());
                        break;
                    }
                    case 5: {
                        session2.commit();
                        break;
                    }
                    case 3: {
                        Object[] objectArray = scriptReaderBase.getData();
                        scriptReaderBase.getCurrentTable().insertNoCheckFromLog(session2, objectArray);
                        break;
                    }
                    case 2: {
                        Object[] objectArray = scriptReaderBase.getData();
                        scriptReaderBase.getCurrentTable().deleteNoCheckFromLog(session2, objectArray);
                        break;
                    }
                    case 7: {
                        session2.setSchema(scriptReaderBase.getCurrentSchema());
                    }
                }
                if (!session2.isClosed()) continue;
                intKeyHashMap.remove(n2);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                String string2 = "out of memory processing " + string + " line: " + scriptReaderBase.getLineNumber();
                database.logger.appLog.logContext(SimpleLog.LOG_ERROR, string2);
                throw Trace.error(72);
            }
            String string3 = string + " line: " + scriptReaderBase.getLineNumber() + " " + throwable.toString();
            database.logger.appLog.logContext(SimpleLog.LOG_ERROR, string3);
            Trace.printSystemOut(string3);
        }
        finally {
            if (scriptReaderBase != null) {
                scriptReaderBase.close();
            }
            database.getSessionManager().closeAllSessions();
            database.setReferentialIntegrity(true);
        }
    }
}

