/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.tools.debugger.AbstractTreeTableModel;
import org.mozilla.javascript.tools.debugger.TreeTableModel;
import org.mozilla.javascript.tools.debugger.VariableNode;

public class VariableModel
extends AbstractTreeTableModel
implements TreeTableModel {
    protected static String[] cNames = new String[]{" Name", " Value"};
    protected static Class[] cTypes = new Class[]{TreeTableModel.class, String.class};

    public VariableModel(Scriptable scriptable) {
        super(scriptable == null ? null : new VariableNode(scriptable, "this"));
    }

    protected Object getObject(Object object) {
        VariableNode variableNode = (VariableNode)object;
        if (variableNode == null) {
            return null;
        }
        return variableNode.getObject();
    }

    protected Object[] getChildren(Object object) {
        VariableNode variableNode = (VariableNode)object;
        return variableNode.getChildren();
    }

    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    public boolean isLeaf(Object object) {
        if (object == null) {
            return true;
        }
        VariableNode variableNode = (VariableNode)object;
        Object[] objectArray = variableNode.getChildren();
        return objectArray == null || objectArray.length <= 0;
    }

    public boolean isCellEditable(Object object, int n) {
        return n == 0;
    }

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int n) {
        return cNames[n];
    }

    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValueAt(Object object, int n) {
        Context context = Context.enter();
        try {
            Object object2 = this.getObject(object);
            switch (n) {
                case 0: {
                    VariableNode variableNode = (VariableNode)object;
                    String string = "";
                    if (variableNode.name != null) {
                        String string2 = string + variableNode.name;
                        return string2;
                    }
                    String string3 = string + "[" + variableNode.index + "]";
                    return string3;
                }
                case 1: {
                    String string;
                    if (object2 == Undefined.instance || object2 == ScriptableObject.NOT_FOUND) {
                        String string4 = "undefined";
                        return string4;
                    }
                    if (object2 == null) {
                        String string5 = "null";
                        return string5;
                    }
                    if (object2 instanceof NativeCall) {
                        String string6 = "[object Call]";
                        return string6;
                    }
                    try {
                        string = object2 instanceof BaseFunction ? ((BaseFunction)object2).decompile(context, 0, false) : Context.toString(object2);
                    }
                    catch (RuntimeException runtimeException) {
                        string = runtimeException.getMessage();
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    int n2 = string.length();
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n2) {
                            String string7 = stringBuffer.toString();
                            return string7;
                        }
                        char c = string.charAt(n3);
                        if (Character.isISOControl(c)) {
                            c = ' ';
                        }
                        stringBuffer.append(c);
                        ++n3;
                    }
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            context.exit();
        }
    }

    public void setScope(Scriptable scriptable) {
        VariableNode variableNode = (VariableNode)this.root;
        variableNode.scope = scriptable;
        this.fireTreeNodesChanged(this, new Object[]{this.root}, null, new Object[]{this.root});
    }
}

