/*
 *  Copyright (C) 2006  MakeHuman Project
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File   : Tooltip.h
 *  Project: MakeHuman <info@makehuman.org>, http://www.makehuman.org/
 *  Library: MHGUI
 *
 *  For individual developers look into the AUTHORS file.
 *   
 */

#ifndef TOOLTIP_H
#define TOOLTIP_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include <string>
#include <animorph/Color.h>
#include "Point.h"

using std::string;
using Animorph::Color;

namespace mhgui {

class Panel;

/* ========================================================================== */
/**
 */
/* ========================================================================== */
class Tooltip
{

public:
     Tooltip(const string&  inTooltipString, 
             const Point&   inPos, 
             const Color&   inColor, 
             const Panel   *inAnchor = NULL);

     Tooltip(const string&  inTooltipString, 
             const Point&   inPos, 
             const Panel   *inAnchor = NULL);

     Tooltip(const Tooltip&  inTooltip);

    ~Tooltip() {}

     Tooltip& operator=(const Tooltip&  inTooltip);

    void draw() const;

private:
    string       label;
    Point        pos;
    Color        color;
    const Panel *anchorPanel;
}; // class Tooltip

} // namespace mhgui

#endif // TOOLTIP_H
