/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;

public class ArtifactNotFoundException
extends AbstractArtifactResolutionException {
    private String downloadUrl;

    public ArtifactNotFoundException(String message, Artifact artifact) {
        this(message, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), null, artifact.getDownloadUrl());
    }

    protected ArtifactNotFoundException(String message, Artifact artifact, List remoteRepositories, Throwable t) {
        this(message, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), remoteRepositories, artifact.getDownloadUrl(), t);
    }

    public ArtifactNotFoundException(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, String downloadUrl, Throwable t) {
        super(ArtifactNotFoundException.constructMessage(message, groupId, artifactId, version, type, downloadUrl), groupId, artifactId, version, type, remoteRepositories, null, t);
        this.downloadUrl = downloadUrl;
    }

    private ArtifactNotFoundException(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, String downloadUrl) {
        super(ArtifactNotFoundException.constructMessage(message, groupId, artifactId, version, type, downloadUrl), groupId, artifactId, version, type, remoteRepositories, null);
        this.downloadUrl = downloadUrl;
    }

    private static String constructMessage(String message, String groupId, String artifactId, String version, String type, String downloadUrl) {
        StringBuffer sb = new StringBuffer(message);
        if (downloadUrl != null && !"pom".equals(type)) {
            sb.append(AbstractArtifactResolutionException.LS);
            sb.append(AbstractArtifactResolutionException.LS);
            sb.append("Try downloading the file manually from");
            sb.append(AbstractArtifactResolutionException.LS);
            sb.append("  ");
            sb.append(downloadUrl);
            sb.append(AbstractArtifactResolutionException.LS);
            sb.append("and install it using the command: ");
            sb.append(AbstractArtifactResolutionException.LS);
            sb.append("  m2 install:install-file -DgroupId=");
            sb.append(groupId);
            sb.append(" -DartifactId=");
            sb.append(artifactId);
            sb.append(" -Dversion=");
            sb.append(version);
            sb.append(" -Dpackaging=");
            sb.append(type);
            sb.append(" -Dfile=/path/to/file");
        }
        return sb.toString();
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }
}

