
/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: RuleSet.h,v 1.3 2006/09/10 22:40:37 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __RULESET_HH_FLAG__
#define __RULESET_HH_FLAG__

#include <fwbuilder/FWObject.h>
#include <fwbuilder/Rule.h>

namespace libfwbuilder
{

class RuleSet : public FWObject  
{
    private:
    
    protected:
    
    void   renumberRules();
        
    public:
    
    RuleSet();
    RuleSet(const FWObject *root,bool prepopulate);
    virtual ~RuleSet();
    
    DECLARE_FWOBJECT_SUBTYPE(RuleSet);
    
    Rule* getRuleByNum(int n);
    
    Rule* insertRuleAtTop();
    Rule* insertRuleBefore(int rule_n);
    
    Rule* appendRuleAfter(int rule_n);
    Rule* appendRuleAtBottom();
    
    bool  deleteRule(int rule_n);
    bool  deleteRule(Rule *r);
    
    bool  moveRuleUp(int rule_n);
    bool  moveRuleDown(int rule_n);
    bool  moveRule(int src_rule_n,int dst_rule_n);
    
    bool  disableRule(int rule_n);
    bool  enableRule(int rule_n);
    bool  isRuleDisabled(int rule_n);

    int  getRuleSetSize();
    
    virtual Rule*   createRule()  =0;
    
}; //__RULESET_HH_FLAG__

}

#endif

