/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.xml;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.namespace.Namespace;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.XMLHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XmlModuleDescriptorUpdater {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void update(URL srcURL, File destFile, Map resolvedRevisions, String status, String revision, Date pubdate) throws IOException, SAXException {
        XmlModuleDescriptorUpdater.update(null, srcURL, destFile, resolvedRevisions, status, revision, pubdate, null, false);
    }

    public static void update(Ivy ivy, URL srcURL, File destFile, Map resolvedRevisions, String status, String revision, Date pubdate, Namespace ns, boolean replaceInclude) throws IOException, SAXException {
        XmlModuleDescriptorUpdater.update(ivy, srcURL.openStream(), destFile, resolvedRevisions, status, revision, pubdate, ns, replaceInclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(Ivy ivy, InputStream in, File destFile, Map resolvedRevisions, String status, String revision, Date pubdate, Namespace ns, boolean replaceInclude) throws IOException, SAXException {
        if (destFile.getParentFile() != null) {
            destFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            XmlModuleDescriptorUpdater.update(ivy, in, fos, resolvedRevisions, status, revision, pubdate, ns, replaceInclude);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
            try {
                ((OutputStream)fos).close();
            }
            catch (IOException e) {}
        }
    }

    public static void update(final Ivy ivy, InputStream inStream, OutputStream outStream, final Map resolvedRevisions, final String status, final String revision, final Date pubdate, final Namespace ns, final boolean replaceInclude) throws IOException, SAXException {
        final PrintWriter out = new PrintWriter(outStream);
        BufferedInputStream in = new BufferedInputStream(inStream);
        in.mark(10000);
        XmlModuleDescriptorUpdater.copyHeader(in, out);
        in.reset();
        try {
            XMLHelper.parse(in, null, new DefaultHandler(){
                private String _organisation = null;
                private String _defaultConfMapping = null;
                private Boolean _confMappingOverride = null;
                private String _justOpen = null;
                private Stack _context = new Stack();

                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (this._justOpen != null) {
                        out.print(">");
                    }
                    this._context.push(qName);
                    if ("info".equals(qName)) {
                        this._organisation = this.substitute(ivy, attributes.getValue("organisation"));
                        out.print("<info organisation=\"" + this._organisation + "\" module=\"" + this.substitute(ivy, attributes.getValue("module")) + "\"");
                        if (revision != null) {
                            out.print(" revision=\"" + revision + "\"");
                        } else if (attributes.getValue("revision") != null) {
                            out.print(" revision=\"" + this.substitute(ivy, attributes.getValue("revision")) + "\"");
                        }
                        if (status != null) {
                            out.print(" status=\"" + status + "\"");
                        } else {
                            out.print(" status=\"" + this.substitute(ivy, attributes.getValue("status")) + "\"");
                        }
                        if (pubdate != null) {
                            out.print(" publication=\"" + Ivy.DATE_FORMAT.format(pubdate) + "\"");
                        } else if (attributes.getValue("publication") != null) {
                            out.print(" publication=\"" + this.substitute(ivy, attributes.getValue("publication")) + "\"");
                        }
                        List<String> stdAtts = Arrays.asList("organisation", "module", "revision", "status", "publication", "namespace");
                        if (attributes.getValue("namespace") != null) {
                            out.print(" namespace=\"" + this.substitute(ivy, attributes.getValue("namespace")) + "\"");
                        }
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            if (stdAtts.contains(attributes.getQName(i))) continue;
                            out.print(" " + attributes.getQName(i) + "=\"" + this.substitute(ivy, attributes.getValue(i)) + "\"");
                        }
                    } else {
                        if (replaceInclude && "include".equals(qName) && this._context.contains("configurations")) {
                            try {
                                URL url;
                                String fileName = this.substitute(ivy, attributes.getValue("file"));
                                if (fileName == null) {
                                    String urlStr = this.substitute(ivy, attributes.getValue("url"));
                                    url = new URL(urlStr);
                                } else {
                                    url = new File(fileName).toURL();
                                }
                                XMLHelper.parse(url, null, new DefaultHandler(this){
                                    boolean _first;
                                    private final /* synthetic */ 1 this$0;
                                    {
                                        this.this$0 = this$0;
                                        this._first = true;
                                    }

                                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                                        if ("configurations".equals(qName)) {
                                            String mappingOverride;
                                            String defaultconf = 1.access$100(this.this$0, 1.access$000(this.this$0), attributes.getValue("defaultconfmapping"));
                                            if (defaultconf != null) {
                                                1.access$202(this.this$0, defaultconf);
                                            }
                                            if ((mappingOverride = 1.access$100(this.this$0, 1.access$000(this.this$0), attributes.getValue("confmappingoverride"))) != null) {
                                                1.access$302(this.this$0, Boolean.valueOf(mappingOverride));
                                            }
                                        } else if ("conf".equals(qName)) {
                                            if (!this._first) {
                                                1.access$400(this.this$0).print("/>\n\t\t");
                                            } else {
                                                this._first = false;
                                            }
                                            1.access$400(this.this$0).print("<" + qName);
                                            for (int i = 0; i < attributes.getLength(); ++i) {
                                                1.access$400(this.this$0).print(" " + attributes.getQName(i) + "=\"" + 1.access$100(this.this$0, 1.access$000(this.this$0), attributes.getValue(i)) + "\"");
                                            }
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                Message.warn("exception occured while importing configurations: " + e.getMessage());
                                throw new SAXException(e);
                            }
                        }
                        if ("dependency".equals(qName)) {
                            out.print("<dependency");
                            String org = this.substitute(ivy, attributes.getValue("org"));
                            org = org == null ? this._organisation : org;
                            String module = this.substitute(ivy, attributes.getValue("name"));
                            String branch = this.substitute(ivy, attributes.getValue("branch"));
                            String revision2 = this.substitute(ivy, attributes.getValue("rev"));
                            ModuleRevisionId localMid = ModuleRevisionId.newInstance(org, module, branch, revision2);
                            ModuleRevisionId systemMid = ns == null ? localMid : ns.getToSystemTransformer().transform(localMid);
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                String attName = attributes.getQName(i);
                                if ("rev".equals(attName)) {
                                    String rev = (String)resolvedRevisions.get(systemMid);
                                    if (rev != null) {
                                        out.print(" rev=\"" + rev + "\"");
                                        continue;
                                    }
                                    out.print(" rev=\"" + systemMid.getRevision() + "\"");
                                    continue;
                                }
                                if ("org".equals(attName)) {
                                    out.print(" org=\"" + systemMid.getOrganisation() + "\"");
                                    continue;
                                }
                                if ("name".equals(attName)) {
                                    out.print(" name=\"" + systemMid.getName() + "\"");
                                    continue;
                                }
                                if ("branch".equals(attName)) {
                                    out.print(" branch=\"" + systemMid.getBranch() + "\"");
                                    continue;
                                }
                                out.print(" " + attName + "=\"" + this.substitute(ivy, attributes.getValue(attName)) + "\"");
                            }
                        } else if ("dependencies".equals(qName)) {
                            out.print("<" + qName);
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                out.print(" " + attributes.getQName(i) + "=\"" + this.substitute(ivy, attributes.getValue(i)) + "\"");
                            }
                            if (this._defaultConfMapping != null && attributes.getValue("defaultconfmapping") == null) {
                                out.print(" defaultconfmapping=\"" + this._defaultConfMapping + "\"");
                            }
                            if (this._confMappingOverride != null && attributes.getValue("confmappingoverride") == null) {
                                out.print(" confmappingoverride=\"" + this._confMappingOverride.toString() + "\"");
                            }
                        } else {
                            out.print("<" + qName);
                            for (int i = 0; i < attributes.getLength(); ++i) {
                                out.print(" " + attributes.getQName(i) + "=\"" + this.substitute(ivy, attributes.getValue(i)) + "\"");
                            }
                        }
                    }
                    this._justOpen = qName;
                }

                private String substitute(Ivy ivy2, String value) {
                    return ivy2 == null ? value : ivy2.substitute(value);
                }

                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this._justOpen != null) {
                        out.print(">");
                        this._justOpen = null;
                    }
                    for (int i = start; i < start + length; ++i) {
                        out.print(ch[i]);
                    }
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals(this._justOpen)) {
                        out.print("/>");
                    } else {
                        out.print("</" + qName + ">");
                    }
                    this._justOpen = null;
                    this._context.pop();
                }

                public void endDocument() throws SAXException {
                    out.print(LINE_SEPARATOR);
                    out.flush();
                    out.close();
                }

                public void warning(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void error(SAXParseException e) throws SAXException {
                    throw e;
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    throw e;
                }

                static /* synthetic */ Ivy access$000(1 x0) {
                    return x0.ivy;
                }

                static /* synthetic */ String access$100(1 x0, Ivy x1, String x2) {
                    return x0.substitute(x1, x2);
                }

                static /* synthetic */ String access$202(1 x0, String x1) {
                    x0._defaultConfMapping = x1;
                    return x0._defaultConfMapping;
                }

                static /* synthetic */ Boolean access$302(1 x0, Boolean x1) {
                    x0._confMappingOverride = x1;
                    return x0._confMappingOverride;
                }

                static /* synthetic */ PrintWriter access$400(1 x0) {
                    return x0.out;
                }
            }, new LexicalHandler(){

                public void endCDATA() throws SAXException {
                }

                public void endDTD() throws SAXException {
                }

                public void startCDATA() throws SAXException {
                }

                public void comment(char[] ch, int start, int length) throws SAXException {
                    StringBuffer comment = new StringBuffer();
                    comment.append(ch, start, length);
                    out.print("<!--");
                    out.print(comment.toString());
                    out.print("-->");
                }

                public void endEntity(String name) throws SAXException {
                }

                public void startEntity(String name) throws SAXException {
                }

                public void startDTD(String name, String publicId, String systemId) throws SAXException {
                }
            });
        }
        catch (ParserConfigurationException e) {
            IllegalStateException ise = new IllegalStateException("impossible to update Ivy files: parser problem");
            ise.initCause(e);
            throw ise;
        }
    }

    private static void copyHeader(InputStream in, PrintWriter out) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        String line = r.readLine();
        while (line != null) {
            int index = line.indexOf("<ivy-module");
            if (index != -1) {
                buf.append(line.substring(0, index));
                out.print(buf.toString());
                break;
            }
            buf.append(line).append(LINE_SEPARATOR);
            line = r.readLine();
        }
    }
}

