% BITAND  BITAND Bitwise Boolean And Operation
% 
% 
% Usage
%  
%  Performs a bitwise binary and operation on the two arguments and
%  returns the result.  The syntax for its use is
%  
%     y = bitand(a,b)
%  
%  where a and b are unsigned integer arrays.  The and operation
%  is performed using 32 bit unsigned intermediates.  Note that if a
%  or b is a scalar, then each element of the other array is anded with
%  that scalar.  Otherwise the two arrays must match in size.
%  


function y = bitand(a,b)
  if (isscalar(a))
    a = repmat(a,size(b));
  end
  if (isscalar(b))
    b = repmat(b,size(a));
  end
  if (any(size(a) ~= size(b)))
    error('Argument arrays must be the same size');
  end
  y = bin2int(int2bin(a,32) & int2bin(b,32));
  
  
