/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.ITemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredTextLineBreakingReader;

public class StructuredTextAnnotationHover
implements IAnnotationHover {
    private IDebugModelPresentation fDebugModelPresentation;
    private HTMLPrinter printer = new HTMLPrinter();

    private int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int markerLine;
            block6: {
                try {
                    markerLine = document.getLineOfOffset(position.getOffset());
                    if (line != markerLine) break block6;
                    return 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (markerLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String formatHoverText(String text, ISourceViewer sourceViewer) {
        String result = null;
        String lineDelim = new String();
        try {
            lineDelim = sourceViewer.getDocument().getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        Display display = sourceViewer.getTextWidget().getDisplay();
        text = StringUtils.convertToHTMLContent((String)text);
        StringReader textReader = new StringReader(text);
        GC gc = new GC((Drawable)display);
        try {
            try {
                StringBuffer buf = new StringBuffer();
                StructuredTextLineBreakingReader reader = new StructuredTextLineBreakingReader(textReader, gc, this.getHoverWidth(display));
                String line = reader.readLine();
                while (true) {
                    if (line == null) {
                        result = buf.toString();
                    }
                    if (buf.length() != 0) {
                        buf.append(lineDelim);
                    }
                    buf.append(line);
                    line = reader.readLine();
                }
            }
            catch (IOException exception) {
                Logger.logException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            gc.dispose();
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        gc.dispose();
        return result;
    }

    private String formatMultipleHoverText(List messages) {
        StringBuffer buffer = new StringBuffer();
        this.printer.addPageProlog(buffer);
        this.printer.addParagraph(buffer, SSEUIMessages.Multiple_errors);
        this.printer.startBulletList(buffer);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            this.printer.addBullet(buffer, this.printer.convertToHTMLContent((String)e.next()));
        }
        this.printer.endBulletList(buffer);
        this.printer.addPageEpilog(buffer);
        return buffer.toString();
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        IMarker marker = this.getMarker(sourceViewer, lineNumber);
        ArrayList<String> messages = new ArrayList<String>(marker == null ? 0 : 1);
        if (marker != null) {
            String text = marker.getAttribute("message", null);
            if (text != null) {
                messages.add(text);
            } else {
                try {
                    if (marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) {
                        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
                        IBreakpoint[] breakpoints = manager.getBreakpoints();
                        int i = 0;
                        while (i < breakpoints.length) {
                            IBreakpoint breakpoint = breakpoints[i];
                            if (breakpoint.getMarker().equals((Object)marker)) {
                                if (this.fDebugModelPresentation == null) {
                                    this.fDebugModelPresentation = DebugUITools.newDebugModelPresentation();
                                }
                                if ((text = this.fDebugModelPresentation.getText((Object)breakpoint)) != null) {
                                    messages.add(text);
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
        List temporaryAnnotations = this.getTemporaryAnnotationsForLine(sourceViewer, lineNumber);
        int i = 0;
        while (i < temporaryAnnotations.size()) {
            String message = ((Annotation)temporaryAnnotations.get(i)).getText();
            if (message != null) {
                boolean duplicated = false;
                int j = 0;
                while (j < messages.size()) {
                    duplicated = duplicated || messages.get(j).equals(message);
                    ++j;
                }
                if (!duplicated) {
                    messages.add(message);
                }
            } else {
                messages.add(((ITemporaryAnnotation)temporaryAnnotations.get(i)).toString());
            }
            ++i;
        }
        if (messages.size() > 1) {
            return this.formatMultipleHoverText(messages);
        }
        if (messages.size() > 0) {
            return this.formatHoverText(messages.get(0).toString(), sourceViewer);
        }
        return null;
    }

    private int getHoverWidth(Display display) {
        Rectangle displayBounds = display.getBounds();
        int hoverWidth = displayBounds.width - (display.getCursorLocation().x - displayBounds.x);
        if ((hoverWidth -= 12) < 200) {
            hoverWidth = 200;
        }
        return hoverWidth;
    }

    private IMarker getMarker(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<IMarker> exact = new ArrayList<IMarker>();
        ArrayList<IMarker> including = new ArrayList<IMarker>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!(o instanceof MarkerAnnotation)) continue;
            MarkerAnnotation a = (MarkerAnnotation)o;
            switch (this.compareRulerLine(model.getPosition((Annotation)a), document, line)) {
                case 1: {
                    exact.add(a.getMarker());
                    break;
                }
                case 2: {
                    including.add(a.getMarker());
                }
            }
        }
        return this.select(exact, including);
    }

    private List getTemporaryAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<ITemporaryAnnotation> exact = new ArrayList<ITemporaryAnnotation>();
        ArrayList<ITemporaryAnnotation> including = new ArrayList<ITemporaryAnnotation>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            ITemporaryAnnotation a;
            Position position;
            Object o = e.next();
            if (!(o instanceof ITemporaryAnnotation) || (position = model.getPosition((Annotation)(a = (ITemporaryAnnotation)o))) == null) continue;
            switch (this.compareRulerLine(position, document, line)) {
                case 1: {
                    exact.add(a);
                    break;
                }
                case 2: {
                    including.add(a);
                }
            }
        }
        return exact;
    }

    public void release() {
        if (this.fDebugModelPresentation != null) {
            this.fDebugModelPresentation.dispose();
        }
    }

    private IMarker select(List firstChoice, List secondChoice) {
        if (!firstChoice.isEmpty()) {
            return (IMarker)firstChoice.get(0);
        }
        if (!secondChoice.isEmpty()) {
            return (IMarker)secondChoice.get(0);
        }
        return null;
    }

    class HTMLPrinter {
        HTMLPrinter() {
        }

        void addBullet(StringBuffer buffer, String bullet) {
            if (bullet != null) {
                buffer.append("<li>");
                buffer.append(bullet);
                buffer.append("</li>");
            }
        }

        void addPageEpilog(StringBuffer buffer) {
            buffer.append("</font></body></html>");
        }

        void addPageProlog(StringBuffer buffer) {
            this.insertPageProlog(buffer, buffer.length());
        }

        void addParagraph(StringBuffer buffer, Reader paragraphReader) {
            if (paragraphReader != null) {
                this.addParagraph(buffer, this.read(paragraphReader));
            }
        }

        void addParagraph(StringBuffer buffer, String paragraph) {
            if (paragraph != null) {
                buffer.append("<p>");
                buffer.append(paragraph);
            }
        }

        void addSmallHeader(StringBuffer buffer, String header) {
            if (header != null) {
                buffer.append("<h5>");
                buffer.append(header);
                buffer.append("</h5>");
            }
        }

        String convertToHTMLContent(String content) {
            content = this.replace(content, '<', "&lt;");
            return this.replace(content, '>', "&gt;");
        }

        void endBulletList(StringBuffer buffer) {
            buffer.append("</ul>");
        }

        void insertPageProlog(StringBuffer buffer, int position) {
            buffer.insert(position, "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1>");
        }

        String read(Reader rd) {
            StringBuffer buffer = new StringBuffer();
            char[] readBuffer = new char[2048];
            try {
                int n = rd.read(readBuffer);
                while (n > 0) {
                    buffer.append(readBuffer, 0, n);
                    n = rd.read(readBuffer);
                }
                return buffer.toString();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        private String replace(String text, char c, String s) {
            int previous = 0;
            int current = text.indexOf(c, previous);
            if (current == -1) {
                return text;
            }
            StringBuffer buffer = new StringBuffer();
            while (current > -1) {
                buffer.append(text.substring(previous, current));
                buffer.append(s);
                previous = current + 1;
                current = text.indexOf(c, previous);
            }
            buffer.append(text.substring(previous));
            return buffer.toString();
        }

        void startBulletList(StringBuffer buffer) {
            buffer.append("<ul>");
        }
    }
}

