/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.commands.Command;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.BindingFault;
import org.eclipse.wst.wsdl.BindingInput;
import org.eclipse.wst.wsdl.BindingOperation;
import org.eclipse.wst.wsdl.BindingOutput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.actions.SmartRenameAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Binding;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11BindingMessageReference;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11BindingOperation;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Description;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11EndPoint;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Interface;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Message;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11MessageReference;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Operation;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11ParameterForPart;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Service;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.visitor.BindingRenamer;
import org.eclipse.wst.wsdl.ui.internal.visitor.MessageRenamer;
import org.eclipse.wst.wsdl.ui.internal.visitor.PortTypeRenamer;
import org.w3c.dom.Element;

public class W11RenameCommand
extends Command {
    protected WSDLBaseAdapter object;
    protected String newName = "";

    public W11RenameCommand(WSDLBaseAdapter object, String newName) {
        super(Messages.getString("_UI_ACTION_RENAME"));
        this.object = object;
        this.newName = newName;
    }

    public void execute() {
        if (this.object instanceof W11Description) {
            Definition definition = (Definition)this.object.getTarget();
            W11TopLevelElementCommand.ensureDefinition(definition);
            String ns = definition.getQName().getNamespaceURI();
            definition.setQName(new QName(ns, this.newName));
        } else if (this.object instanceof W11Service) {
            Service service = (Service)this.object.getTarget();
            String ns = service.getQName().getNamespaceURI();
            service.setQName(new QName(ns, this.newName));
        } else if (this.object instanceof W11EndPoint) {
            Port port = (Port)this.object.getTarget();
            port.setName(this.newName);
        } else if (this.object instanceof W11Binding) {
            Binding binding = (Binding)this.object.getTarget();
            String ns = binding.getQName().getNamespaceURI();
            binding.setQName(new QName(ns, this.newName));
        } else if (this.object instanceof W11Interface) {
            PortType portType = (PortType)this.object.getTarget();
            String ns = portType.getQName().getNamespaceURI();
            portType.setQName(new QName(ns, this.newName));
        } else if (this.object instanceof W11Operation) {
            Operation operation = (Operation)this.object.getTarget();
            SmartRenameAction action = new SmartRenameAction(operation, this.newName);
            this.renameOperationHelper(operation);
            action.run();
        } else if (this.object instanceof W11MessageReference) {
            WSDLElement element = (WSDLElement)((W11MessageReference)this.object).getTarget();
            this.renameIOFHelper(element);
        } else if (this.object instanceof W11Message) {
            Message message = (Message)((W11Message)this.object).getTarget();
            SmartRenameAction action = new SmartRenameAction(message, this.newName);
            action.run();
        } else if (this.object instanceof W11ParameterForPart) {
            Part part = (Part)((W11ParameterForPart)this.object).getTarget();
            SmartRenameAction action = new SmartRenameAction(part, this.newName);
            action.run();
        } else if (this.object instanceof W11BindingOperation) {
            BindingOperation bindingOperation = (BindingOperation)((W11BindingOperation)this.object).getTarget();
            bindingOperation.setName(this.newName);
            bindingOperation.getEOperation().setName(this.newName);
        } else if (this.object instanceof W11BindingMessageReference) {
            Notifier bindingMessageRef = ((W11BindingMessageReference)this.object).getTarget();
            if (bindingMessageRef instanceof BindingInput) {
                ((BindingInput)bindingMessageRef).setName(this.newName);
                ((BindingInput)bindingMessageRef).getEInput().setName(this.newName);
            } else if (bindingMessageRef instanceof BindingOutput) {
                ((BindingOutput)bindingMessageRef).setName(this.newName);
                ((BindingOutput)bindingMessageRef).getEOutput().setName(this.newName);
            } else if (bindingMessageRef instanceof BindingFault) {
                ((BindingFault)bindingMessageRef).setName(this.newName);
                ((BindingFault)bindingMessageRef).getEFault().setName(this.newName);
            }
        }
    }

    private void renameOperationHelper(Operation operation) {
        Definition definition = operation.getEnclosingDefinition();
        ComponentReferenceUtil util = new ComponentReferenceUtil(definition);
        Iterator it = util.getBindingOperations(operation).iterator();
        while (it.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)it.next();
            Element element = WSDLEditorUtil.getInstance().getElementForObject(bindingOperation);
            if (element == null) continue;
            element.setAttribute("name", this.newName);
        }
    }

    private void renameIOFHelper(WSDLElement object) {
        Definition definition = object.getEnclosingDefinition();
        ComponentReferenceUtil util = new ComponentReferenceUtil(definition);
        List list = null;
        list = object instanceof Input ? util.getBindingInputs((Input)object) : (object instanceof Output ? util.getBindingOutputs((Output)object) : util.getBindingFaults((Fault)object));
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object bindingObject = i.next();
                this.renameModelObjectHelper(bindingObject, this.newName);
            }
        }
        this.renameModelObjectHelper(object, this.newName);
    }

    private void renameModelObjectHelper(Object modelObject, String theNewName) {
        Element element = WSDLEditorUtil.getInstance().getElementForObject(modelObject);
        if (element != null) {
            element.setAttribute("name", theNewName);
        }
        if (modelObject instanceof Message) {
            MessageRenamer renamer = new MessageRenamer((WSDLElement)((Message)modelObject), theNewName);
            renamer.visitBindings();
        } else if (modelObject instanceof PortType) {
            PortTypeRenamer renamer = new PortTypeRenamer((WSDLElement)((PortType)modelObject), theNewName);
            renamer.visitBindings();
        } else if (modelObject instanceof Binding) {
            BindingRenamer renamer = new BindingRenamer((WSDLElement)((Binding)modelObject), theNewName);
            renamer.visitServices();
        }
    }
}

