/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.basic;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11AddPartAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetExistingElementAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetExistingTypeAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetNewElementAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetNewTypeAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Operation;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11DeleteCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11SetElementCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11SetTypeCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddFaultAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddOperationAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDeleteAction;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IOperation;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;
import org.eclipse.wst.wsdl.ui.internal.visitor.WSDLVisitorForParameters;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;

public class W11ParameterForPart
extends WSDLBaseAdapter
implements IParameter {
    protected Part getPart() {
        return (Part)this.target;
    }

    public String getName() {
        return this.getPart().getName();
    }

    public String getComponentName() {
        if (this.getPart().getElementDeclaration() != null) {
            return this.getPart().getElementDeclaration().getName();
        }
        if (this.getPart().getTypeDefinition() != null) {
            return this.getPart().getTypeDefinition().getName();
        }
        return "(no name specified)";
    }

    public String getComponentNameQualifier() {
        if (this.getPart().getElementDeclaration() != null) {
            return this.getPart().getElementDeclaration().getTargetNamespace();
        }
        if (this.getPart().getTypeDefinition() != null) {
            return this.getPart().getTypeDefinition().getTargetNamespace();
        }
        return "(no namespace specified)";
    }

    public String getPreview() {
        String preview = "";
        WSDLVisitorForParameters visitorForParameters = new WSDLVisitorForParameters();
        visitorForParameters.visitMessage((Message)this.getPart().eContainer());
        Iterator it = visitorForParameters.concreteComponents.iterator();
        while (it.hasNext()) {
            String stringItem = null;
            Object item = it.next();
            if (item instanceof XSDElementDeclaration) {
                XSDElementDeclaration xsdElement = (XSDElementDeclaration)item;
                if ((xsdElement = xsdElement.getResolvedElementDeclaration()).getTypeDefinition() != null) {
                    stringItem = xsdElement.getTypeDefinition().getName();
                }
            } else if (item instanceof XSDAttributeUse) {
                stringItem = ((XSDAttributeUse)item).getAttributeDeclaration().getName();
            } else if (item instanceof Part && ((Part)item).getTypeDefinition() != null) {
                stringItem = ((Part)item).getTypeDefinition().getName();
            }
            if (stringItem == null) continue;
            preview = String.valueOf(preview) + stringItem + ", ";
        }
        if (preview.length() - 2 > 0) {
            preview = preview.substring(0, preview.length() - 2);
        }
        return "(" + preview + ")";
    }

    public String[] getActions(Object object) {
        if (object instanceof MultiPageEditorPart) {
            IOperation operation = ((IMessageReference)this.getOwner()).getOwnerOperation();
            ArrayList<String> actions = new ArrayList<String>();
            actions.add(W11AddPartAction.ID);
            actions.add(ASDAddOperationAction.ID);
            actions.addAll(((W11Operation)operation).getValidInputOutpuActions());
            actions.add(ASDAddFaultAction.ID);
            actions.add("SUBMENU_START_ID: " + Messages.getString("_UI_ACTION_SET_TYPE"));
            actions.add(W11SetNewTypeAction.ID);
            actions.add(W11SetExistingTypeAction.ID);
            actions.add("SUBMENU_END_ID: ");
            actions.add("SUBMENU_START_ID: " + Messages.getString("_UI_ACTION_SET_ELEMENT"));
            actions.add(W11SetNewElementAction.ID);
            actions.add(W11SetExistingElementAction.ID);
            actions.add("SUBMENU_END_ID: ");
            actions.add(ASDDeleteAction.ID);
            actions.add("org.eclipse.wst.wsdl.ui.internal.asd.actions.ShowPropertiesViewAction");
            if (this.isReadOnly()) {
                actions.add("org.eclipse.wst.wsdl.ui.OpenInNewEditor");
            }
            String[] actionIDs = new String[actions.size()];
            int index = 0;
            while (index < actions.size()) {
                actionIDs[index] = (String)actions.get(index);
                ++index;
            }
            return actionIDs;
        }
        if (object instanceof ContentOutline) {
            String[] actionIDs = new String[]{W11AddPartAction.ID, ASDDeleteAction.ID};
            return actionIDs;
        }
        return new String[0];
    }

    public Command getDeleteCommand() {
        return new W11DeleteCommand(this);
    }

    public Object getOwner() {
        return this.owner;
    }

    public Image getImage() {
        return WSDLEditorPlugin.getInstance().getImage("icons/part_obj.gif");
    }

    public Image getSecondaryImage() {
        if (this.getPart().getElementDeclaration() != null) {
            return WSDLEditorPlugin.getInstance().getImage("icons/element_obj.gif");
        }
        if (this.getPart().getTypeDefinition() != null) {
            if (this.getPart().getTypeDefinition() instanceof XSDComplexTypeDefinition) {
                return WSDLEditorPlugin.getInstance().getImage("icons/complextype_obj.gif");
            }
            return WSDLEditorPlugin.getInstance().getImage("icons/simpletype_obj.gif");
        }
        return WSDLEditorPlugin.getInstance().getImage("icons/part_obj.gif");
    }

    public String getText() {
        return "part";
    }

    public ITreeElement[] getChildren() {
        return new ITreeElement[0];
    }

    public boolean hasChildren() {
        return false;
    }

    public ITreeElement getParent() {
        return null;
    }

    public Command getSetTypeCommand(String actionId) {
        return new W11SetTypeCommand((Part)this.getTarget(), actionId);
    }

    public Command getSetElementCommand(String actionId) {
        return new W11SetElementCommand((Part)this.getTarget(), actionId);
    }

    public boolean isType() {
        Part part = (Part)this.target;
        return part.getTypeDefinition() != null;
    }
}

