/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.task;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.common.BundleUtils;

public class CopyAxisJarCommand
extends AbstractDataModelOperation {
    public static String AXIS_RUNTIME_PLUGIN_ID = "org.apache.axis";
    public static String[] JARLIST = new String[]{"axis.jar", "commons-discovery-0.2.jar", "jaxrpc.jar", "saaj.jar", "wsdl4j-1.5.1.jar"};
    public static String COMMON_LOGGING_PLUGIN_ID = "org.apache.commons_logging";
    public static String COMMON_LOGGING_JAR = "commons-logging-1.0.4.jar";
    public static String PATH_TO_JARS_IN_PLUGIN = "lib/";
    private IProject project;
    private Boolean projectRestartRequired_ = Boolean.FALSE;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        ProgressUtils.report((IProgressMonitor)monitor, (String)AxisConsumptionUIMessages.PROGRESS_INFO_COPY_AXIS_CFG);
        if (J2EEUtils.isWebComponent((IProject)this.project)) {
            this.copyAxisJarsToProject(this.project, status, env, monitor);
        } else if (J2EEUtils.isJavaComponent((IProject)this.project)) {
            status = this.addAxisJarsToBuildPath(this.project, env, monitor);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
                return status;
            }
        } else {
            status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_WARN_NO_JAVA_NATURE);
            env.getStatusHandler().reportError(status);
            return status;
        }
        return status;
    }

    private void copyAxisJarsToProject(IProject project, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        IPath webModulePath = J2EEUtils.getWebContentPath((IProject)project);
        if (webModulePath == null) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_PROJECT_NOT_FOUND);
            env.getStatusHandler().reportError(status);
            return;
        }
        int i = 0;
        while (i < JARLIST.length) {
            this.copyIFile(AXIS_RUNTIME_PLUGIN_ID, "lib/" + JARLIST[i], webModulePath, "WEB-INF/lib/" + JARLIST[i++], status, env, monitor);
            if (status.getSeverity() != 4) continue;
            return;
        }
        this.copyIFile(COMMON_LOGGING_PLUGIN_ID, "lib/" + COMMON_LOGGING_JAR, webModulePath, "WEB-INF/lib/" + COMMON_LOGGING_JAR, status, env, monitor);
        if (status.getSeverity() == 4) {
            return;
        }
    }

    private void copyIFile(String pluginId, String source, IPath targetPath, String targetFile, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        IPath target = targetPath.append((IPath)new Path(targetFile));
        ProgressUtils.report((IProgressMonitor)monitor, (String)ConsumptionMessages.PROGRESS_INFO_COPYING_FILE);
        try {
            TransientResourceContext context = new TransientResourceContext();
            context.setOverwriteFilesEnabled(true);
            context.setCreateFoldersEnabled(true);
            context.setCheckoutFilesEnabled(true);
            URL sourceURL = BundleUtils.getURLFromBundle((String)pluginId, (String)source);
            IFile resource = ResourceUtils.getWorkspaceRoot().getFile(target);
            if (!resource.exists()) {
                IFile file = FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)sourceURL.openStream(), (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
                if (!this.projectRestartRequired_.booleanValue() && file.exists()) {
                    this.projectRestartRequired_ = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_FILECOPY, (Throwable)e);
            env.getStatusHandler().reportError(status);
        }
    }

    public IStatus addAxisJarsToBuildPath(IProject p, IEnvironment env, IProgressMonitor monitor) {
        String jarName;
        String[] jarNames = new String[JARLIST.length];
        int i = 0;
        while (i < JARLIST.length) {
            StringBuffer sb = new StringBuffer();
            sb.append(PATH_TO_JARS_IN_PLUGIN);
            sb.append(JARLIST[i]);
            jarNames[i] = jarName = sb.toString();
            ++i;
        }
        IStatus status = this.addJar(p, AXIS_RUNTIME_PLUGIN_ID, jarNames, env, monitor);
        if (status.getSeverity() == 4) {
            return status;
        }
        StringBuffer sb2 = new StringBuffer();
        sb2.append(PATH_TO_JARS_IN_PLUGIN);
        sb2.append(COMMON_LOGGING_JAR);
        jarName = sb2.toString();
        String[] jarNames2 = new String[]{jarName};
        status = this.addJar(p, COMMON_LOGGING_PLUGIN_ID, jarNames2, env, monitor);
        if (status.getSeverity() == 4) {
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus addJar(IProject webProject, String pluginId, String[] jarNames, IEnvironment env, IProgressMonitor monitor) {
        int i;
        IStatus status = Status.OK_STATUS;
        IJavaProject javaProject_ = null;
        IClasspathEntry[] oldClasspath = null;
        javaProject_ = JavaCore.create((IProject)webProject);
        try {
            oldClasspath = javaProject_.getRawClasspath();
        }
        catch (JavaModelException jme) {
            status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_BAD_BUILDPATH, (Throwable)jme);
            return status;
        }
        ArrayList<String> newJarNamesList = new ArrayList<String>();
        int k = 0;
        while (k < jarNames.length) {
            boolean found = false;
            i = 0;
            while (i < oldClasspath.length) {
                found = oldClasspath[i].getPath().toString().toLowerCase().endsWith(jarNames[k].toLowerCase());
                if (found) break;
                ++i;
            }
            if (!found) {
                newJarNamesList.add(jarNames[k]);
            }
            ++k;
        }
        if (newJarNamesList.size() > 0) {
            String[] newJarNames = newJarNamesList.toArray(new String[0]);
            IClasspathEntry[] newClasspath = new IClasspathEntry[oldClasspath.length + newJarNames.length];
            i = 0;
            while (i < oldClasspath.length) {
                newClasspath[i] = oldClasspath[i];
                ++i;
            }
            try {
                int m = 0;
                while (i < newClasspath.length) {
                    newClasspath[i] = JavaCore.newLibraryEntry((IPath)this.getTheJarPath(pluginId, newJarNames[m]), null, null);
                    ++m;
                    ++i;
                }
            }
            catch (CoreException e) {
                status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_BAD_BUILDPATH, (Throwable)e);
                return status;
            }
            try {
                javaProject_.setRawClasspath(newClasspath, monitor);
            }
            catch (JavaModelException e) {
                status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_BAD_BUILDPATH, (Throwable)e);
                return status;
            }
        }
        return status;
    }

    private IPath getTheJarPath(String pluginId, String theJar) throws CoreException {
        try {
            if (pluginId != null) {
                URL localURL = Platform.asLocalURL((URL)BundleUtils.getURLFromBundle((String)pluginId, (String)theJar));
                return new Path(localURL.getFile());
            }
            return new Path(theJar);
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.ws.axis.consumption.ui", 0, AxisConsumptionUIMessages.MSG_ERROR_BAD_BUILDPATH, (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.ws.axis.consumption.ui", 0, AxisConsumptionUIMessages.MSG_ERROR_BAD_BUILDPATH, (Throwable)e));
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public boolean getProjectRestartRequired() {
        return this.projectRestartRequired_;
    }
}

