/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.ServerDefinitionTypeAwareWizardFragment;
import org.eclipse.jst.server.generic.ui.internal.ServerTypeDefinitionServerDecorator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class GenericServerWizardFragment
extends ServerDefinitionTypeAwareWizardFragment {
    private GenericServerCompositeDecorator[] fDecorators;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public boolean isComplete() {
        GenericServer dl;
        IStatus status;
        ServerRuntime serverRuntime = this.getServerTypeDefinitionFor(this.getServer());
        if (serverRuntime == null) {
            return false;
        }
        IServerWorkingCopy server = this.getServer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (status = (dl = (GenericServer)server.loadAdapter((Class)clazz, null)).validate()) != null && status.isOK();
    }

    public void createContent(Composite parent, IWizardHandle handle) {
        IServerWorkingCopy server = this.getServer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericServer dl = (GenericServer)server.loadAdapter((Class)clazz, null);
        ServerRuntime definition = this.getServerTypeDefinitionFor(server);
        this.fDecorators = new GenericServerCompositeDecorator[1];
        this.fDecorators[0] = new ServerTypeDefinitionServerDecorator(definition, null, this.getWizard(), dl);
        new GenericServerComposite(parent, this.fDecorators);
    }

    private ServerRuntime getServerTypeDefinitionFor(IServerWorkingCopy server) {
        String id;
        GenericServerRuntime runtime;
        IRuntime iRuntime = server.getRuntime();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((runtime = (GenericServerRuntime)iRuntime.getAdapter((Class)clazz)) == null) {
            IRuntime wc = (IRuntime)this.getTaskModel().getObject("runtime");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((runtime = (GenericServerRuntime)wc.getAdapter((Class)clazz2)) == null) {
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                runtime = (GenericServerRuntime)wc.loadAdapter((Class)clazz3, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        if ((id = runtime.getRuntime().getRuntimeType().getId()) == null) {
            return null;
        }
        Map runtimeProperties = runtime.getServerInstanceProperties();
        ServerRuntime definition = this.getServerTypeDefinition(id, runtimeProperties);
        return definition;
    }

    private IServerWorkingCopy getServer() {
        IServerWorkingCopy server = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        return server;
    }

    private boolean isNameInUse(String name) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (!servers[i].equals(this.getServer().getOriginal()) && servers[i].getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String createName() {
        String name = GenericServerUIMessages.bind((String)GenericServerUIMessages.serverName, (Object)this.getServerTypeDefinitionFor(this.getServer()).getName());
        int suffix = 1;
        String suffixName = name;
        while (this.isNameInUse(suffixName)) {
            suffixName = String.valueOf(name) + " " + suffix;
            ++suffix;
        }
        return suffixName;
    }

    public void enter() {
        this.getServer().setName(this.createName());
        int i = 0;
        while (i < this.fDecorators.length) {
            if (this.fDecorators[i].validate()) {
                return;
            }
            ++i;
        }
    }

    public void exit() {
        int i = 0;
        while (i < this.fDecorators.length) {
            if (this.fDecorators[i].validate()) {
                return;
            }
            ++i;
        }
    }

    public String description() {
        String sName = this.getServerName();
        if (sName == null || sName.length() < 1) {
            sName = "Generic";
        }
        return GenericServerUIMessages.bind((String)GenericServerUIMessages.serverWizardDescription, (Object)sName);
    }

    private String getServerName() {
        if (this.getServer() != null && this.getServer().getRuntime() != null) {
            return this.getServer().getRuntime().getRuntimeType().getName();
        }
        return null;
    }

    public String title() {
        String sName = this.getServerName();
        if (sName == null || sName.length() < 1) {
            sName = "Generic";
        }
        return GenericServerUIMessages.bind((String)GenericServerUIMessages.serverWizardTitle, (Object)sName);
    }
}

