/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.symbols;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.rubypeople.rdt.internal.core.symbols.ISymbolFinder;
import org.rubypeople.rdt.internal.core.symbols.Symbol;
import org.rubypeople.rdt.internal.core.symbols.SymbolSchedulingRule;
import org.rubypeople.rdt.internal.core.util.IJobScheduler;

public class BlockingSymbolFinder
implements ISymbolFinder {
    private final ISymbolFinder delegate;
    private final IJobScheduler scheduler;

    public BlockingSymbolFinder(ISymbolFinder iSymbolFinder, IJobScheduler iJobScheduler) {
        this.delegate = iSymbolFinder;
        this.scheduler = iJobScheduler;
    }

    public Set find(Symbol symbol) {
        FindExactSymbolJob findExactSymbolJob = new FindExactSymbolJob(this.delegate, symbol);
        return ((FindSymbolJob)findExactSymbolJob).executeJob(this.scheduler);
    }

    public Set find(String string, int n) throws PatternSyntaxException {
        FindInexactSymbolJob findInexactSymbolJob = new FindInexactSymbolJob(this.delegate, string, n);
        return ((FindSymbolJob)findInexactSymbolJob).executeJob(this.scheduler);
    }

    private static abstract class FindSymbolJob
    extends Job {
        protected Set locations = new HashSet();
        private PatternSyntaxException exception;

        public FindSymbolJob(String string) {
            super(string);
            this.setPriority(10);
            this.setUser(true);
            this.setRule((ISchedulingRule)new SymbolSchedulingRule());
        }

        protected abstract Set find() throws PatternSyntaxException;

        private Set executeJob(IJobScheduler iJobScheduler) {
            try {
                iJobScheduler.execute((Job)this);
                if (this.exception != null) {
                    throw this.exception;
                }
            }
            catch (InterruptedException interruptedException) {}
            return this.locations;
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            try {
                this.locations = this.find();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.exception = patternSyntaxException;
            }
            return Status.OK_STATUS;
        }

        protected boolean propertiesEquals(Job job) {
            return this.getRule().equals(job.getRule()) && this.isSystem() == job.isSystem() && this.isUser() == job.isUser() && this.getPriority() == job.getPriority();
        }
    }

    public static class FindInexactSymbolJob
    extends FindSymbolJob {
        private final ISymbolFinder delegate;
        private final String regExp;
        private final int symbolType;

        public FindInexactSymbolJob(ISymbolFinder iSymbolFinder, String string, int n) {
            super("find " + string);
            this.delegate = iSymbolFinder;
            this.regExp = string;
            this.symbolType = n;
        }

        protected Set find() {
            return this.delegate.find(this.regExp, this.symbolType);
        }

        public boolean equals(Object object) {
            if (!(object instanceof FindInexactSymbolJob)) {
                return false;
            }
            FindInexactSymbolJob findInexactSymbolJob = (FindInexactSymbolJob)((Object)object);
            return this.delegate.equals(findInexactSymbolJob.delegate) && this.regExp.equals(findInexactSymbolJob.regExp) && this.symbolType == findInexactSymbolJob.symbolType && this.propertiesEquals(findInexactSymbolJob);
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class FindExactSymbolJob
    extends FindSymbolJob {
        private final ISymbolFinder delegate;
        private final Symbol symbol;

        public FindExactSymbolJob(ISymbolFinder iSymbolFinder, Symbol symbol) {
            super("find " + symbol);
            this.delegate = iSymbolFinder;
            this.symbol = symbol;
        }

        protected Set find() {
            return this.delegate.find(this.symbol);
        }

        public boolean equals(Object object) {
            if (!(object instanceof FindExactSymbolJob)) {
                return false;
            }
            FindExactSymbolJob findExactSymbolJob = (FindExactSymbolJob)((Object)object);
            return this.delegate.equals(findExactSymbolJob.delegate) && this.symbol.equals((Object)findExactSymbolJob.symbol) && this.propertiesEquals(findExactSymbolJob);
        }

        public int hashCode() {
            return 0;
        }
    }
}

