/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.cpcontainer;

import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jayasoft.ivyde.eclipse.IvyPlugin;

public class FileExtFilter
extends ViewerFilter {
    private String[] fTargetExtension;

    public FileExtFilter(String[] targetExtension) {
        this.fTargetExtension = targetExtension;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            int i = 0;
            if (i < this.fTargetExtension.length) {
                return ((IFile)element).getName().toLowerCase(Locale.ENGLISH).endsWith("." + this.fTargetExtension[i]);
            }
        }
        if (element instanceof IContainer) {
            try {
                IResource[] resources = ((IContainer)element).members();
                int i = 0;
                while (i < resources.length) {
                    if (this.select(viewer, parent, resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                IvyPlugin.log(e);
            }
        }
        return false;
    }
}

