/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.actions;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.view.DetailsView;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.IUpdate;

public class MarkerRulerAction
implements IEditorActionDelegate,
IUpdate,
MouseListener,
IMenuListener {
    IVerticalRulerInfo ruler;
    ITextEditor editor;
    ArrayList<IMarker> markers = new ArrayList();
    IAction action;

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        Control control;
        if (this.editor != null) {
            if (this.ruler != null && (control = this.ruler.getControl()) != null && !control.isDisposed()) {
                control.removeMouseListener((MouseListener)this);
            }
            if (this.editor instanceof ITextEditorExtension) {
                ((ITextEditorExtension)this.editor).removeRulerContextMenuListener((IMenuListener)this);
            }
        }
        if (targetEditor instanceof ITextEditor) {
            this.editor = (ITextEditor)targetEditor;
            if (this.editor instanceof ITextEditorExtension) {
                ((ITextEditorExtension)this.editor).addRulerContextMenuListener((IMenuListener)this);
            }
            this.ruler = (IVerticalRulerInfo)this.editor.getAdapter(IVerticalRulerInfo.class);
            if (this.ruler != null && (control = this.ruler.getControl()) != null && !control.isDisposed()) {
                control.addMouseListener((MouseListener)this);
            }
        } else {
            this.ruler = null;
            this.editor = null;
        }
    }

    public void run(IAction action) {
        this.action = action;
        this.obtainFindBugsMarkers();
        if (this.markers.size() <= 0) {
            MessageDialog.openError((Shell)this.editor.getSite().getShell(), (String)"Error Showing Bug Details", (String)"You must first select a FindBugs marker to view bug details.");
        } else {
            this.update();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void obtainFindBugsMarkers() {
        IMarker[] allMarkers;
        this.markers.clear();
        if (this.editor == null || this.ruler == null) {
            return;
        }
        IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IFile.class);
        try {
            allMarkers = resource.findMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 0);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Could not enumerate markers for resource " + resource.getName());
            return;
        }
        AbstractMarkerAnnotationModel model = this.getModel();
        IDocument document = this.getDocument();
        for (int i = 0; i < allMarkers.length; ++i) {
            if (!this.includesRulerLine(model.getMarkerPosition(allMarkers[i]), document)) continue;
            try {
                if (!allMarkers[i].getType().equals("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker")) continue;
                this.markers.add(allMarkers[i]);
                continue;
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)e), "Error inspecting markers to find FindBugs warnings");
            }
        }
    }

    public void update() {
        if (this.markers.size() > 0) {
            IMarker marker = this.markers.get(0);
            DetailsView.showMarker(marker);
        }
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.ruler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException x) {
                FindbugsPlugin.getDefault().logException((Exception)((Object)x), "Error getting marker line");
            }
        }
        return false;
    }

    protected AbstractMarkerAnnotationModel getModel() {
        IDocumentProvider provider = this.editor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.editor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.editor.getDocumentProvider();
        return provider.getDocument((Object)this.editor.getEditorInput());
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.action != null) {
            this.obtainFindBugsMarkers();
            this.action.setEnabled(this.markers.size() > 0);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            this.obtainFindBugsMarkers();
            if (this.markers.size() > 0) {
                this.update();
            }
        }
    }

    public void mouseUp(MouseEvent e) {
    }
}

