/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassQueue;
import org.apache.bcel.util.ClassSet;

public class TransitiveHull
extends EmptyVisitor {
    private ClassQueue _queue;
    private ClassSet _set;
    private ConstantPool _cp;
    private String[] _ignored = IGNORED;
    public static final String[] IGNORED = new String[]{"java[.].*", "javax[.].*", "sun[.].*", "sunw[.].*", "com[.]sun[.].*", "org[.]omg[.].*", "org[.]w3c[.].*", "org[.]xml[.].*", "net[.]jini[.].*"};

    public TransitiveHull(JavaClass clazz) {
        this._queue = new ClassQueue();
        this._queue.enqueue(clazz);
        this._set = new ClassSet();
        this._set.add(clazz);
    }

    public JavaClass[] getClasses() {
        return this._set.toArray();
    }

    public String[] getClassNames() {
        return this._set.getClassNames();
    }

    public void start() {
        while (!this._queue.empty()) {
            JavaClass clazz = this._queue.dequeue();
            this._cp = clazz.getConstantPool();
            new DescendingVisitor(clazz, this).visit();
        }
    }

    private void add(String class_name) {
        class_name = class_name.replace('/', '.');
        int i = 0;
        while (i < this._ignored.length) {
            if (Pattern.matches(this._ignored[i], class_name)) {
                return;
            }
            ++i;
        }
        try {
            JavaClass clazz = Repository.lookupClass(class_name);
            if (this._set.add(clazz)) {
                this._queue.enqueue(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Missing class: " + e.toString());
        }
    }

    public void visitConstantClass(ConstantClass cc) {
        String class_name = (String)cc.getConstantValue(this._cp);
        this.add(class_name);
    }

    private void checkType(Type type) {
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getBasicType();
        }
        if (type instanceof ObjectType) {
            this.add(((ObjectType)type).getClassName());
        }
    }

    private void visitRef(ConstantCP ccp, boolean method) {
        String class_name = ccp.getClass(this._cp);
        this.add(class_name);
        ConstantNameAndType cnat = (ConstantNameAndType)this._cp.getConstant(ccp.getNameAndTypeIndex(), (byte)12);
        String signature = cnat.getSignature(this._cp);
        if (method) {
            Type type = Type.getReturnType(signature);
            this.checkType(type);
            Type[] types = Type.getArgumentTypes(signature);
            int i = 0;
            while (i < types.length) {
                this.checkType(types[i]);
                ++i;
            }
        } else {
            this.checkType(Type.getType(signature));
        }
    }

    public void visitConstantMethodref(ConstantMethodref cmr) {
        this.visitRef(cmr, true);
    }

    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref cimr) {
        this.visitRef(cimr, true);
    }

    public void visitConstantFieldref(ConstantFieldref cfr) {
        this.visitRef(cfr, false);
    }

    public String[] getIgnored() {
        return this._ignored;
    }

    public void setIgnored(String[] v) {
        this._ignored = v;
    }

    public static void main(String[] argv) {
        try {
            if (argv.length == 0) {
                System.err.println("transitive: No input files specified");
            } else {
                JavaClass java_class = Repository.lookupClass(argv[0]);
                if (java_class == null) {
                    java_class = new ClassParser(argv[0]).parse();
                }
                TransitiveHull hull = new TransitiveHull(java_class);
                hull.start();
                System.out.println(Arrays.asList(hull.getClassNames()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

