/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.EnvEntry;
import java.util.Vector;

public class Environment
implements Cloneable {
    private static final int SIZE = 127;
    private static final int SLOTS = 3;
    private int size;
    private Vector[] table;
    private int elements = 0;

    public Environment(int size) {
        this.size = size;
        this.table = new Vector[size];
    }

    private Environment(Vector[] table) {
        this.size = table.length;
        this.table = table;
    }

    public Environment() {
        this(127);
    }

    private final int hashCode(String key) {
        return Math.abs(key.hashCode()) % this.size;
    }

    public void put(EnvEntry obj) {
        String key = obj.getHashKey();
        int hash = this.hashCode(key);
        Vector<EnvEntry> v = this.table[hash];
        ++this.elements;
        if (v == null) {
            this.table[hash] = v = new Vector<EnvEntry>(3);
        } else {
            try {
                int index = Environment.lookup(v, key);
                if (index >= 0) {
                    v.setElementAt(obj, index);
                    return;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        v.addElement(obj);
    }

    public EnvEntry get(String key) {
        EnvEntry entry = null;
        int hash = this.hashCode(key);
        Vector v = this.table[hash];
        if (v == null) {
            return null;
        }
        try {
            int index = Environment.lookup(v, key);
            if (index >= 0) {
                entry = (EnvEntry)v.elementAt(index);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return entry;
    }

    public void delete(String key) {
        int hash = this.hashCode(key);
        Vector v = this.table[hash];
        if (v == null) {
            return;
        }
        try {
            int index = Environment.lookup(v, key);
            if (index >= 0) {
                --this.elements;
                v.removeElementAt(index);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static final int lookup(Vector v, String key) throws ArrayIndexOutOfBoundsException {
        int len = v.size();
        int i = 0;
        while (i < len) {
            EnvEntry entry = (EnvEntry)v.elementAt(i);
            if (entry.getHashKey().equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Object clone() {
        Vector[] copy = new Vector[this.size];
        int i = 0;
        while (i < this.size) {
            if (this.table[i] != null) {
                copy[i] = (Vector)this.table[i].clone();
            }
            ++i;
        }
        return new Environment(copy);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            if (this.table[i] != null) {
                buf.append(this.table[i] + "\n");
            }
            ++i;
        }
        return buf.toString();
    }

    public EnvEntry[] getEntries() {
        EnvEntry[] entries = new EnvEntry[this.elements];
        int k = 0;
        int i = 0;
        while (i < this.size) {
            Vector v = this.table[i];
            if (v != null) {
                int len = v.size();
                try {
                    int j = 0;
                    while (j < len) {
                        entries[k++] = (EnvEntry)v.elementAt(j);
                        ++j;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return entries;
    }
}

