/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.ASTExpr;
import Mini.ASTFunDecl;
import Mini.EnvEntry;
import Mini.Environment;
import Mini.Function;
import Mini.MiniC;
import Mini.MiniParser;
import Mini.Node;
import Mini.Variable;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUSH;

public class ASTIdent
extends ASTExpr
implements Constants {
    private String name;
    private Variable reference;

    ASTIdent(int id2) {
        super(id2);
    }

    ASTIdent(MiniParser p, int id2) {
        super(p, id2);
    }

    public static Node jjtCreate(MiniParser p, int id2) {
        return new ASTIdent(p, id2);
    }

    public ASTIdent(String name, int type, int line, int column) {
        super(line, column, 10);
        this.name = name;
        this.type = type;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " = " + this.name;
    }

    public ASTExpr traverse(Environment env) {
        EnvEntry entry = env.get(this.name);
        if (entry == null) {
            MiniC.addError(this.line, this.column, "Undeclared identifier " + this.name);
        } else if (entry instanceof Function) {
            MiniC.addError(this.line, this.column, "Function " + this.name + " used as an identifier.");
        } else {
            this.reference = (Variable)entry;
        }
        return this;
    }

    public int eval(int expected) {
        ASTIdent ident = this.reference.getName();
        int t = ident.getType();
        this.is_simple = true;
        if (t == 15 && expected == 15) {
            this.type = 15;
        } else if (t == 15 && expected != 15) {
            ident.setType(expected);
            this.type = expected;
        } else if (t != 15 && expected == 15) {
            ident.setType(t);
            this.type = t;
        } else {
            this.type = t;
        }
        return this.type;
    }

    public void code(StringBuffer buf) {
        if (this.name.equals("TRUE")) {
            ASTFunDecl.push(buf, "1");
        } else if (this.name.equals("FALSE")) {
            ASTFunDecl.push(buf, "0");
        } else {
            ASTFunDecl.push(buf, this.name);
        }
    }

    public void byte_code(InstructionList il, MethodGen method, ConstantPoolGen cp) {
        if (this.name.equals("TRUE")) {
            il.append(new PUSH(cp, 1));
        } else if (this.name.equals("FALSE")) {
            il.append(new PUSH(cp, 0));
        } else {
            LocalVariableGen local_var = this.reference.getLocalVariable();
            il.append(new ILOAD(local_var.getIndex()));
        }
        ASTFunDecl.push();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

