/*
 * Decompiled with CFR 0.152.
 */
package Mini;

import Mini.ASTFunDecl;
import Mini.Environment;
import Mini.MiniC;
import Mini.MiniParser;
import Mini.MiniParserConstants;
import Mini.MiniParserTreeConstants;
import Mini.Node;
import Mini.SimpleNode;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUSH;

public class ASTExpr
extends SimpleNode
implements MiniParserConstants,
MiniParserTreeConstants,
Constants {
    protected int kind = -1;
    private int unop = -1;
    protected ASTExpr[] exprs;
    protected Environment env;
    protected int line;
    protected int column;
    protected boolean is_simple;
    protected int type = 15;

    ASTExpr(int id2) {
        super(id2);
    }

    ASTExpr(MiniParser p, int id2) {
        super(p, id2);
    }

    public static Node jjtCreate(MiniParser p, int id2) {
        return new ASTExpr(p, id2);
    }

    ASTExpr(int line, int column, int id2) {
        super(id2);
        this.line = line;
        this.column = column;
    }

    ASTExpr(int line, int column, int kind, int id2) {
        this(line, column, id2);
        this.kind = kind;
    }

    ASTExpr(ASTExpr[] children, int kind, int line, int column) {
        this(line, column, kind, 2);
        this.exprs = children;
    }

    public String toString() {
        int len;
        String op = "";
        int n = len = this.children != null ? this.children.length : 0;
        if (this.unop != -1) {
            op = tokenImage[this.unop];
        } else if (this.kind != -1) {
            op = tokenImage[this.kind];
        }
        return String.valueOf(jjtNodeName[this.id]) + "(" + op + ")[" + len + "]<" + TYPE_NAMES[this.type] + "> @" + this.line + ", " + this.column;
    }

    public void closeNode() {
        if (this.children != null) {
            this.exprs = new ASTExpr[this.children.length];
            System.arraycopy(this.children, 0, this.exprs, 0, this.children.length);
            this.children = null;
        }
    }

    public ASTExpr traverse(Environment env) {
        this.env = env;
        if (this.kind == -1 && this.unop == -1) {
            return this.exprs[0].traverse(env);
        }
        int i = 0;
        while (i < this.exprs.length) {
            this.exprs[i] = this.exprs[i].traverse(env);
            ++i;
        }
        return this;
    }

    public int eval(int expected) {
        int child_type = 15;
        this.is_simple = true;
        if (this.unop != -1) {
            if (this.unop == 28) {
                this.type = 10;
                child_type = 10;
            } else {
                this.type = 4;
                child_type = 4;
            }
        } else if (this.kind == 27 || this.kind == 28 || this.kind == 29 || this.kind == 30 || this.kind == 31) {
            this.type = 10;
            child_type = 10;
        } else if (this.kind == 25 || this.kind == 26) {
            this.type = 4;
            child_type = 4;
        } else {
            child_type = 10;
            this.type = 4;
        }
        int i = 0;
        while (i < this.exprs.length) {
            int t = this.exprs[i].eval(child_type);
            if (t != child_type) {
                MiniC.addError(this.exprs[i].getLine(), this.exprs[i].getColumn(), "Expression has not expected type " + TYPE_NAMES[child_type] + " but " + TYPE_NAMES[t] + ".");
            }
            this.is_simple = this.is_simple && this.exprs[i].isSimple();
            ++i;
        }
        return this.type;
    }

    private static final String toBool(String i) {
        return "(" + i + " != 0)";
    }

    private static final String toInt(String i) {
        return "((" + i + ")? 1 : 0)";
    }

    public void code(StringBuffer buf) {
        if (this.unop != -1) {
            this.exprs[0].code(buf);
            String top = ASTFunDecl.pop();
            if (this.unop == 28) {
                ASTFunDecl.push(buf, "-" + top);
            } else {
                ASTFunDecl.push(buf, "(" + top + " == 1)? 0 : 1)");
            }
        } else {
            this.exprs[0].code(buf);
            this.exprs[1].code(buf);
            String _body_int2 = ASTFunDecl.pop();
            String _body_int = ASTFunDecl.pop();
            switch (this.kind) {
                case 27: {
                    ASTFunDecl.push(buf, String.valueOf(_body_int) + " + " + _body_int2);
                    break;
                }
                case 28: {
                    ASTFunDecl.push(buf, String.valueOf(_body_int) + " - " + _body_int2);
                    break;
                }
                case 29: {
                    ASTFunDecl.push(buf, String.valueOf(_body_int) + " * " + _body_int2);
                    break;
                }
                case 31: {
                    ASTFunDecl.push(buf, String.valueOf(_body_int) + " / " + _body_int2);
                    break;
                }
                case 25: {
                    ASTFunDecl.push(buf, ASTExpr.toInt(String.valueOf(ASTExpr.toBool(_body_int)) + " && " + ASTExpr.toBool(_body_int2)));
                    break;
                }
                case 26: {
                    ASTFunDecl.push(buf, ASTExpr.toInt(String.valueOf(ASTExpr.toBool(_body_int)) + " || " + ASTExpr.toBool(_body_int2)));
                    break;
                }
                case 20: {
                    ASTFunDecl.push(buf, ASTExpr.toInt(String.valueOf(_body_int) + " == " + _body_int2));
                    break;
                }
                case 19: {
                    ASTFunDecl.push(buf, ASTExpr.toInt(String.valueOf(_body_int) + " <= " + _body_int2));
                    break;
                }
                case 18: {
                    ASTFunDecl.push(buf, ASTExpr.toInt(String.valueOf(_body_int) + " >= " + _body_int2));
                    break;
                }
                case 21: {
                    ASTFunDecl.push(buf, ASTExpr.toInt(String.valueOf(_body_int) + " != " + _body_int2));
                    break;
                }
                case 17: {
                    ASTFunDecl.push(buf, ASTExpr.toInt(String.valueOf(_body_int) + " < " + _body_int2));
                    break;
                }
                case 16: {
                    ASTFunDecl.push(buf, ASTExpr.toInt(String.valueOf(_body_int) + " > " + _body_int2));
                    break;
                }
                default: {
                    System.err.println("Ooops");
                }
            }
        }
    }

    public void byte_code(InstructionList il, MethodGen method, ConstantPoolGen cp) {
        this.exprs[0].byte_code(il, method, cp);
        if (this.unop != -1) {
            if (this.unop == 28) {
                il.append(InstructionConstants.INEG);
            } else {
                il.append(new PUSH(cp, 1));
                ASTFunDecl.push();
                il.append(InstructionConstants.IXOR);
                ASTFunDecl.pop();
            }
        } else {
            BranchHandle bh = null;
            this.exprs[1].byte_code(il, method, cp);
            switch (this.kind) {
                case 27: {
                    il.append(InstructionConstants.IADD);
                    ASTFunDecl.pop();
                    break;
                }
                case 28: {
                    il.append(InstructionConstants.ISUB);
                    ASTFunDecl.pop();
                    break;
                }
                case 29: {
                    il.append(InstructionConstants.IMUL);
                    ASTFunDecl.pop();
                    break;
                }
                case 31: {
                    il.append(InstructionConstants.IDIV);
                    ASTFunDecl.pop();
                    break;
                }
                case 25: {
                    il.append(InstructionConstants.IAND);
                    ASTFunDecl.pop();
                    break;
                }
                case 26: {
                    il.append(InstructionConstants.IOR);
                    ASTFunDecl.pop();
                    break;
                }
                case 20: {
                    bh = il.append(new IF_ICMPNE(null));
                    ASTFunDecl.pop(2);
                    break;
                }
                case 19: {
                    bh = il.append(new IF_ICMPGT(null));
                    ASTFunDecl.pop(2);
                    break;
                }
                case 18: {
                    bh = il.append(new IF_ICMPLT(null));
                    ASTFunDecl.pop(2);
                    break;
                }
                case 21: {
                    bh = il.append(new IF_ICMPEQ(null));
                    ASTFunDecl.pop(2);
                    break;
                }
                case 17: {
                    bh = il.append(new IF_ICMPGE(null));
                    ASTFunDecl.pop(2);
                    break;
                }
                case 16: {
                    bh = il.append(new IF_ICMPLE(null));
                    ASTFunDecl.pop(2);
                    break;
                }
                default: {
                    System.err.println("Ooops");
                }
            }
            switch (this.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    il.append(new PUSH(cp, 1));
                    BranchHandle g = il.append(new GOTO(null));
                    bh.setTarget(il.append(new PUSH(cp, 0)));
                    g.setTarget(il.append(InstructionConstants.NOP));
                    ASTFunDecl.push();
                    break;
                }
            }
        }
    }

    public boolean isSimple() {
        return this.is_simple;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public int getKind() {
        return this.kind;
    }

    public void setUnOp(int unop) {
        this.unop = unop;
    }

    public int getUnOp() {
        return this.unop;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public void setPosition(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.exprs != null) {
            int i = 0;
            while (i < this.exprs.length) {
                this.exprs[i].dump(String.valueOf(prefix) + " ");
                ++i;
            }
        }
    }
}

