/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.workflow.SourceSearcher;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class Filter {
    static SourceSearcher sourceSearcher;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$workflow$Filter$FilterCommandLine;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static int parsePriority(String argument) {
        int i = " HMLE".indexOf(argument);
        if (i == -1) {
            i = " 1234".indexOf(argument);
        }
        if (i == -1) {
            throw new IllegalArgumentException("Bad priority: " + argument);
        }
        return i;
    }

    public static void main(String[] args) throws Exception {
        Iterator<Object> i$;
        DetectorFactoryCollection.instance();
        FilterCommandLine commandLine = new FilterCommandLine();
        int argCount = commandLine.parse(args, 0, 2, "Usage: " + Filter.class.getName() + " [options] [<orig results> [<new results]] ");
        Project project = new Project();
        SortedBugCollection origCollection = new SortedBugCollection();
        if (argCount == args.length) {
            origCollection.readXML(System.in, project);
        } else {
            origCollection.readXML(args[argCount++], project);
        }
        boolean verbose = argCount < args.length;
        I18N i18n = I18N.instance();
        if (commandLine.categoryString != null) {
            BugCategory bugCategory;
            i$ = i18n.getBugCategoryObjects().iterator();
            while (i$.hasNext()) {
                bugCategory = (BugCategory)i$.next();
                if (!bugCategory.getAbbrev().equals(commandLine.categoryString)) continue;
                commandLine.categoryKey = bugCategory.getCategory();
                break;
            }
            if (commandLine.categoryKey == null) {
                i$ = i18n.getBugCategoryObjects().iterator();
                while (i$.hasNext()) {
                    bugCategory = (BugCategory)i$.next();
                    if (!bugCategory.getAbbrev().startsWith(commandLine.categoryString)) continue;
                    commandLine.categoryKey = bugCategory.getCategory();
                    break;
                }
            }
        }
        if (commandLine.designationString != null) {
            i$ = i18n.getUserDesignationKeys().iterator();
            while (i$.hasNext()) {
                String designationKey = (String)i$.next();
                if (!designationKey.startsWith(commandLine.designationString) && !i18n.getUserDesignation(designationKey).startsWith(commandLine.designationString)) continue;
                commandLine.designationKey = designationKey;
                break;
            }
        }
        SortedBugCollection resultCollection = origCollection.createEmptyCollectionWithMetadata();
        int passed = 0;
        int dropped = 0;
        resultCollection.setWithMessages(commandLine.withMessages);
        if (commandLine.hashChangedSpecified) {
            origCollection.computeBugHashes();
        }
        commandLine.adjustFilter(resultCollection);
        resultCollection.getProjectStats().clearBugCounts();
        sourceSearcher = new SourceSearcher(project);
        Iterator<BugInstance> i$2 = origCollection.getCollection().iterator();
        while (i$2.hasNext()) {
            BugInstance bug = i$2.next();
            if (commandLine.accept(bug)) {
                resultCollection.add(bug, false);
                if (bug.getLastVersion() == -1L) {
                    resultCollection.getProjectStats().addBug(bug);
                }
                ++passed;
                continue;
            }
            ++dropped;
        }
        if (verbose) {
            System.out.println(passed + " warnings passed through, " + dropped + " warnings dropped");
        }
        if (argCount == args.length) {
            if (!$assertionsDisabled && verbose) {
                throw new AssertionError();
            }
            resultCollection.writeXML(System.out, project);
        } else {
            resultCollection.writeXML(args[argCount++], project);
        }
    }

    static {
        $assertionsDisabled = !Filter.class.desiredAssertionStatus();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilterCommandLine
    extends CommandLine {
        public static final long MILLISECONDS_PER_DAY = 86400000L;
        Pattern className;
        Pattern bugPattern;
        public boolean notSpecified = false;
        public boolean not = false;
        long first;
        String firstAsString;
        long after;
        String afterAsString;
        long before;
        String beforeAsString;
        long last;
        String lastAsString;
        String fixedAsString;
        long present;
        String presentAsString;
        long absent;
        String absentAsString;
        String annotation;
        public boolean activeSpecified = false;
        public boolean active = false;
        public boolean withSource = false;
        public boolean withSourceSpecified = false;
        public boolean introducedByChange = false;
        public boolean introducedByChangeSpecified = false;
        public boolean removedByChange = false;
        public boolean removedByChangeSpecified = false;
        public boolean newCode = false;
        public boolean newCodeSpecified = false;
        public boolean hashChanged = false;
        public boolean hashChangedSpecified = false;
        public boolean removedCode = false;
        public boolean removedCodeSpecified = false;
        public boolean classified = false;
        public boolean classifiedSpecified = false;
        public boolean withMessagesSpecified = false;
        public boolean withMessages = false;
        public boolean serious = false;
        public boolean seriousSpecified = false;
        private Matcher includeFilter;
        private Matcher excludeFilter;
        String designationString;
        String designationKey;
        String categoryString;
        String categoryKey;
        int priority = 3;

        FilterCommandLine() {
            this.addSwitch("-not", "reverse (all) switches for the filter");
            this.addSwitchWithOptionalExtraPart("-withSource", "truth", "only warnings for switch source is available");
            this.addSwitchWithOptionalExtraPart("-hashChanged", "truth", "only warnings for which the stored hash is not the same as the calculated hash");
            this.addOption("-exclude", "filter file", "exclude bugs matching given filter");
            this.addOption("-include", "filter file", "include only bugs matching given filter");
            this.addOption("-annotation", "text", "allow only warnings containing this text in an annotation");
            this.addSwitchWithOptionalExtraPart("-classified", "truth", "allow only classified warnings");
            this.addSwitchWithOptionalExtraPart("-withMessages", "truth", "generated XML should contain textual messages");
            this.addSwitchWithOptionalExtraPart("-serious", "truth", "allow only warnings classified as serious");
            this.addOption("-after", "when", "allow only warnings that first occurred after this version");
            this.addOption("-before", "when", "allow only warnings that first occurred before this version");
            this.addOption("-first", "when", "allow only warnings that first occurred in this version");
            this.addOption("-last", "when", "allow only warnings that last occurred in this version");
            this.addOption("-fixed", "when", "allow only warnings that last occurred in the previous version (clobbers last)");
            this.addOption("-present", "when", "allow only warnings present in this version");
            this.addOption("-absent", "when", "allow only warnings absent in this version");
            this.addSwitchWithOptionalExtraPart("-active", "truth", "allow only warnings alive in the last sequence number");
            this.addSwitchWithOptionalExtraPart("-introducedByChange", "truth", "allow only warnings introduced by a change of an existing class");
            this.addSwitchWithOptionalExtraPart("-removedByChange", "truth", "allow only warnings removed by a change of a persisting class");
            this.addSwitchWithOptionalExtraPart("-newCode", "truth", "allow only warnings introduced by the addition of a new class");
            this.addSwitchWithOptionalExtraPart("-removedCode", "truth", "allow only warnings removed by removal of a class");
            this.addOption("-priority", "level", "allow only warnings with this priority or higher");
            this.addOption("-class", "pattern", "allow only bugs whose primary class name matches this pattern");
            this.addOption("-bugPattern", "pattern", "allow only bugs whose type matches this pattern");
            this.addOption("-category", "category", "allow only warnings with a category that starts with this string");
            this.addOption("-designation", "designation", "allow only warnings with this designation (e.g., -designation SHOULD_FIX)");
        }

        static long getVersionNum(Map<String, AppVersion> versions, SortedMap<Long, AppVersion> timeStamps, String val, boolean roundToLaterVersion, long numVersions) {
            if (val == null) {
                return -1L;
            }
            if (val.equals("last") || val.equals("lastVersion")) {
                return numVersions - 1L;
            }
            AppVersion v = versions.get(val);
            if (v != null) {
                return v.getSequenceNumber();
            }
            try {
                long time = 0L;
                time = val.endsWith("daysAgo") ? System.currentTimeMillis() - 86400000L * (long)Integer.parseInt(val.substring(0, val.length() - 7)) : Date.parse(val);
                return FilterCommandLine.getAppropriateSeq(timeStamps, time, roundToLaterVersion);
            }
            catch (Exception e) {
                try {
                    long version = Long.parseLong(val);
                    if (version < 0L) {
                        version = numVersions + version;
                    }
                    return version;
                }
                catch (NumberFormatException e1) {
                    throw new IllegalArgumentException(new StringBuffer().append("Could not interpret version specification of '").append(val).append("'").toString());
                }
            }
        }

        private static long getAppropriateSeq(SortedMap<Long, AppVersion> timeStamps, long when, boolean roundToLaterVersion) {
            if (roundToLaterVersion) {
                SortedMap<Long, AppVersion> geq = timeStamps.tailMap(new Long(when));
                if (geq.isEmpty()) {
                    return Long.MAX_VALUE;
                }
                return ((AppVersion)geq.get(geq.firstKey())).getSequenceNumber();
            }
            SortedMap<Long, AppVersion> leq = timeStamps.headMap(new Long(when));
            if (leq.isEmpty()) {
                return Long.MIN_VALUE;
            }
            return ((AppVersion)leq.get(leq.lastKey())).getSequenceNumber();
        }

        void adjustFilter(BugCollection collection) {
            HashMap<String, AppVersion> versions = new HashMap<String, AppVersion>();
            TreeMap<Long, AppVersion> timeStamps = new TreeMap<Long, AppVersion>();
            Iterator<AppVersion> i = collection.appVersionIterator();
            while (i.hasNext()) {
                AppVersion v = i.next();
                versions.put(v.getReleaseName(), v);
                timeStamps.put(new Long(v.getTimestamp()), v);
            }
            AppVersion v = collection.getCurrentAppVersion();
            versions.put(v.getReleaseName(), v);
            timeStamps.put(new Long(v.getTimestamp()), v);
            this.first = FilterCommandLine.getVersionNum(versions, timeStamps, this.firstAsString, true, v.getSequenceNumber());
            this.last = FilterCommandLine.getVersionNum(versions, timeStamps, this.lastAsString, true, v.getSequenceNumber());
            this.before = FilterCommandLine.getVersionNum(versions, timeStamps, this.beforeAsString, true, v.getSequenceNumber());
            this.after = FilterCommandLine.getVersionNum(versions, timeStamps, this.afterAsString, false, v.getSequenceNumber());
            this.present = FilterCommandLine.getVersionNum(versions, timeStamps, this.presentAsString, true, v.getSequenceNumber());
            this.absent = FilterCommandLine.getVersionNum(versions, timeStamps, this.absentAsString, true, v.getSequenceNumber());
            long fixed = FilterCommandLine.getVersionNum(versions, timeStamps, this.fixedAsString, true, v.getSequenceNumber());
            if (fixed >= 0L) {
                this.last = fixed - 1L;
            }
        }

        boolean accept(BugInstance bug) {
            boolean result = this.evaluate(bug);
            if (this.not) {
                return !result;
            }
            return result;
        }

        boolean evaluate(BugInstance bug) {
            if (this.includeFilter != null && !this.includeFilter.match(bug)) {
                return false;
            }
            if (this.excludeFilter != null && this.excludeFilter.match(bug)) {
                return false;
            }
            if (this.annotation != null && bug.getAnnotationText().indexOf(this.annotation) == -1) {
                return false;
            }
            if (bug.getPriority() > this.priority) {
                return false;
            }
            if (this.firstAsString != null && bug.getFirstVersion() != this.first) {
                return false;
            }
            if (this.afterAsString != null && bug.getFirstVersion() <= this.after) {
                return false;
            }
            if (this.beforeAsString != null && bug.getFirstVersion() >= this.before) {
                return false;
            }
            if (!(this.lastAsString == null && this.fixedAsString == null || this.last >= 0L && bug.getLastVersion() == this.last)) {
                return false;
            }
            if (this.presentAsString != null && !this.bugLiveAt(bug, this.present)) {
                return false;
            }
            if (this.absentAsString != null && this.bugLiveAt(bug, this.absent)) {
                return false;
            }
            if (this.activeSpecified && this.active != (bug.getLastVersion() == -1L)) {
                return false;
            }
            if (this.removedByChangeSpecified && bug.isRemovedByChangeOfPersistingClass() != this.removedByChange) {
                return false;
            }
            if (this.introducedByChangeSpecified && bug.isIntroducedByChangeOfExistingClass() != this.introducedByChange) {
                return false;
            }
            if (this.newCodeSpecified && this.newCode != (!bug.isIntroducedByChangeOfExistingClass() && bug.getFirstVersion() != 0L)) {
                return false;
            }
            if (this.removedCodeSpecified && this.removedCode != (!bug.isRemovedByChangeOfPersistingClass() && bug.getLastVersion() != -1L)) {
                return false;
            }
            if (this.bugPattern != null && !this.bugPattern.matcher(bug.getType()).find()) {
                return false;
            }
            if (this.className != null && !this.className.matcher(bug.getPrimaryClass().getClassName()).find()) {
                return false;
            }
            BugPattern thisBugPattern = bug.getBugPattern();
            if (this.categoryKey != null && thisBugPattern != null && !this.categoryKey.equals(thisBugPattern.getCategory())) {
                return false;
            }
            if (this.designationKey != null && !this.designationKey.equals(bug.getUserDesignationKey())) {
                return false;
            }
            if (this.withSourceSpecified && sourceSearcher.findSource(bug.getPrimarySourceLineAnnotation()) != this.withSource) {
                return false;
            }
            if (this.hashChangedSpecified && bug.isInstanceHashConsistent() == this.hashChanged) {
                return false;
            }
            if (this.classifiedSpecified && this.classified != this.isClassified(bug)) {
                return false;
            }
            if (this.seriousSpecified) {
                boolean thisOneIsSerious;
                Set<String> words = bug.getTextAnnotationWords();
                boolean bl = thisOneIsSerious = words.contains("BUG") && !words.contains("NOT_BUG") && !words.contains("HARMLESS");
                if (this.serious != thisOneIsSerious) {
                    return false;
                }
            }
            return true;
        }

        private boolean isClassified(BugInstance bug) {
            Set<String> words = bug.getTextAnnotationWords();
            return words.contains("BUG") || words.contains("NOT_BUG");
        }

        private boolean bugLiveAt(BugInstance bug, long now) {
            if (now < bug.getFirstVersion()) {
                return false;
            }
            return bug.getLastVersion() == -1L || bug.getLastVersion() >= now;
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            option = option.substring(1);
            if (optionExtraPart.length() == 0) {
                this.setField(option, true);
            } else {
                this.setField(option, TigerSubstitutes.parseBoolean(optionExtraPart));
            }
            this.setField(new StringBuffer().append(option).append("Specified").toString(), true);
        }

        private void setField(String fieldName, boolean value) {
            try {
                Field f = (class$edu$umd$cs$findbugs$workflow$Filter$FilterCommandLine == null ? (class$edu$umd$cs$findbugs$workflow$Filter$FilterCommandLine = Filter.class$("edu.umd.cs.findbugs.workflow.Filter$FilterCommandLine")) : class$edu$umd$cs$findbugs$workflow$Filter$FilterCommandLine).getField(fieldName);
                f.setBoolean(this, value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-priority")) {
                this.priority = Filter.parsePriority(argument);
            } else if (option.equals("-first")) {
                this.firstAsString = argument;
            } else if (option.equals("-last")) {
                this.lastAsString = argument;
            } else if (option.equals("-fixed")) {
                this.fixedAsString = argument;
            } else if (option.equals("-after")) {
                this.afterAsString = argument;
            } else if (option.equals("-before")) {
                this.beforeAsString = argument;
            } else if (option.equals("-present")) {
                this.presentAsString = argument;
            } else if (option.equals("-absent")) {
                this.absentAsString = argument;
            } else if (option.equals("-category")) {
                this.categoryString = argument;
            } else if (option.equals("-designation")) {
                this.designationString = argument;
            } else if (option.equals("-class")) {
                this.className = Pattern.compile(argument);
            } else if (option.equals("-bugPattern")) {
                this.bugPattern = Pattern.compile(argument);
            } else if (option.equals("-annotation")) {
                this.annotation = argument;
            } else if (option.equals("-include")) {
                try {
                    this.includeFilter = new edu.umd.cs.findbugs.filter.Filter(argument);
                }
                catch (FilterException e) {
                    throw new IllegalArgumentException(new StringBuffer().append("Error processing include file: ").append(argument).toString(), e);
                }
            } else if (option.equals("-exclude")) {
                try {
                    this.excludeFilter = new edu.umd.cs.findbugs.filter.Filter(argument);
                }
                catch (FilterException e) {
                    throw new IllegalArgumentException(new StringBuffer().append("Error processing include file: ").append(argument).toString(), e);
                }
            } else {
                throw new IllegalArgumentException(new StringBuffer().append("can't handle command line argument of ").append(option).toString());
            }
        }
    }
}

