/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import java.util.Iterator;

public class DefectDensity {
    private static void printRow(Object[] values) {
        Object[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Object s = arr$[i$];
            System.out.print(s);
            System.out.print("\t");
        }
        System.out.println();
    }

    public static double density(int bugs, int ncss) {
        if (ncss == 0) {
            return Double.NaN;
        }
        int bugsPer10KNCSS = 10000 * bugs / ncss;
        return (double)bugsPer10KNCSS / 10.0;
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 1 || args.length > 0 && "-help".equals(args[0])) {
            System.err.println("Usage: " + DefectDensity.class.getName() + " [<infile>]");
            System.exit(1);
        }
        Project project = new Project();
        SortedBugCollection origCollection = new SortedBugCollection();
        int argCount = 0;
        if (argCount == args.length) {
            origCollection.readXML(System.in, project);
        } else {
            origCollection.readXML(args[argCount], project);
        }
        ProjectStats stats = origCollection.getProjectStats();
        DefectDensity.printRow(new Object[]{"kind", "name", "density/KNCSS", "bugs", "NCSS"});
        double projectDensity = DefectDensity.density(stats.getTotalBugs(), stats.getCodeSize());
        DefectDensity.printRow(new Object[]{"project", origCollection.getCurrentAppVersion().getReleaseName(), new Double(projectDensity), new Integer(stats.getTotalBugs()), new Integer(stats.getCodeSize())});
        Iterator<PackageStats> i$ = stats.getPackageStats().iterator();
        while (i$.hasNext()) {
            double packageDensity;
            PackageStats p = i$.next();
            if (p.getTotalBugs() <= 4 || Double.isNaN(packageDensity = DefectDensity.density(p.getTotalBugs(), p.size())) || packageDensity < projectDensity) continue;
            DefectDensity.printRow(new Object[]{"package", p.getPackageName(), new Double(packageDensity), new Integer(p.getTotalBugs()), new Integer(p.size())});
            Iterator<PackageStats.ClassStats> i$2 = p.getClassStats().iterator();
            while (i$2.hasNext()) {
                double density;
                PackageStats.ClassStats c = i$2.next();
                if (c.getTotalBugs() <= 4 || Double.isNaN(density = DefectDensity.density(c.getTotalBugs(), c.size())) || density < packageDensity) continue;
                DefectDensity.printRow(new Object[]{"class", c.getName(), new Double(density), new Integer(c.getTotalBugs()), new Integer(c.size())});
            }
        }
    }
}

