/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ml;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitCamelCaseIdentifier {
    private String ident;

    public SplitCamelCaseIdentifier(String ident) {
        this.ident = ident;
    }

    public Collection<String> split() {
        String s = this.ident;
        HashSet<String> result = new HashSet<String>();
        while (s.length() > 0) {
            StringBuffer buf = new StringBuffer();
            char first = s.charAt(0);
            buf.append(first);
            int i = 1;
            if (s.length() > 1) {
                char c;
                boolean camelWord;
                if (Character.isLowerCase(first)) {
                    camelWord = true;
                } else {
                    char next = s.charAt(i++);
                    buf.append(next);
                    camelWord = Character.isLowerCase(next);
                }
                while (i < s.length() && !(Character.isUpperCase(c = s.charAt(i)) ? camelWord : !camelWord)) {
                    buf.append(c);
                    ++i;
                }
                if (!camelWord && i < s.length()) {
                    buf.deleteCharAt(buf.length() - 1);
                    --i;
                }
            }
            result.add(buf.toString().toLowerCase(Locale.US));
            s = s.substring(i);
        }
        return result;
    }
}

