/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.filter.AndMatcher;
import edu.umd.cs.findbugs.filter.BugMatcher;
import edu.umd.cs.findbugs.filter.ClassMatcher;
import edu.umd.cs.findbugs.filter.FieldMatcher;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.filter.LocalMatcher;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.MethodMatcher;
import edu.umd.cs.findbugs.filter.OrMatcher;
import edu.umd.cs.findbugs.filter.PriorityMatcher;
import edu.umd.cs.findbugs.util.Strings;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class Filter
extends OrMatcher {
    private static final boolean DEBUG = SystemProperties.getBoolean("filter.debug");

    public Filter(String fileName) throws IOException, FilterException {
        this.parse(fileName);
    }

    private void parse(String fileName) throws IOException, FilterException {
        Document filterDoc = null;
        try {
            SAXReader reader = new SAXReader();
            filterDoc = reader.read(new BufferedInputStream(new FileInputStream(fileName)));
        }
        catch (DocumentException e) {
            throw new FilterException("Couldn't parse filter file " + fileName, e);
        }
        int count = 1;
        Iterator i$ = filterDoc.selectNodes("/FindBugsFilter/Match").iterator();
        while (i$.hasNext()) {
            Object matchObj = i$.next();
            Element matchNode = (Element)matchObj;
            AndMatcher matchMatcher = new AndMatcher();
            ClassMatcher classMatcher = null;
            String classAttr = matchNode.valueOf("@class");
            if (!classAttr.equals("")) {
                classMatcher = new ClassMatcher(classAttr);
            } else {
                String classRegex = matchNode.valueOf("@classregex");
                if (!classRegex.equals("")) {
                    classMatcher = new ClassMatcher("~" + classRegex);
                }
            }
            if (classMatcher != null) {
                matchMatcher.addChild(classMatcher);
            }
            if (DEBUG) {
                System.out.println("Match node");
            }
            Iterator j = matchNode.elementIterator();
            while (j.hasNext()) {
                Element child = (Element)j.next();
                Matcher matcher = Filter.getMatcher(child);
                matchMatcher.addChild(matcher);
            }
            if (matchMatcher.numberChildren() == 0) {
                throw new IllegalArgumentException("Match element #" + count + " (starting at 1) is invalid in filter file " + fileName);
            }
            this.addChild(matchMatcher);
            ++count;
        }
        if (this.numberChildren() == 0) {
            throw new IllegalArgumentException("Could not find any /FindBugsFilter/Match nodes in filter file " + fileName);
        }
    }

    private static Matcher getMatcher(Element element) throws FilterException {
        String name = element.getName();
        if (name.equals("BugCode")) {
            return new BugMatcher(element.valueOf("@name"), "", "");
        }
        if (name.equals("Local")) {
            return new LocalMatcher(element.valueOf("@name"));
        }
        if (name.equals("BugPattern")) {
            return new BugMatcher("", element.valueOf("@name"), "");
        }
        if (name.equals("Bug")) {
            return new BugMatcher(element.valueOf("@code"), element.valueOf("@pattern"), element.valueOf("@category"));
        }
        if (name.equals("Priority")) {
            return new PriorityMatcher(element.valueOf("@value"));
        }
        if (name.equals("Class")) {
            Attribute nameAttr = element.attribute("name");
            if (nameAttr == null) {
                throw new FilterException("Missing name attribute in Class element");
            }
            return new ClassMatcher(nameAttr.getValue());
        }
        if (name.equals("Package")) {
            Attribute nameAttr = element.attribute("name");
            if (nameAttr == null) {
                throw new FilterException("Missing name attribute in Package element");
            }
            String pName = nameAttr.getValue();
            pName = pName.startsWith("~") ? pName : "~" + Strings.replace(pName, ".", "\\.");
            return new ClassMatcher(pName + "\\.[^.]+");
        }
        if (name.equals("Method")) {
            String nameValue;
            Attribute nameAttr = element.attribute("name");
            Attribute paramsAttr = element.attribute("params");
            Attribute returnsAttr = element.attribute("returns");
            if (nameAttr == null) {
                if (paramsAttr == null || returnsAttr == null) {
                    throw new FilterException("Method element must have eiter name or params and returnss attributes");
                }
                nameValue = "~.*";
            } else {
                nameValue = nameAttr.getValue();
            }
            if (!(paramsAttr == null && returnsAttr == null || paramsAttr != null && returnsAttr != null)) {
                throw new FilterException("Method element must have both params and returns attributes if either is used");
            }
            if (paramsAttr == null) {
                return new MethodMatcher(nameValue);
            }
            return new MethodMatcher(nameValue, paramsAttr.getValue(), returnsAttr.getValue());
        }
        if (name.equals("Field")) {
            String nameValue;
            Attribute nameAttr = element.attribute("name");
            Attribute typeAttr = element.attribute("type");
            if (nameAttr == null) {
                if (typeAttr == null) {
                    throw new FilterException("Field element must have either name or type attribute");
                }
                nameValue = "~.*";
            } else {
                nameValue = nameAttr.getValue();
            }
            if (typeAttr == null) {
                return new FieldMatcher(nameValue);
            }
            return new FieldMatcher(nameValue, typeAttr.getValue());
        }
        if (name.equals("Or")) {
            OrMatcher orMatcher = new OrMatcher();
            Iterator i = element.elementIterator();
            while (i.hasNext()) {
                orMatcher.addChild(Filter.getMatcher((Element)i.next()));
            }
            return orMatcher;
        }
        throw new FilterException("Unknown element: " + name);
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 1) {
                System.err.println("Usage: " + Filter.class.getName() + " <filename>");
                System.exit(1);
            }
            new Filter(argv[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

