/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.type.BottomType;
import edu.umd.cs.findbugs.ba.type.ExceptionObjectType;
import edu.umd.cs.findbugs.ba.type.ExceptionSet;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.ExtendedTypes;
import edu.umd.cs.findbugs.ba.type.TypeMerger;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class StandardTypeMerger
implements TypeMerger,
Constants,
ExtendedTypes {
    private RepositoryLookupFailureCallback lookupFailureCallback;
    private ExceptionSetFactory exceptionSetFactory;

    public StandardTypeMerger(RepositoryLookupFailureCallback lookupFailureCallback, ExceptionSetFactory exceptionSetFactory) {
        this.lookupFailureCallback = lookupFailureCallback;
        this.exceptionSetFactory = exceptionSetFactory;
    }

    public Type mergeTypes(Type a, Type b) throws DataflowAnalysisException {
        byte aType = a.getType();
        byte bType = b.getType();
        if (aType == 17) {
            return b;
        }
        if (bType == 17) {
            return a;
        }
        if (aType == 20 || bType == 20) {
            return BottomType.instance();
        }
        if (this.isReferenceType(aType) && this.isReferenceType(bType)) {
            if (aType == 21) {
                return b;
            }
            if (bType == 21) {
                return a;
            }
            ReferenceType aRef = (ReferenceType)a;
            ReferenceType bRef = (ReferenceType)b;
            return this.mergeReferenceTypes(aRef, bRef);
        }
        if (this.isReferenceType(aType) || this.isReferenceType(bType)) {
            return BottomType.instance();
        }
        if (aType == bType) {
            return a;
        }
        if (this.isIntegerType(aType) && this.isIntegerType(bType)) {
            return Type.INT;
        }
        return BottomType.instance();
    }

    protected boolean isReferenceType(byte type) {
        return type == 14 || type == 13 || type == 21 || type == 22;
    }

    protected boolean isObjectType(byte type) {
        return type == 14 || type == 22;
    }

    protected boolean isIntegerType(byte type) {
        return type == 10 || type == 8 || type == 4 || type == 5 || type == 9;
    }

    private static void updateExceptionSet(ExceptionSet exceptionSet, ObjectType type) {
        if (type instanceof ExceptionObjectType) {
            exceptionSet.addAll(((ExceptionObjectType)type).getExceptionSet());
        } else {
            exceptionSet.addExplicit(type);
        }
    }

    protected Type mergeReferenceTypes(ReferenceType aRef, ReferenceType bRef) throws DataflowAnalysisException {
        try {
            if (this.isObjectType(aRef.getType()) && this.isObjectType(bRef.getType()) && (aRef.getType() == 22 || bRef.getType() == 22)) {
                ExceptionSet union = this.exceptionSetFactory.createExceptionSet();
                StandardTypeMerger.updateExceptionSet(union, (ObjectType)aRef);
                StandardTypeMerger.updateExceptionSet(union, (ObjectType)bRef);
                return ExceptionObjectType.fromExceptionSet(union);
            }
            return aRef.getFirstCommonSuperclass(bRef);
        }
        catch (ClassNotFoundException e) {
            this.lookupFailureCallback.reportMissingClass(e);
            throw new MissingClassException(e);
        }
    }
}

