/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.InstanceField;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.Map;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsNullValueFrameModelingVisitor
extends AbstractFrameModelingVisitor<IsNullValue, IsNullValueFrame> {
    private static final boolean NO_ASSERT_HACK = SystemProperties.getBoolean("inva.noAssertHack");
    private AssertionMethods assertionMethods;
    private ValueNumberDataflow vnaDataflow;
    private final boolean trackValueNumbers;
    private int slotContainingNewNullValue;

    public IsNullValueFrameModelingVisitor(ConstantPoolGen cpg, AssertionMethods assertionMethods, ValueNumberDataflow vnaDataflow, boolean trackValueNumbers) {
        super(cpg);
        this.assertionMethods = assertionMethods;
        this.vnaDataflow = vnaDataflow;
        this.trackValueNumbers = trackValueNumbers;
    }

    @Override
    public void analyzeInstruction(Instruction ins) throws DataflowAnalysisException {
        this.slotContainingNewNullValue = -1;
        super.analyzeInstruction(ins);
    }

    public int getSlotContainingNewNullValue() {
        return this.slotContainingNewNullValue;
    }

    @Override
    public IsNullValue getDefaultValue() {
        return IsNullValue.nonReportingNotNullValue();
    }

    private void produce(IsNullValue value) {
        IsNullValueFrame frame = (IsNullValueFrame)this.getFrame();
        frame.pushValue(value);
        this.newValueOnTOS();
    }

    private void produce2(IsNullValue value) {
        IsNullValueFrame frame = (IsNullValueFrame)this.getFrame();
        frame.pushValue(value);
        frame.pushValue(value);
    }

    private void handleInvoke(InvokeInstruction obj) {
        ObjectType callType = obj.getLoadClassType(this.getCPG());
        Type returnType = obj.getReturnType(this.getCPG());
        String methodName = obj.getMethodName(this.getCPG());
        boolean stringMethodCall = ((Type)callType).equals(Type.STRING) && returnType.equals(Type.STRING);
        boolean isReadLine = methodName.equals("readLine");
        boolean modelCallReturnValue = returnType instanceof ReferenceType;
        if (!modelCallReturnValue) {
            this.handleNormalInstruction(obj);
        } else {
            NullnessAnnotation annotation;
            IsNullValue pushValue = null;
            XMethod calledMethod = XFactory.createXMethod(obj, this.getCPG());
            if (IsNullValueAnalysis.DEBUG) {
                System.out.println(new StringBuffer().append("Check ").append(calledMethod).append(" for null return...").toString());
            }
            if ((annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(calledMethod, false)) == NullnessAnnotation.CHECK_FOR_NULL) {
                if (IsNullValueAnalysis.DEBUG) {
                    System.out.println(new StringBuffer().append("Null value returned from ").append(calledMethod).toString());
                }
                pushValue = IsNullValue.nullOnSimplePathValue().markInformationAsComingFromReturnValueOfMethod(calledMethod);
            } else if (annotation == NullnessAnnotation.NONNULL) {
                if (IsNullValueAnalysis.DEBUG) {
                    System.out.println(new StringBuffer().append("NonNull value return from ").append(calledMethod).toString());
                }
                pushValue = IsNullValue.nonNullValue().markInformationAsComingFromReturnValueOfMethod(calledMethod);
            } else {
                pushValue = IsNullValue.nonReportingNotNullValue();
            }
            this.modelInstruction(obj, this.getNumWordsConsumed(obj), this.getNumWordsProduced(obj), pushValue);
            this.newValueOnTOS();
        }
        if (!NO_ASSERT_HACK && this.assertionMethods.isAssertionCall(obj)) {
            IsNullValueFrame frame = (IsNullValueFrame)this.getFrame();
            for (int i = 0; i < frame.getNumSlots(); ++i) {
                IsNullValue value = (IsNullValue)frame.getValue(i);
                if (!value.isDefinitelyNull() && !value.isNullOnSomePath()) continue;
                frame.setValue(i, IsNullValue.nonReportingNotNullValue());
            }
            for (Map.Entry<ValueNumber, IsNullValue> e : frame.getKnownValueMapEntrySet()) {
                IsNullValue value = e.getValue();
                if (!value.isDefinitelyNull() && !value.isNullOnSomePath()) continue;
                e.setValue(IsNullValue.nonReportingNotNullValue());
            }
        }
    }

    private void newValueOnTOS() {
        IsNullValueFrame frame = (IsNullValueFrame)this.getFrame();
        if (frame.getStackDepth() < 1) {
            return;
        }
        int tosSlot = frame.getNumSlots() - 1;
        IsNullValue tos = (IsNullValue)frame.getValue(tosSlot);
        if (tos.isDefinitelyNull()) {
            this.slotContainingNewNullValue = tosSlot;
        }
        if (this.trackValueNumbers) {
            try {
                ValueNumberFrame vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(this.getLocation());
                if (vnaFrameAfter.isValid()) {
                    ValueNumber tosVN = (ValueNumber)vnaFrameAfter.getTopValue();
                    ((IsNullValueFrame)this.getFrame()).setKnownValue(tosVN, tos);
                }
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("error", e);
            }
        }
    }

    @Override
    public void visitPUTFIELD(PUTFIELD obj) {
        if (this.getNumWordsConsumed(obj) != 2) {
            super.visitPUTFIELD(obj);
            return;
        }
        IsNullValue nullValueStored = null;
        try {
            nullValueStored = (IsNullValue)((IsNullValueFrame)this.getFrame()).getTopValue();
        }
        catch (DataflowAnalysisException e1) {
            AnalysisContext.logError("Oops", e1);
        }
        super.visitPUTFIELD(obj);
        InstanceField field = (InstanceField)XFactory.createXField(obj, this.cpg);
        if (nullValueStored != null) {
            try {
                ValueNumberFrame vnaFrameBefore = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(this.getLocation());
                ValueNumber refValue = (ValueNumber)vnaFrameBefore.getStackValue(1);
                AvailableLoad load = new AvailableLoad(refValue, field);
                ValueNumberFrame vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(this.getLocation());
                ValueNumber[] newValueNumbersForField = vnaFrameAfter.getAvailableLoad(load);
                if (newValueNumbersForField != null && this.trackValueNumbers) {
                    for (ValueNumber v : newValueNumbersForField) {
                        ((IsNullValueFrame)this.getFrame()).setKnownValue(v, nullValueStored);
                    }
                }
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("Oops", e);
            }
        }
    }

    @Override
    public void visitGETFIELD(GETFIELD obj) {
        if (this.getNumWordsProduced(obj) != 1) {
            super.visitGETFIELD(obj);
            return;
        }
        if (this.checkForKnownValue(obj)) {
            return;
        }
        XField field = XFactory.createXField(obj, this.cpg);
        NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(field, false);
        if (annotation == NullnessAnnotation.NONNULL) {
            this.modelNormalInstruction(obj, this.getNumWordsConsumed(obj), 0);
            this.produce(IsNullValue.nonNullValue());
        } else if (annotation == NullnessAnnotation.CHECK_FOR_NULL) {
            this.modelNormalInstruction(obj, this.getNumWordsConsumed(obj), 0);
            this.produce(IsNullValue.nullOnSimplePathValue());
        } else {
            super.visitGETFIELD(obj);
        }
    }

    @Override
    public void visitGETSTATIC(GETSTATIC obj) {
        if (this.getNumWordsProduced(obj) != 1) {
            super.visitGETSTATIC(obj);
            return;
        }
        if (this.checkForKnownValue(obj)) {
            return;
        }
        XField field = XFactory.createXField(obj, this.cpg);
        if (field.getName().startsWith("class$")) {
            this.produce(IsNullValue.nonNullValue());
            return;
        }
        NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(field, false);
        if (annotation == NullnessAnnotation.NONNULL) {
            this.modelNormalInstruction(obj, this.getNumWordsConsumed(obj), 0);
            this.produce(IsNullValue.nonNullValue());
        } else if (annotation == NullnessAnnotation.CHECK_FOR_NULL) {
            this.modelNormalInstruction(obj, this.getNumWordsConsumed(obj), 0);
            this.produce(IsNullValue.nullOnSimplePathValue());
        } else {
            super.visitGETSTATIC(obj);
        }
    }

    private boolean checkForKnownValue(Instruction obj) {
        if (this.trackValueNumbers) {
            try {
                ValueNumberFrame vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(this.getLocation());
                if (vnaFrameAfter.isValid()) {
                    ValueNumber tosVN = (ValueNumber)vnaFrameAfter.getTopValue();
                    IsNullValue knownValue = ((IsNullValueFrame)this.getFrame()).getKnownValue(tosVN);
                    if (knownValue != null) {
                        this.modelNormalInstruction(obj, this.getNumWordsConsumed(obj), 0);
                        this.produce(knownValue);
                        return true;
                    }
                }
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void visitACONST_NULL(ACONST_NULL obj) {
        this.produce(IsNullValue.nullValue());
    }

    @Override
    public void visitNEW(NEW obj) {
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitNEWARRAY(NEWARRAY obj) {
        this.modelNormalInstruction(obj, this.getNumWordsConsumed(obj), 0);
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitANEWARRAY(ANEWARRAY obj) {
        this.modelNormalInstruction(obj, this.getNumWordsConsumed(obj), 0);
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitMULTIANEWARRAY(MULTIANEWARRAY obj) {
        this.modelNormalInstruction(obj, this.getNumWordsConsumed(obj), 0);
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitLDC(LDC obj) {
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitLDC2_W(LDC2_W obj) {
        this.produce2(IsNullValue.nonNullValue());
    }

    @Override
    public void visitCHECKCAST(CHECKCAST obj) {
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        this.handleInvoke(obj);
    }

    @Override
    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.handleInvoke(obj);
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        this.handleInvoke(obj);
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        this.handleInvoke(obj);
    }

    @Override
    public /* synthetic */ Object getDefaultValue() {
        return this.getDefaultValue();
    }
}

