/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.XMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class SignatureConverter {
    private String signature;

    public SignatureConverter(String signature) {
        this.signature = signature;
    }

    public char getFirst() {
        return this.signature.charAt(0);
    }

    public void skip() {
        this.signature = this.signature.substring(1);
    }

    public String parseNext() {
        StringBuffer result = new StringBuffer();
        if (this.signature.startsWith("[")) {
            int dimensions = 0;
            do {
                ++dimensions;
                this.signature = this.signature.substring(1);
            } while (this.signature.charAt(0) == '[');
            result.append(this.parseNext());
            while (dimensions-- > 0) {
                result.append("[]");
            }
        } else if (this.signature.startsWith("L")) {
            int semi = this.signature.indexOf(59);
            if (semi < 0) {
                throw new IllegalStateException("missing semicolon in signature " + this.signature);
            }
            result.append(this.signature.substring(1, semi).replace('/', '.'));
            this.signature = this.signature.substring(semi + 1);
        } else {
            switch (this.signature.charAt(0)) {
                case 'B': {
                    result.append("byte");
                    break;
                }
                case 'C': {
                    result.append("char");
                    break;
                }
                case 'D': {
                    result.append("double");
                    break;
                }
                case 'F': {
                    result.append("float");
                    break;
                }
                case 'I': {
                    result.append("int");
                    break;
                }
                case 'J': {
                    result.append("long");
                    break;
                }
                case 'S': {
                    result.append("short");
                    break;
                }
                case 'Z': {
                    result.append("boolean");
                    break;
                }
                default: {
                    throw new IllegalStateException("bad signature " + this.signature);
                }
            }
            this.skip();
        }
        return result.toString();
    }

    public static String convertMethodSignature(JavaClass javaClass, Method method) {
        return SignatureConverter.convertMethodSignature(javaClass.getClassName(), method.getName(), method.getSignature());
    }

    public static String convertMethodSignature(MethodGen methodGen) {
        return SignatureConverter.convertMethodSignature(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public static String convertMethodSignature(InvokeInstruction inv, ConstantPoolGen cpg) {
        return SignatureConverter.convertMethodSignature(inv.getClassName(cpg), inv.getName(cpg), inv.getSignature(cpg));
    }

    public static String convertMethodSignature(String className, String methodName, String methodSig) {
        return SignatureConverter.convertMethodSignature(className, methodName, methodSig, "");
    }

    public static String convertMethodSignature(XMethod xmethod) {
        return SignatureConverter.convertMethodSignature(xmethod.getClassName(), xmethod.getName(), xmethod.getSignature());
    }

    public static String convertMethodSignature(String className, String methodName, String methodSig, String pkgName) {
        StringBuffer args = new StringBuffer();
        SignatureConverter converter = new SignatureConverter(methodSig);
        converter.skip();
        args.append('(');
        while (converter.getFirst() != ')') {
            if (args.length() > 1) {
                args.append(", ");
            }
            args.append(SignatureConverter.shorten(pkgName, converter.parseNext()));
        }
        converter.skip();
        args.append(')');
        StringBuffer result = new StringBuffer();
        result.append(className);
        result.append('.');
        result.append(methodName);
        result.append(args.toString());
        return result.toString();
    }

    public static String convert(String signature) {
        return new SignatureConverter(signature).parseNext();
    }

    public static String shorten(String pkgName, String typeName) {
        String otherPkg;
        int index = typeName.lastIndexOf(46);
        if (index >= 0 && ((otherPkg = typeName.substring(0, index)).equals(pkgName) || otherPkg.equals("java.lang"))) {
            typeName = typeName.substring(index + 1);
        }
        return typeName;
    }
}

