/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnnotationRetentionDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnAnnotationDatabase;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.InnerClassAccessMap;
import edu.umd.cs.findbugs.ba.JCIPAnnotationDatabase;
import edu.umd.cs.findbugs.ba.LegacyAnalysisContext;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.ch.Subtypes;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.detect.UnreadFields;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.Repository;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class AnalysisContext {
    public static final boolean DEBUG = SystemProperties.getBoolean("findbugs.analysiscontext.debug");
    public static final String DEFAULT_NONNULL_PARAM_DATABASE_FILENAME = "nonnullParam.db";
    public static final String DEFAULT_CHECK_FOR_NULL_PARAM_DATABASE_FILENAME = "checkForNullParam.db";
    public static final String DEFAULT_NULL_RETURN_VALUE_ANNOTATION_DATABASE = "nonnullReturn.db";
    public static final String UNCONDITIONAL_DEREF_DB_FILENAME = "unconditionalDeref.db";
    public static final String UNCONDITIONAL_DEREF_DB_RESOURCE = "jdkBaseUnconditionalDeref.db";
    public static final String DEFAULT_NULL_RETURN_VALUE_DB_FILENAME = "mayReturnNull.db";
    private static InheritableThreadLocal<AnalysisContext> currentAnalysisContext = new InheritableThreadLocal();
    private static InheritableThreadLocal<XFactory> currentXFactory = new InheritableThreadLocal<XFactory>(){

        @Override
        public XFactory initialValue() {
            return new XFactory();
        }

        @Override
        public /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    };
    private static final Repository originalRepository = org.apache.bcel.Repository.getRepository();
    private static final int DEFAULT_CACHE_SIZE = 3;
    private BitSet boolPropertySet = new BitSet();
    private Map<Object, Object> analysisLocals = Collections.synchronizedMap(new HashMap());
    private String databaseInputDir;
    private String databaseOutputDir;
    UnreadFields unreadFields;
    boolean missingClassWarningsSuppressed = false;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$interproc$PropertyDatabase;

    public abstract NullnessAnnotationDatabase getNullnessAnnotationDatabase();

    public abstract CheckReturnAnnotationDatabase getCheckReturnAnnotationDatabase();

    public abstract AnnotationRetentionDatabase getAnnotationRetentionDatabase();

    public abstract JCIPAnnotationDatabase getJCIPAnnotationDatabase();

    protected AnalysisContext() {
    }

    public static AnalysisContext create(RepositoryLookupFailureCallback lookupFailureCallback) {
        LegacyAnalysisContext analysisContext = new LegacyAnalysisContext(lookupFailureCallback);
        AnalysisContext.setCurrentAnalysisContext(analysisContext);
        return analysisContext;
    }

    public abstract void initDatabases();

    public abstract void updateDatabases(int var1);

    public static AnalysisContext currentAnalysisContext() {
        return (AnalysisContext)currentAnalysisContext.get();
    }

    public static XFactory currentXFactory() {
        return (XFactory)currentXFactory.get();
    }

    public UnreadFields getUnreadFields() {
        if (this.unreadFields == null) {
            throw new IllegalStateException("UnreadFields detector not set");
        }
        return this.unreadFields;
    }

    public void setUnreadFields(@NonNull UnreadFields unreadFields) {
        if (this.unreadFields != null) {
            throw new IllegalStateException("UnreadFields detector already set");
        }
        this.unreadFields = unreadFields;
    }

    public static void reportMissingClass(ClassNotFoundException e) {
        AnalysisContext currentAnalysisContext2 = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext2 == null) {
            return;
        }
        if (currentAnalysisContext2.missingClassWarningsSuppressed) {
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = currentAnalysisContext2.getLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.reportMissingClass(e);
        }
    }

    public static void logError(String msg, Exception e) {
        AnalysisContext currentAnalysisContext2 = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext2 == null) {
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = currentAnalysisContext2.getLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.logError(msg, e);
        }
    }

    public static void logError(String msg) {
        AnalysisContext currentAnalysisContext2 = AnalysisContext.currentAnalysisContext();
        if (currentAnalysisContext2 == null) {
            return;
        }
        RepositoryLookupFailureCallback lookupFailureCallback = currentAnalysisContext2.getLookupFailureCallback();
        if (lookupFailureCallback != null) {
            lookupFailureCallback.logError(msg);
        }
    }

    public boolean setMissingClassWarningsSuppressed(boolean value) {
        boolean oldValue = this.missingClassWarningsSuppressed;
        this.missingClassWarningsSuppressed = value;
        return oldValue;
    }

    public abstract RepositoryLookupFailureCallback getLookupFailureCallback();

    public final void setSourcePath(List<String> sourcePath) {
        this.getSourceFinder().setSourceBaseList(sourcePath);
    }

    public abstract SourceFinder getSourceFinder();

    public abstract Subtypes getSubtypes();

    public abstract void clearRepository();

    public abstract void clearClassContextCache();

    public abstract void addClasspathEntry(String var1) throws IOException;

    public abstract void addApplicationClassToRepository(JavaClass var1);

    public boolean isApplicationClass(JavaClass cls) {
        return this.getSubtypes().isApplicationClass(cls);
    }

    public boolean isApplicationClass(String className) {
        try {
            JavaClass javaClass = this.lookupClass(className);
            return this.isApplicationClass(javaClass);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    public abstract JavaClass lookupClass(@NonNull String var1) throws ClassNotFoundException;

    public JavaClass lookupClass(@NonNull ClassDescriptor classDescriptor) throws ClassNotFoundException {
        return this.lookupClass(classDescriptor.toDottedClassName());
    }

    public static JavaClass lookupSystemClass(@NonNull String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (originalRepository == null) {
            throw new IllegalStateException("originalRepository is null");
        }
        JavaClass clazz = originalRepository.findClass(className);
        return clazz == null ? originalRepository.loadClass(className) : clazz;
    }

    public final String lookupSourceFile(@NonNull String className) {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        try {
            JavaClass jc = this.lookupClass(className);
            String name = jc.getSourceFileName();
            if (name == null) {
                System.out.println(new StringBuffer().append("No sourcefile for ").append(className).toString());
                return "<Unknown>";
            }
            return name;
        }
        catch (ClassNotFoundException cnfe) {
            return "<Unknown>";
        }
    }

    public abstract ClassContext getClassContext(JavaClass var1);

    public abstract String getClassContextStats();

    public final void loadInterproceduralDatabases() {
        this.loadPropertyDatabase(this.getFieldStoreTypeDatabase(), "fieldStoreTypes.db", "field store type database");
        this.loadPropertyDatabase(this.getUnconditionalDerefParamDatabase(), UNCONDITIONAL_DEREF_DB_FILENAME, "unconditional param deref database");
    }

    public final void loadDefaultInterproceduralDatabases() {
        this.loadPropertyDatabaseFromResource(this.getUnconditionalDerefParamDatabase(), UNCONDITIONAL_DEREF_DB_RESOURCE, "unconditional param deref database");
    }

    public final void setBoolProperty(int prop, boolean value) {
        this.boolPropertySet.set(prop, value);
    }

    public final boolean getBoolProperty(int prop) {
        return this.boolPropertySet.get(prop);
    }

    public abstract SourceInfoMap getSourceInfoMap();

    public final void setDatabaseInputDir(String databaseInputDir) {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Setting database input directory: ").append(databaseInputDir).toString());
        }
        this.databaseInputDir = databaseInputDir;
    }

    public final String getDatabaseInputDir() {
        return this.databaseInputDir;
    }

    public final void setDatabaseOutputDir(String databaseOutputDir) {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Setting database output directory: ").append(databaseOutputDir).toString());
        }
        this.databaseOutputDir = databaseOutputDir;
    }

    public final String getDatabaseOutputDir() {
        return this.databaseOutputDir;
    }

    public abstract FieldStoreTypeDatabase getFieldStoreTypeDatabase();

    public abstract ParameterNullnessPropertyDatabase getUnconditionalDerefParamDatabase();

    public <DatabaseType extends PropertyDatabase<KeyType, Property>, KeyType extends ClassMember, Property> DatabaseType loadPropertyDatabase(DatabaseType database, String fileName, String description) {
        try {
            File dbFile = new File(this.getDatabaseInputDir(), fileName);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Loading ").append(description).append(" from ").append(dbFile.getPath()).append("...").toString());
            }
            database.readFromFile(dbFile.getPath());
            return database;
        }
        catch (IOException e) {
            this.getLookupFailureCallback().logError(new StringBuffer().append("Error loading ").append(description).toString(), e);
        }
        catch (PropertyDatabaseFormatException e) {
            this.getLookupFailureCallback().logError(new StringBuffer().append("Invalid ").append(description).toString(), e);
        }
        return null;
    }

    public <DatabaseType extends PropertyDatabase<KeyType, Property>, KeyType extends ClassMember, Property> DatabaseType loadPropertyDatabaseFromResource(DatabaseType database, String resourceName, String description) {
        try {
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Loading default ").append(description).append(" from ").append(resourceName).append(" @ ").append((class$edu$umd$cs$findbugs$ba$interproc$PropertyDatabase == null ? (class$edu$umd$cs$findbugs$ba$interproc$PropertyDatabase = AnalysisContext.class$("edu.umd.cs.findbugs.ba.interproc.PropertyDatabase")) : class$edu$umd$cs$findbugs$ba$interproc$PropertyDatabase).getResource(resourceName)).append(" ... ").toString());
            }
            InputStream in = (class$edu$umd$cs$findbugs$ba$interproc$PropertyDatabase == null ? (class$edu$umd$cs$findbugs$ba$interproc$PropertyDatabase = AnalysisContext.class$("edu.umd.cs.findbugs.ba.interproc.PropertyDatabase")) : class$edu$umd$cs$findbugs$ba$interproc$PropertyDatabase).getResourceAsStream(resourceName);
            database.read(in);
            return database;
        }
        catch (IOException e) {
            this.getLookupFailureCallback().logError(new StringBuffer().append("Error loading ").append(description).toString(), e);
        }
        catch (PropertyDatabaseFormatException e) {
            this.getLookupFailureCallback().logError(new StringBuffer().append("Invalid ").append(description).toString(), e);
        }
        return null;
    }

    public <DatabaseType extends PropertyDatabase<KeyType, Property>, KeyType extends ClassMember, Property> void storePropertyDatabase(DatabaseType database, String fileName, String description) {
        try {
            File dbFile = new File(this.getDatabaseOutputDir(), fileName);
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Writing ").append(description).append(" to ").append(dbFile.getPath()).append("...").toString());
            }
            database.writeToFile(dbFile.getPath());
        }
        catch (IOException e) {
            this.getLookupFailureCallback().logError(new StringBuffer().append("Error writing ").append(description).toString(), e);
        }
    }

    public final Map<Object, Object> getAnalysisLocals() {
        return this.analysisLocals;
    }

    public abstract InnerClassAccessMap getInnerClassAccessMap();

    public static void setCurrentAnalysisContext(AnalysisContext analysisContext) {
        currentAnalysisContext.set(analysisContext);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

