/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.URLClassPath;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLOutputUtil;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
implements XMLWriteable {
    private static final boolean DEBUG = SystemProperties.getBoolean("findbugs.project.debug");
    private String projectFileName = "<<unnamed project>>";
    private Map<String, Boolean> optionsMap = new HashMap<String, Boolean>();
    private LinkedList<String> fileList;
    private LinkedList<String> srcDirList;
    private LinkedList<String> auxClasspathEntryList;
    private boolean isModified;
    public static final String UNNAMED_PROJECT = "<<unnamed project>>";
    private long timestamp = 0L;
    private static final String OPTIONS_KEY = "[Options]";
    private static final String JAR_FILES_KEY = "[Jar files]";
    private static final String SRC_DIRS_KEY = "[Source dirs]";
    private static final String AUX_CLASSPATH_ENTRIES_KEY = "[Aux classpath entries]";
    public static final String RELATIVE_PATHS = "relative_paths";
    static final String JAR_ELEMENT_NAME = "Jar";
    static final String AUX_CLASSPATH_ENTRY_ELEMENT_NAME = "AuxClasspathEntry";
    static final String SRC_DIR_ELEMENT_NAME = "SrcDir";
    static final String FILENAME_ATTRIBUTE_NAME = "filename";
    private static final boolean FILE_IGNORE_CASE = SystemProperties.getProperty("os.name", "unknown").startsWith("Windows");

    public Project() {
        this.optionsMap.put(RELATIVE_PATHS, Boolean.FALSE);
        this.fileList = new LinkedList();
        this.srcDirList = new LinkedList();
        this.auxClasspathEntryList = new LinkedList();
        this.isModified = false;
    }

    public Project duplicate() {
        Project dup = new Project();
        dup.projectFileName = this.projectFileName;
        dup.optionsMap.clear();
        dup.optionsMap.putAll(this.optionsMap);
        dup.fileList.addAll(this.fileList);
        dup.srcDirList.addAll(this.srcDirList);
        dup.auxClasspathEntryList.addAll(this.auxClasspathEntryList);
        dup.timestamp = this.timestamp;
        return dup;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean isModified) {
        this.isModified = isModified;
    }

    public String getProjectFileName() {
        return this.projectFileName;
    }

    public void setProjectFileName(String projectFileName) {
        this.projectFileName = projectFileName;
    }

    public boolean addFile(String fileName) {
        return this.addToListInternal(this.fileList, Project.makeAbsoluteCWD(fileName));
    }

    public boolean addSourceDir(String dirName) {
        return this.addToListInternal(this.srcDirList, Project.makeAbsoluteCWD(dirName));
    }

    public boolean getOption(String option) {
        Boolean value = this.optionsMap.get(option);
        return value != null && value != false;
    }

    public int getFileCount() {
        return this.fileList.size();
    }

    public String getFile(int num) {
        return this.fileList.get(num);
    }

    public void removeFile(int num) {
        this.fileList.remove(num);
        this.isModified = true;
    }

    public List<String> getFileList() {
        return this.fileList;
    }

    public int getNumSourceDirs() {
        return this.srcDirList.size();
    }

    public String getSourceDir(int num) {
        return this.srcDirList.get(num);
    }

    public void removeSourceDir(int num) {
        this.srcDirList.remove(num);
        this.isModified = true;
    }

    public String[] getFileArray() {
        return this.fileList.toArray(new String[this.fileList.size()]);
    }

    public String[] getSourceDirArray() {
        return this.srcDirList.toArray(new String[this.srcDirList.size()]);
    }

    public List<String> getSourceDirList() {
        return this.srcDirList;
    }

    public boolean addAuxClasspathEntry(String auxClasspathEntry) {
        return this.addToListInternal(this.auxClasspathEntryList, Project.makeAbsoluteCWD(auxClasspathEntry));
    }

    public int getNumAuxClasspathEntries() {
        return this.auxClasspathEntryList.size();
    }

    public String getAuxClasspathEntry(int n) {
        return this.auxClasspathEntryList.get(n);
    }

    public void removeAuxClasspathEntry(int n) {
        this.auxClasspathEntryList.remove(n);
        this.isModified = true;
    }

    public List<String> getAuxClasspathEntryList() {
        return this.auxClasspathEntryList;
    }

    public List<String> getImplicitClasspathEntryList() {
        LinkedList<String> implicitClasspath = new LinkedList<String>();
        WorkList workList = new WorkList();
        for (String fileName : this.fileList) {
            try {
                URL url = workList.createURL(fileName);
                WorkListItem item = new WorkListItem(url);
                workList.add(item);
            }
            catch (MalformedURLException ignore) {}
        }
        while (!workList.isEmpty()) {
            WorkListItem item = workList.getNextItem();
            this.processComponentJar(item.getURL(), workList, implicitClasspath);
        }
        return implicitClasspath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processComponentJar(URL jarFileURL, WorkList workList, List<String> implicitClasspath) {
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Processing ").append(jarFileURL.toString()).toString());
        }
        if (!jarFileURL.toString().endsWith(".zip") && !jarFileURL.toString().endsWith(".jar")) {
            return;
        }
        try {
            URL manifestURL = new URL(new StringBuffer().append("jar:").append(jarFileURL.toString()).append("!/META-INF/MANIFEST.MF").toString());
            InputStream in = null;
            try {
                in = manifestURL.openStream();
                Manifest manifest = new Manifest(in);
                Attributes mainAttrs = manifest.getMainAttributes();
                String classPath = mainAttrs.getValue("Class-Path");
                if (classPath != null) {
                    String[] fileList;
                    for (String jarFile : fileList = classPath.split("\\s+")) {
                        URL referencedURL = workList.createRelativeURL(jarFileURL, jarFile);
                        if (!workList.add(new WorkListItem(referencedURL))) continue;
                        implicitClasspath.add(referencedURL.toString());
                        if (!DEBUG) continue;
                        System.out.println(new StringBuffer().append("Implicit jar: ").append(referencedURL.toString()).toString());
                    }
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String outputFile, boolean useRelativePaths, String relativeBase) throws IOException {
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        try {
            writer.println(JAR_FILES_KEY);
            for (String jarFile : this.fileList) {
                if (useRelativePaths) {
                    jarFile = this.convertToRelative(jarFile, relativeBase);
                }
                writer.println(jarFile);
            }
            writer.println(SRC_DIRS_KEY);
            for (String srcDir : this.srcDirList) {
                if (useRelativePaths) {
                    srcDir = this.convertToRelative(srcDir, relativeBase);
                }
                writer.println(srcDir);
            }
            writer.println(AUX_CLASSPATH_ENTRIES_KEY);
            for (String auxClasspathEntry : this.auxClasspathEntryList) {
                if (useRelativePaths) {
                    auxClasspathEntry = this.convertToRelative(auxClasspathEntry, relativeBase);
                }
                writer.println(auxClasspathEntry);
            }
            if (useRelativePaths) {
                writer.println(OPTIONS_KEY);
                writer.println("relative_paths=true");
            }
        }
        finally {
            writer.close();
        }
        this.isModified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String inputFile) throws IOException {
        if (this.isModified) {
            throw new IllegalStateException("Reading into a modified Project!");
        }
        File file = new File(inputFile);
        if (!file.isAbsolute()) {
            inputFile = file.getAbsolutePath();
        }
        this.setProjectFileName(inputFile);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(inputFile));
            String line = Project.getLine(reader);
            if (line == null || !line.equals(JAR_FILES_KEY)) {
                throw new IOException("Bad format: missing jar files key");
            }
            while ((line = Project.getLine(reader)) != null && !line.equals(SRC_DIRS_KEY)) {
                this.addToListInternal(this.fileList, line);
            }
            if (line == null) {
                throw new IOException("Bad format: missing source dirs key");
            }
            while ((line = Project.getLine(reader)) != null && !line.equals(AUX_CLASSPATH_ENTRIES_KEY)) {
                this.addToListInternal(this.srcDirList, line);
            }
            if (line != null) {
                while ((line = Project.getLine(reader)) != null && !line.equals(OPTIONS_KEY)) {
                    this.addToListInternal(this.auxClasspathEntryList, line);
                }
            }
            if (line != null && line.equals(OPTIONS_KEY)) {
                while ((line = Project.getLine(reader)) != null && !line.equals(JAR_FILES_KEY)) {
                    this.parseOption(line);
                }
            }
            if (this.getOption(RELATIVE_PATHS)) {
                this.makeListAbsoluteProject(this.fileList);
                this.makeListAbsoluteProject(this.srcDirList);
                this.makeListAbsoluteProject(this.auxClasspathEntryList);
            }
            this.isModified = false;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static String getLine(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && ((line = line.trim()).equals("") || line.startsWith("#"))) {
        }
        return line;
    }

    public String toString() {
        int dot;
        String name = this.projectFileName;
        int lastSep = name.lastIndexOf(File.separatorChar);
        if (lastSep >= 0) {
            name = name.substring(lastSep + 1);
        }
        int n = dot = name.endsWith(".fb") ? name.length() - 3 : -1;
        if (dot >= 0) {
            name = name.substring(0, dot);
        }
        return name;
    }

    public static String transformFilename(String fileName) {
        if (!fileName.endsWith(".fb")) {
            fileName = new StringBuffer().append(fileName).append(".fb").toString();
        }
        return fileName;
    }

    @Override
    public void writeXML(XMLOutput xmlOutput) throws IOException {
        xmlOutput.openTag("Project", new XMLAttributeList().addAttribute(FILENAME_ATTRIBUTE_NAME, this.getProjectFileName()));
        XMLOutputUtil.writeElementList(xmlOutput, JAR_ELEMENT_NAME, this.fileList);
        XMLOutputUtil.writeElementList(xmlOutput, AUX_CLASSPATH_ENTRY_ELEMENT_NAME, this.auxClasspathEntryList);
        XMLOutputUtil.writeElementList(xmlOutput, SRC_DIR_ELEMENT_NAME, this.srcDirList);
        xmlOutput.closeTag("Project");
    }

    private void parseOption(String option) throws IOException {
        int equalPos = option.indexOf("=");
        if (equalPos < 0) {
            throw new IOException("Bad format: invalid option format");
        }
        String name = option.substring(0, equalPos);
        String value = option.substring(equalPos + 1);
        this.optionsMap.put(name, Boolean.valueOf(value));
    }

    private String convertToRelative(String srcFile, String base) {
        String subPath;
        String root;
        String slash = SystemProperties.getProperty("file.separator");
        if (FILE_IGNORE_CASE) {
            srcFile = srcFile.toLowerCase();
            base = base.toLowerCase();
        }
        if (base.equals(srcFile)) {
            return ".";
        }
        if (!base.endsWith(slash)) {
            base = new StringBuffer().append(base).append(slash).toString();
        }
        if (base.length() <= srcFile.length() && (root = srcFile.substring(0, base.length())).equals(base)) {
            return new StringBuffer().append(".").append(SystemProperties.getProperty("file.separator")).append(srcFile.substring(base.length())).toString();
        }
        int slashPos = srcFile.indexOf(slash);
        if (slashPos >= 0 && ((subPath = srcFile.substring(0, slashPos)).length() == 0 || base.startsWith(subPath))) {
            int branchPoint = slashPos + 1;
            slashPos = srcFile.indexOf(slash, branchPoint);
            while (slashPos >= 0 && base.startsWith(subPath = srcFile.substring(0, slashPos))) {
                branchPoint = slashPos + 1;
                slashPos = srcFile.indexOf(slash, branchPoint);
            }
            int slashCount = 0;
            slashPos = base.indexOf(slash, branchPoint);
            while (slashPos >= 0) {
                ++slashCount;
                slashPos = base.indexOf(slash, slashPos + 1);
            }
            StringBuffer path = new StringBuffer();
            String upDir = new StringBuffer().append("..").append(slash).toString();
            for (int i = 0; i < slashCount; ++i) {
                path.append(upDir);
            }
            path.append(srcFile.substring(branchPoint));
            return path.toString();
        }
        return srcFile;
    }

    private String convertToAbsolute(String fileName) throws IOException {
        File projectFile;
        File file = new File(fileName);
        if (!file.isAbsolute() && (projectFile = new File(this.projectFileName)).isAbsolute()) {
            String base = new File(this.projectFileName).getParent();
            fileName = new File(base, fileName).getCanonicalPath();
        }
        return fileName;
    }

    private static String makeAbsoluteCWD(String fileName) {
        boolean hasProtocol;
        File file = new File(fileName);
        boolean bl = hasProtocol = URLClassPath.getURLProtocol(fileName) != null;
        if (!hasProtocol && !file.isAbsolute()) {
            fileName = file.getAbsolutePath();
        }
        return fileName;
    }

    private boolean addToListInternal(List<String> list, String value) {
        if (!list.contains(value)) {
            list.add(value);
            this.isModified = true;
            return true;
        }
        return false;
    }

    private void makeListAbsoluteProject(List<String> list) throws IOException {
        LinkedList<String> replace = new LinkedList<String>();
        for (String fileName : list) {
            fileName = this.convertToAbsolute(fileName);
            replace.add(fileName);
        }
        list.clear();
        list.addAll(replace);
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void addTimestamp(long timestamp) {
        if (this.timestamp < timestamp) {
            this.timestamp = timestamp;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private static class WorkList {
        private LinkedList<WorkListItem> itemList = new LinkedList();
        private HashSet<String> addedSet = new HashSet();

        public URL createURL(String fileName) throws MalformedURLException {
            String protocol = URLClassPath.getURLProtocol(fileName);
            if (protocol == null) {
                fileName = "file:" + fileName;
            }
            return new URL(fileName);
        }

        public URL createRelativeURL(URL base, String fileName) throws MalformedURLException {
            return new URL(base, fileName);
        }

        public boolean add(WorkListItem item) {
            if (DEBUG) {
                System.out.println("Adding " + item.getURL().toString());
            }
            if (!this.addedSet.add(item.getURL().toString())) {
                if (DEBUG) {
                    System.out.println("\t==> Already processed");
                }
                return false;
            }
            this.itemList.add(item);
            return true;
        }

        public boolean isEmpty() {
            return this.itemList.isEmpty();
        }

        public WorkListItem getNextItem() {
            return this.itemList.removeFirst();
        }
    }

    private static class WorkListItem {
        private URL url;

        public WorkListItem(URL url) {
            this.url = url;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

